<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  05/04/11, 11:49
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/


/**
  Interface generic module aca
*/
interface mod_aca {
  public function load_db_values($Id);
  public function load_post_values($post);
}


/**
  Interface des class de configuration, pour en assurer la stabilité et coherance

  NOTE:: Tous les module de configuration utilisé doivent porter "implements mod_configuration"
*/
interface ext_configuration  {
    public function load_db_values($Id);
    public function draw_action();
    public static function draw_header();
    public function draw();
}

/**
  Element obligatoire des module de type pages
  Specific BO
*/
interface ExtModPage  {
    public static function load_db_values($ID);
    public function display_view();
    public function check_action($actions);
    public function get_header();
}

/**
  Interface des module de page, utilisant l'ajax pour traiter le listing
*/
Interface InterfacedTJsonS {
  public static function tep_get_modele();
  public static function tep_get_list();
}

/**
  Interface des module de page, utilisant l'ajax afficher detail d'une ligne d'un point
*/
Interface InterfacedInnerHtml {
  public static function detail_row_page($ID);
}


Interface InterfaceNewsletters {
  public function get_content();
  public function confirm();
  public function send($max=20);
}


/**
  @brief Interface for module type cronjob and Execution, base module ; Force function exists,
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
*/
Interface IntModCronJob {
  /**
    @fn ClassExec()
    @brief method call by cron file. this it THE METHODE CRON
  */
  public function ClassExec($value);
}

/**
  @brief Interface for module type cronjob and require extra fields configuration ; Force function exists,
	  Just for module cronjob for configuration possible
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
*/
Interface IntModCronJobConfig {
  /**
    @fn insert($post)
    @brief method call by action insert in modules/page/cronjob , adjust extra for this module
    @param $post array POST vars
    @return $string serialise for extra db fields
  */
  public function insert($post);
  /**
    @fn update($post)
    @brief method call by action update in modules/page/cronjob , adjust extra for this module
    @param $post array POST vars
    @return $string serialise for extra db fields
  */
  public function update($post);
  /**
    @brief methode return key config module
  */
  public function keys();
  /**
    @brief help for this module
    @return string;
  */
  public function help();
  /**
    @fn Config($value)
    @brief methode for complete config cronmodule, by use extra fields db
    @param $value string serialized, extract in extar fields db
    @return array for use lib.configuration.php functions
  */
  public function Config($value);
}

/**
  @Interface DriversGraphs
  @brief Force structure Drivers extends for construct img graphs
      The module form is name: drivers_XXXX
      depend class GraphUtility
*/
Interface DriversGraphs {
  /**
    @brief load and conststrcu base call for PHPlot graphs
    @param $Child string name grpah_stats Module type init
    @param $option array option
    @return path img
  */
  public function CallConfig($Child,$option=array());
  /**
    @fn $var->CallGraph();
    @brief Call result construct graphs
    @return path img or null
  */
  public function CallGraph();
}

/**
  @brief force structure of module Data type graph_stats
*/
Interface ModGraphStatsData{
  /**
    define var for use by externe call
    @var nombre de status de order present
      public $nbr_val;
    @var tableau de couleur de status
      public $les_color;
    @var tableau de couleur de status
      public $base_date;
    @var calcul taille repere y
      public $base_y;
    @var title
      public $title;
    @var value array value
      public $value;

    This __construct is required !
  */

  /**
    @brief construct thead table
	  return array for foreach boucle in display
  */
  public function tep_get_th();
  /**
    @brief construct array value for datatable display
	  Use by call dataTable ajax call (dataTable js module jquery)
	  return array data, for convert json
  */
  public function tep_get_list($page=1,$rowbyp=10,$sOrder='',$sWhere='',$options='');
}

/**
  Just define class for use module public configuration
*/
class AbstractAccount {}
?>