<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  23/04/11, 09:55
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

/**
  @class Graph
  @brief Master class for module graph_stats
*/
class GraphUtility
{
  const WS_MOD_GRAPH_STATS = 'graph_stats/';

  const NAME_DRIVER = 'drivers';
  /**
    @var Driver par defaut
  */
  public static $driver = 'PHPlot';
  /**
    @var Graph par defaut
  */
  public static $graph = 'Sales';
  /**
    @var Ratio graph width / height
  */
  public static $ratio = '1/3';
  /**
    @var Extension graph
  */
  public static $_extension = 'png';

  /**
    @var name childs object
  */
  public static $modChilds;




  /**
    @brief function for centralise call graphs
    @param $class string name Childs class call
    @param $mini boolean mode
    @return path img
  */
  static public function CallGraph($class, $mini=false){

    $class=(!empty($class) ? $class : self::$graph );

    $Driver=self::CallSupportGraph(self::$driver);

    self::$modChilds=self::CallChilds($class);


    $width=$width=isset($_REQUEST['width'])? ((int)$_REQUEST['width']) : 200 ;
    eval('$ratio = ('.self::$ratio.');');
    $height=($width * $ratio);
    $PathImgCache=DIR_WS_IMAGES . 'graphs/'.$class.'-' . $width .'.'. self::$_extension;

    $Driver->CallConfig($class,array(
				    'mini'=>(bool)$mini,
				    'width'=>$width,
				    'height'=>$height,
				    'PathImgCache'=>$PathImgCache
				    )
			);

    return $Driver->CallGraph();
  }




  /**
    @brief loader for Childs class graph
    @param $class string name Childs class call
  */
  private static function CallChilds($class){
    if(!class_exists($class)){
      global $language,$oscss;
      $oscss->pile_file_lang(DIR_FS_ADMIN.DIR_WS_LANGUAGES.$language.'/modules/'.self::WS_MOD_GRAPH_STATS.'/'.$class.'.txt');

      require_once(DIR_WS_MODULES.self::WS_MOD_GRAPH_STATS.$class.'.php');
    }
    return new $class();
  }

  /**
    @brief loader for support class graph
    @param $support string name drivers
  */
  private static function CallSupportGraph($support){

    require_once(DIR_WS_INCLUDES.'exts/'.$support.'/'.self::NAME_DRIVER.'.php');
    $driver=self::NAME_DRIVER.'_'.$support;

    return new $driver();
  }


  /**
    @fn graph_stats::html2rgb($color)
    @brief Use by cilds module ; convertion color
  */
  public static function html2rgb($color) {
      if ($color[0] == '#')
	  $color = substr($color, 1);

      if (strlen($color) == 6)
	  list($r, $g, $b) = array($color[0].$color[1],
				  $color[2].$color[3],
				  $color[4].$color[5]);
      elseif (strlen($color) == 3)
	  list($r, $g, $b) = array($color[0].$color[0], $color[1].$color[1], $color[2].$color[2]);
      else
	  return false;

      $r = hexdec($r); $g = hexdec($g); $b = hexdec($b);

      return array($r, $g, $b);
  }

}
?>