<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  26/04/11, 16:51
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class MGabCont
  @brief Master Gabarit Content Loader
	Use path gab by var:
	  - class
	  - function
	  - action
*/
class MGabCont
  {

  /**
    @var Folder files gabarit
  */
  const FOLDER = 'gabarit/';

  /**
    @var Extention fichier gabarit
  */
  const EXT = '.gab';

  /**
    @var Public
  */
  public static $Object;
  /**
    @var Ref Name (class name) , default:false
  */
  public static $Name=false;
  /**
    @var Ref Name (class name) , default:false
  */
  public static $Folder=false;
  /**
    @var Ref function (name function call ) , default:false
  */
  public static $function=false;
  /**
    @var Ref action (name action GET/POST var) , default:false
  */
  public static $action=false;

  public static $_instance;


  /**
    @brief constructor
  */
  protected function __construct(){
  }


  /**
    @brief getInstance function
  */
  public static function getInstance() {
    if(self::$_instance == null)  self::$_instance = new self();
    return self::$_instance;
  }


  /**
    @brief define current name class Childs
  */
  public static function SetCurrentName($class){
    self::$Name=$class;
  }


  /**
    @brief define current Object  Childs
  */
  public static function SetCurrentClass($Object){
    self::$Object=$Object;
  }


  /**
    @brief Call Childs methode
	  Use in gabarit file
  */
  public static function Call($method,$arg=''){
    if(self::$Name===false)return false;

    return call_user_func(self::$Name, $method, $arg);
  }


  /**
    @brief Call Childs static methode
	  Use in gabarit file
  */
  public static function CallSt($method,$arg=''){
    if(self::$Name===false) return false;

    return call_user_func(array(self::$Name, $method), $arg);
  }


  /**
    @brief Call file gabarit
      Used in module file
  */
  public static function CallGab($arg1,$arg2='',$arg3=''){

    if(!empty($arg2)){
      /// @remarks By Master Gabarit Load
      if(!empty($arg3)){
	self::$Folder=$arg3;
	self::$function=$arg2;
	if(self::$Name===false)self::$Name=$arg3;
      }

      self::$action=$arg1;

      $path= self::LevelPath();
    }
    else {
      /// @remarks By unique type Gabarit Load
      $path=  self::LevelPath($arg1);
    }

    return ($path===false)? false : self::LoadPath($path);
  }

  /**
    @fn self::LoadPath($path);
    @brief load include file
    @return ob_get_contents()
  */
  private static function LoadPath($filename){

    $Mod=self::getInstance();
    $Object=self::$Object;

    if (is_file($filename)) {
	ob_start();
	include $filename;
	$contents = ob_get_contents();
	ob_end_clean();
	return $contents;
    }
    return false;
  }

  /**
    @fn self::LevelPath($filename=false);
    @brief check file for
		/type/filename.gab
		/filename.gab
    @return path or bool false
  */
  private static function LevelPath($filename=false){

    if($filename===false){
      // pdocut/function.action.gab
      $folder=((self::$Folder===false)?'':self::$Folder.'/');
      $function=self::$function.'.';
      $filename=self::$action;
    }
    else{
      $folder='';
      $function='';
      $filename=$filename;
    }
    $file=DIR_WS_INCLUDES.self::FOLDER.$folder.$function.$filename.self::EXT ;
    if(oscss_cstr::TestFile($file)) return $file;
    $file=DIR_WS_INCLUDES.self::FOLDER.$filename.self::EXT ;
    if(oscss_cstr::TestFile($file)) return $file;

    return false;
  }
}

?>
