<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package oscss-2 <www http://www.oscss.org>
  @version 2.0.9h
  @date  06/06/10, 09:22
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class generic

*/



class generic
  extends aca
    implements mod_aca {
  var $modules =array();
  var $generic_id;
  var $image_handler;

  protected static $_instance;

  /**
    class constructor
  */
  function __construct() {
    global $language, $languages_id, $lang,$oscss;

    $this->name='generic';
    $this->generic_id='';
    $this->image_handler='';
    foreach(parent::initialise_type('MODULE_GENERIC_INSTALLED_BO','generic') as $class){

	$cl[$class]=new $class ();
	$list_mod[$class] = $cl[$class]->sort_order;

	asort($list_mod);
	foreach($list_mod as $class=>$s){
	  $this->modules[$class] =$cl[$class];
	}
    }
  }

  public function ret_modules ($action){ return $this->modules;}

  public function display_view (&$contents){ return false;}

  /**
    Find which module will take care of saving images
    $handler is optional and can be used to force an image handler
  */
  public function set_image_handler ($handler='') {  }


  /**
  */
  public function after_update ($generic_id){
    $this->generic_id=$generic_id;
    foreach ($this->modules as $key=>$module) {
      if (($module->enabled) and (method_exists($module,'after_update' )))
	$this->modules[$key]->after_update($this->generic_id);
    }
    $languages = tep_get_languages();
    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
      $language_id = $languages[$i]['id'];
      foreach ($this->modules as $key=>$module) {
	if (($module->enabled) and (method_exists($module,'after_update_lang' )))
	  $this->modules[$key]->after_update_lang($language_id, $this->generic_id);
      }
    }
  }



  /**
    Load each module parameters from database
  */
  public function load_db_values ($Id) {
    global $language, $languages_id;
    $this->generic_id=$Id;
    foreach ( $this->modules as $key=>$module) {
      if (($module->enabled) and  method_exists($module, 'load_db_values' ))  $this->modules[$key]->load_db_values($Id);
    }
    return true;
  }

  /**
    Load each module parameters from the  POST variables
  */
  public function load_post_values ($post) {
    $post = $this->check_post_array ($post);
    $this->generic_id = @$_GET['pID']; // Save the product ID
    foreach ($this->modules as $key=>$module) {
      if (($module->enabled) and (method_exists($module, 'load_post_values' )) and (isset($post[$module->code])))
	$this->modules[$key]->load_post_values($post[$module->code]);
    }
  }


  public function display_image_preview (){
    // Returns the image path and name to show in the product preview
    return $this->modules[$this->image_handler]->display_image_preview ();
  }

}

?>