<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @original_licence Copyright (c) 2006 osCommerce
  @original_author  products class for ACA v2 (Advanced Categories Admin) by Rigadin2, www.osc-help.net
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  07/02/2011, 17:47
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class aca
*/



 Abstract class aca {
  /**
    Tableau d'objet des module actif
  */
  var $modules;

  protected static $_instance;

  /**
    class constructor
  */
  function __construct() {
    global $language;
    $this->name=__CLASS__;
    $this->modules=array();
    $this->image_handler='';
  }


  protected function after_update ($Id){}
  protected function load_db_values($Id){}
  protected function display_view(&$contents){}


  /**
    @brief  Appel magic
    @param $method string
    @param $attrs array
  */
  public function __call($method, $attrs) {
    $r=array();
    foreach ($this->modules as $key=>$module) {
      if (method_exists($module, $method )) /// control presence method
	$r[]=$this->modules[$key]->$method($attrs);
    }

    return $r;
  }


  /**
    Initialisze module complementaire
    @param
      @a string $cst Constante
      @a string $folder
    @global
      @e object $oscss
      @a string $language

    @return array
  */
  static function initialise_type($cst, $folder){
    global $oscss,$language;
    $messageStack = messageStack::getInstance();
    $list_mod=array();
    if(defined($cst)){
      $files_array=explode (';',constant($cst));
      if (tep_not_null($files_array[0])) {
	reset ($files_array);
	while (list ($key, $file) = each ($files_array)) {
	  $file=trim($file);
	  $class=substr($file,0, strlen($file)-4 );
	  if (!empty($class)) {
	    //! NOTE: Retro compatibilite
	    $filename=DIR_WS_INCLUDES .'languages/'. $language . '/modules/'.$folder.'/' . $file;
	    if(oscss_cstr::TestFile($filename)) include($filename);
	    // Includes language file if exists
	    $oscss->pile_file_lang(DIR_WS_INCLUDES .'languages/'. $language . '/modules/'.$folder.'/' . $class.'.txt');
	    if(!class_exists($class) && oscss_cstr::TestFile(DIR_WS_MODULES . $folder.'/' . $file)){
	      include(DIR_WS_MODULES . $folder.'/' . $file);
	      $list_mod[]=$class;
	    }
	    elseif(!class_exists($class) ) {
	      $messageStack->add(sprintf(__('ACA class type "%s" no found  for ::%s '),__CLASS__,$class), 'error');
	      continue;
	    }
	    else $list_mod[]=$class;
	  }
	}
      }
    }

    return $list_mod;
  }

  /**
    Block de contructeur du menu / modules
    Cherche des methode dans les module _add_menu
  */
  public function _show_menu ($formats="<li>%s</li>") {
    $menu='';
    if (is_array($this->modules))
    foreach ($this->modules as $key=>$module)  {
      if ($module->enabled && method_exists($module, '_add_menu' )) {
        $menu.=sprintf($formats,$this->modules[$key]->_add_menu() );
      }
    }
    return $menu;
  }

  /**
    Allows modules to write something in header (javascript for example)
  */
  function get_header_js ($action) {
    $sql_module="";
    foreach ($this->modules as $key=>$module)
      if (($module->enabled) and (method_exists($module, 'get_header_js' )))
        $sql_module .= $this->modules[$key]->get_header_js($action);

    return $sql_module;
  }

  /**
    Modif $action
  */
  function check_action ($actions){
    if (is_array($this->modules ))
    foreach ($this->modules as $key=>$module)
      if ($module->enabled && method_exists($module, 'check_action' ))
        $actions= $this->modules[$key]->check_action($actions);

    return $actions;
  }


  /**
    Insert db primaire
    Ask each module what to insert into table
  */
  function insert_table_prim () {
    $sql_data_array=array();
    foreach ($this->modules as $key=>$module) {
      if (($module->enabled) and (method_exists($module, 'insert_table_prim' ))) {
	$sql_module= $this->modules[$key]->insert_table_prim();
	$sql_data_array=array_merge ($sql_data_array, $sql_module);
      }
    }
    return $sql_data_array;
  }

  /**
    Insert db table secondaire
  */
  function insert_table_second () {
    $sql_data_array=array();
    foreach ($this->modules as $key=>$module) {
      if (($module->enabled) and (method_exists($module, 'insert_table_second' ))) {
	$sql_module= $this->modules[$key]->insert_table_second();
	$sql_data_array=array_merge ($sql_data_array, $sql_module);
      }
    }
    return $sql_data_array;
  }

  /**
    Update db primaire
  */
  function update_table_prim (){
    $sql_data_array=array ();
    foreach ($this->modules as $key=>$module) {
      if (($module->enabled) and (method_exists($module,'update_table_prim' ))) {
	$sql_module= $this->modules[$key]->update_table_prim();
	$sql_data_array=array_merge ($sql_data_array, $sql_module);
      }
    }
    return $sql_data_array;
  }

  /**
    Update db secondaire
  */
  function update_table_second (){
    $sql_data_array=array ();
    foreach ($this->modules as $key=>$module) {
      if (($module->enabled) and (method_exists($module,'update_table_second' ))) {
	$sql_module= $this->modules[$key]->update_table_second();
	$sql_data_array=array_merge ($sql_data_array, $sql_module);
      }
    }
    return $sql_data_array;
  }

  /**
    Find which module will take care of saving images
    $handler is optional and can be used to force an image handler
  */
  function set_image_handler () {
    foreach ($this->modules as $key=>$module) {
      if ($module->enabled && method_exists($module,'set_image_handler' ))
        $this->modules[$key]->set_image_handler($this->image_handler); // Ask modules for handling image
    }
    if ($this->image_handler!='')
      $this->modules[$this->image_handler]->is_image_handler=true; // Inform choosen handler module that it is choosen

  }


  /**
    Load each module parameters from the  POST variables
  */
  function load_post_values ($post) {
    global $_POST;
    $post=$this->check_post_array($_POST);
    foreach ($this->modules as $key=>$module)
      if (($module->enabled) and(method_exists($module, 'load_post_values' )))
	$this->modules[$key]->load_post_values($post);
  }

  /**
    Repost all modules parameters to the  POST variables
  */
  function repost_values (){
    foreach ($this->modules as $key=>$module) {
      if (($module->enabled) and (method_exists($module, 'repost_values' ))) $this->modules[$key]->repost_values();
    }
  }

  /**
    Tabs in products
    Ask each module about what to dispay in the product editor of each module.
  */
  function display_edit (&$contents,$id) {
    foreach ($this->modules as $key=>$module)  {
      if ($module->enabled && method_exists($module, 'display_edit' )) $this->modules[$key]->display_edit($contents,$id);
    }
    return $contents;
  }

  /**
    Collect datas for product preview display
  */
  function display_preview($languages){
    $contents = array();
    foreach ($this->modules as $key=>$module)
      if (($module->enabled) and (method_exists($module, 'display_preview' )))
        $this->modules[$key]->display_preview($contents, $languages);

    return $contents;
  }

  function display_image_preview (){
    // Returns the image path and name to show in the product preview
    return $this->modules[$this->image_handler]->display_image_preview ();
  }




  /**
    Affichage en mode liste, detail, colonne droite
    Ask each product module about what to dispay in the listing left column.
  */
  public function display_right_column ($contents, $id) {
    if (is_array($this->modules))
    foreach ($this->modules as $key=>$module)  {
      if ($module->enabled && method_exists($module, 'display_right_column' )) {
	$this->modules[$key]->load_db_values($id);
	$contents=$this->modules[$key]->display_right_column($contents, $id);
      }
    }
    return $contents;
  }

//   public function display_left_column_rowaction ($contents, $id) {
//     if (is_array($this->modules))
//     foreach ($this->modules as $key=>$module)  {
//       if ($module->enabled && method_exists($module, 'display_left_column_rowaction' )) {
// 	$this->modules[$key]->load_db_values($id);
// 	$contents.=$this->modules[$key]->display_left_column_rowaction($contents, $id);
//       }
//     }
//     return $contents;
//   }

  /**
    @fn display_ColumnRowAction ( $id)
    @brief Affichage dans la liste central colonne action, via les methode get_item_action
    @param $id
    @return string
  */
  public function display_ColumnRowAction($id){
    $st='';
    foreach ($this->modules as $key=>$module)
      if (($module->enabled) and (method_exists($module,'display_ColumnRowAction' )))
	$st .=$this->modules[$key]->display_ColumnRowAction($id);
    return $st;
  }

  /**
    Block confirmation de suppression
    Colonne droite
  */
  public function display_right_delete_confirm ($contents, $id) {
    if (is_array($this->modules))
    foreach ($this->modules as $key=>$module)  {
      if ($module->enabled && method_exists($module, 'display_right_delete_confirm' )) {
        $this->modules[$key]->load_db_values($id);
        $contents=$this->modules[$key]->display_right_delete_confirm($contents, $id);
      }
    }
    return $contents;
  }

  /**
    Return tableau complet des element à insrére dans la clause sql
  */
  public function shearch_in_product(){
    $contents=array();
    if (is_array($this->modules))
    foreach ($this->modules as $key=>$module)
	if ($module->enabled && method_exists($module, 'shearch_in_product' ))
	  $contents[$key]=$this->modules[$key]->shearch_in_product();
   return $contents;
  }


//=====================================================
// PRIVATE METHODS
//=====================================================

  function check_post_array ($post){
  /**
    Some variables can't be posted in a form of an array, I got problems with some JS
  So those variables names are built so: array name, double underscore, array index.
  Example: "$post[products_ms2__date_available] would be transformed to
  $post[products_ms2][date_available], compatible with modules use.
  */
    foreach ($post as $key=>$value){
      if (!is_array($value) && preg_match('/__/',$key)) {
	$arr = explode ("__",$key);
	    $post[$arr[0]][$arr[1]]=$value;
	    unset ($post[$key]);
      }
    }
    return $post;
  }

  /**
    Debug: show all modules names that are registered.
  */
  function show_registered_modules() {
    //
    foreach ($this->modules as $key=>$module) {
      echo $module->code.'<br />';
    }
  }

}
?>