<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  Copyright phpMyAdmin (select_lang.lib.php3 v1.24 04/19/2002)
  Copyright Stephane Garin <sgarin@sgarin.com> (detect_language.php v0.1 04/02/2002)
  @package oscss-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  22/08/10, 09:26
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class categorieUtility
*/
class categorieUtility {


  /**
    Construction tableau recap des categories, fonction recusrive
    @package oscss-codev
    @author oscim - <mail aurelien@oscim.fr> <www http://www.oscim.fr>
    @version 1.0
    @param
      @a int l'id de la categorie root
      @a bool/int false par defaut, entier du niveau de la branche si appel recursif
  */
  public static function get_cat_list($current_ID='',$incre=false){
    global $languages_id, $current_category_id;
    $cat=array();
    $niv=($incre ==false)? 0 : $incre++ ;
    $search = (isset($_GET['search'])) ? "and cd.categories_name like '%" .tep_db_prepare_input($_GET['search']). "%' " : '' ;

    $categories_query = tep_db_query("select c.categories_id, cd.categories_name, c.categories_image, c.parent_id, c.sort_order, c.date_added, c.last_modified,c.categories_status,c.categories_hidden, cd.categories_description, cd.categories_head_keywords_tag from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.parent_id = '" . (int)(empty($current_ID)?$current_category_id:$current_ID ) . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "' ".$search." order by  c.parent_id ASC , c.sort_order ASC, cd.categories_name ASC");

    while ($categories = tep_db_fetch_array($categories_query)){
	$nbr=tep_childs_in_category_count($categories['categories_id']);
	$cat[]=array_merge($categories, array('childs_count' => $nbr, 'niveau'=>$niv) );
	$niv++;
	if($nbr !=0) $cat=array_merge($cat,(array)get_cat_list($categories['categories_id'], $niv) );
	$niv--;
      }

    return $cat;
  }

  /**
    Count how many subcategories exist in a category
    TABLES: categories
    @package oscss-2 <www http://www.oscss.org>
    @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
    @param
      @a int l'id de la categorie parent
  */
  public static function childs_in_category_count($categories_id) {
    $categories_count = 0;
    $categories_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$categories_id . "'");
    while ($categories = tep_db_fetch_array($categories_query)) {
      $categories_count++;
      $categories_count += tep_childs_in_category_count($categories['categories_id']);
    }

    return $categories_count;
  }

  /**
    Calcul et mise en forme du cpath
    @package oscss
    @author oscim - OscssTeam
    @return string (10_15 ou  8)
  */
  public static function get_generated_category_path_ids($id, $from = 'category') {
    $calculated_category_path_string = '';
    $calculated_category_path = tep_generate_category_path($id, $from);
    for ($i=0, $n=sizeof($calculated_category_path); $i<$n; $i++) {
      for ($j=0, $k=sizeof($calculated_category_path[$i]); $j<$k; $j++) {
	$calculated_category_path_string .= $calculated_category_path[$i][$j]['id'] . '_';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -1);
    }
    if (strlen($calculated_category_path_string) < 1) $calculated_category_path_string = 0;
    return $calculated_category_path_string;
  }



  public static function get_category_tree($parent_id = '0', $spacing = '', $exclude = '', $category_tree_array = '', $include_itself = false) {
    global $languages_id;

    if (!is_array($category_tree_array)) $category_tree_array = array();
    if ( (sizeof($category_tree_array) < 1) && ($exclude != '0') ) $category_tree_array[] = array('id' => '0', 'text' => TEXT_TOP);

    if ($include_itself) {
      $category_query = tep_db_query("select cd.categories_name from " . TABLE_CATEGORIES_DESCRIPTION . " cd where cd.language_id = '" . (int)$languages_id . "' and cd.categories_id = '" . (int)$parent_id . "'");
      $category = tep_db_fetch_array($category_query);
      $category_tree_array[] = array('id' => $parent_id, 'text' => $category['categories_name']);
    }

    $categories_query = tep_db_query("select c.categories_id, cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "' and c.parent_id = '" . (int)$parent_id . "' order by c.sort_order, cd.categories_name");
    while ($categories = tep_db_fetch_array($categories_query)) {
      if ($exclude != $categories['categories_id']) $category_tree_array[] = array('id' => $categories['categories_id'], 'text' => $spacing . $categories['categories_name']);
      $category_tree_array = tep_get_category_tree($categories['categories_id'], $spacing . '&nbsp;&nbsp;&nbsp;', $exclude, $category_tree_array);
    }

    return $category_tree_array;
  }

  /**
  Parse and secure the cPath parameter values
    @package  oscss
    @author OscssTeam
  */
  public static function parse_category_path($cPath) {
    // make sure the category IDs are integers
    $cPath_array = array_map('tep_string_to_int', explode('_', $cPath));

    // make sure no duplicate category IDs exist which could lock the server in a loop
    $tmp_array = array();
    $n = sizeof($cPath_array);
    for ($i=0; $i<$n; $i++) {
      if (!in_array($cPath_array[$i], $tmp_array)) $tmp_array[] = $cPath_array[$i];
    }
    return $tmp_array;
  }

  /**
    @brief get name categorie, by id
    @param $category_id int
    @param $language_id int
  */
  public static function get_category_name($category_id, $language_id) {
    global $languages_id;

    $lg=(empty($language_id)) ? $languages_id :$language_id ;

    $category_query = tep_db_query("select categories_name from " . TABLE_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "' and language_id = '" . (int)$lg . "'");
    $category = tep_db_fetch_array($category_query);

    return $category['categories_name'];
  }

  /**
      @package oscss
      @author  OscssTeam
  */
  public static function generate_category_path($id, $from = 'category', $categories_array = '', $index = 0) {
    global $languages_id;

    if (!is_array($categories_array)) $categories_array = array();

    if ($from == 'product') {
      $categories_query = tep_db_query("select categories_id from " . TABLE_PRODUCTS_TO_CATEGORIES . " where products_id = '" . (int)$id . "'");
      while ($categories = tep_db_fetch_array($categories_query)) {
	if ($categories['categories_id'] == '0') {
	  $categories_array[$index][] = array('id' => '0', 'text' => TEXT_TOP);
	} else {
	  $category_query = tep_db_query("select cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = '" . (int)$categories['categories_id'] . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "'");
	  $category = tep_db_fetch_array($category_query);
	  $categories_array[$index][] = array('id' => $categories['categories_id'], 'text' => $category['categories_name']);
	  if ( (tep_not_null($category['parent_id'])) && ($category['parent_id'] != '0') ) $categories_array = tep_generate_category_path($category['parent_id'], 'category', $categories_array, $index);
	  $categories_array[$index] = array_reverse($categories_array[$index]);
	}
	$index++;
      }
    } elseif ($from == 'category') {
      $category_query = tep_db_query("select cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = '" . (int)$id . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "'");
      $category = tep_db_fetch_array($category_query);
      $categories_array[$index][] = array('id' => $id, 'text' => $category['categories_name']);
      if ( (tep_not_null($category['parent_id'])) && ($category['parent_id'] != '0') ) $categories_array = tep_generate_category_path($category['parent_id'], 'category', $categories_array, $index);
    }

    return $categories_array;
  }
}
?>
