<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  23/04/11, 09:55
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @brief class librairie for config action
  @class configUtility
*/

class configUtility{

  /**
    @fn configUtility::FormatEditAuto($value_array)
    @brief use for edit config , this format is it table configuration
    @param $value_array array
      format: [string] => string for direct display
	      [array]
		[KEY](col configuration_key) => array
						[title]=> string
						[description]=> string
						[set_function]=> string eval for display select format "function([],"
						[use_function]=> string eval for display value human transit format "function"
						[value]=> string|int  (max 250 in table configuration, no max in extra fields)
	      [format] => array
			  [block] => string default: <p class="block_input button_nav">%s</p><br />
			  [label] => string default: <label>%s</label>
			  [description] => string default: <br />%s<br />
			  [value_edit] => string default: <span class="value_edit">%s</span>
			  [view_view] => string default: <label>%s</label>
    @return string
  */
  static public function FormatEditAuto($value_array){
    $sortie=$keys=$key2='';
    $use_format=(isset($value_array['format'])? $value_array['format'] :false);

    if(isset($value_array['string'])) return '<div class="block_input">'.$value_array['string'].'</div>';
    else
    foreach($value_array['array'] as $key=>$value){

      $keys =sprintf( ($use_format !=false && isset($use_format['label'])? $use_format['label'] : '<label>%s</label>' ) ,  $value['title']);
      $keys .=sprintf( ($use_format !=false && isset($use_format['description'])? $use_format['description'] : '<br />%s<br />' ) , $value['description']);

      $key2 =self::CallExecConfigLine($value['set_function'], $key, $value['value']);
      $keys .=sprintf( ($use_format !=false && isset($use_format['value_edit'])? $use_format['value_edit'] : '<span class="value_edit">%s</span>' ) , $key2);


      if (isset($value['use_function']))  eval('$key2 = ' . $value['use_function'] . "('" . $value['value'] . "');");
      else  $key2= $value['value'];
      $keys .=sprintf( ($use_format !=false && isset($use_format['view_view'])? $use_format['view_view'] : '<span class="view_view">%s</span>' ) , $key2);


      $sortie .=sprintf( ($use_format !=false && isset($use_format['block'])? $use_format['block'] : '<p class="block_input button_nav">%s</p><br />' ) , $keys);
    }

    return $keys;
  }

  /**
    @fn configUtility::CallExecConfigLine($_function, $key, $value)
    @brief call exec function or methode for config current value
    @param $_function string function for exe or method non static ( "cronjob->edit(" for cronjob class and edit method )
    @param $key string current key
    @param $value current value
    @return string for display

    TODO update method for accept call static method and init class by new or getInstance if exits
  */
  public static function CallExecConfigLine($_function, $key, $value){
    if (tep_not_null($_function)) {
      if (preg_match('/->/', $_function)) {
	$class_method = explode('->', $_function);
	if (!is_object(${$class_method[0]})) {
	  ${$class_method[0]} = new $class_method[0]();
	}
	return tep_call_function($class_method[1], $value, ${$class_method[0]});
      } else {
	return tep_call_function($_function, $value);
      }
    }

    return tep_draw_input_field('configuration[' . $key . ']', "configuration$key", $value);
  }
}


?>