<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package oscss-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  22/08/10, 09:26
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class customerUtility
*/
class customerUtility {



  /**
    @author OscssTeam
    @version 1.6
    @note Utilisé par des contrib !!!
  */
  public static function customers_name($customers_id) {
    $customers = tep_db_query("select customers_firstname, customers_lastname from " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$customers_id . "'");
    $customers_values = tep_db_fetch_array($customers);

    return $customers_values['customers_firstname'] . ' ' . $customers_values['customers_lastname'];
  }


  /**
    Get list of address_format_id's
      @package oscss
      @author  OscssTeam
  */
  public static function get_address_formats() {
    $address_format_query = tep_db_query("select address_format_id from " . TABLE_ADDRESS_FORMAT . " order by address_format_id");
    $address_format_array = array();
    while ($address_format_values = tep_db_fetch_array($address_format_query)) {
      $address_format_array[] = array('id' => $address_format_values['address_format_id'],
				      'text' => $address_format_values['address_format_id']);
    }
    return $address_format_array;
  }

  /**
      @package oscss
      @author  OscssTeam
      @note Constructeur l'adrresse (facturation, livrairson)
  */
  public static function address_format($address_format_id, $address, $html, $boln, $eoln) {
    $address_format_query = tep_db_query("select address_format as format from " . TABLE_ADDRESS_FORMAT . " where address_format_id = '" . (int)$address_format_id . "'");
    $address_format = tep_db_fetch_array($address_format_query);

    $company = tep_output_string_protected($address['company']);
    if (isset($address['firstname']) && tep_not_null($address['firstname'])) {
      $firstname = tep_output_string_protected($address['firstname']);
      $lastname = tep_output_string_protected($address['lastname']);
    } elseif (isset($address['name']) && tep_not_null($address['name'])) {
      $firstname = tep_output_string_protected($address['name']);
      $lastname = '';
    } else {
      $firstname = '';
      $lastname = '';
    }
    $street = tep_output_string_protected($address['street_address']);
    $suburb = tep_output_string_protected($address['suburb']);
    $city = tep_output_string_protected($address['city']);
    $state = tep_output_string_protected($address['state']);
    if (isset($address['country_id']) && tep_not_null($address['country_id'])) {
      $country = tep_get_country_name($address['country_id']);

      if (isset($address['zone_id']) && tep_not_null($address['zone_id'])) {
	$state = tep_get_zone_code($address['country_id'], $address['zone_id'], $state);
      }
    } elseif (isset($address['country']) && tep_not_null($address['country'])) {
      $country = tep_output_string_protected($address['country']);
    } else {
      $country = '';
    }
    $postcode = tep_output_string_protected($address['postcode']);
    $zip = $postcode;

    if ($html) {
  // HTML Mode
      $HR = '<hr>';
      $hr = '<hr>';
      if ( ($boln == '') && ($eoln == "\n") ) { // Values not specified, use rational defaults
	$CR = '<br />';
	$cr = '<br />';
	$eoln = $cr;
      } else { // Use values supplied
	$CR = $eoln . $boln;
	$cr = $CR;
      }
    } else {
  // Text Mode
      $CR = $eoln;
      $cr = $CR;
      $HR = '----------------------------------------';
      $hr = '----------------------------------------';
    }

    $statecomma = '';
    $streets = $street;
    if ($suburb != '') $streets = $street . $cr . $suburb;
    if ($country == '') $country = tep_output_string_protected($address['country']);
    if ($state != '') $statecomma = $state . ', ';

    $fmt = $address_format['format'];
    eval("\$address = \"$fmt\";");

    if ( (_cst_bool('ACCOUNT_COMPANY')) && (tep_not_null($company)) ) {
      $address = $company . $cr . $address;
    }

    return $address;
  }


  /**
    @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
    @version 1.2
    @note Fournis un standard d'action pour la colonne client
    @param array $opt
	  origin string :: href de la page appelante
	  format string for printf :: format de sortie
	  action_supp string :: liens complet d'action a ajouter
  */
  public static function DisplayRowAction($customers_id,$opt) {
    $origin=(isset($opt['origin']))? $opt['origin']: '';
    $format=(isset($opt['format']))? $opt['format']: '<span class="fleft">%s</span> <span class="view fils fright row_action">%s</span>';
    $action_supp=(isset($opt['action_supp']))? $opt['action_supp']: '';

    $customers = tep_db_query("select * from " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$customers_id . "'");

    if(!tep_db_num_rows($customers)) return;

    $customers_values = tep_db_fetch_array($customers);

    $nom=$customers_values['customers_firstname'] . ' ' . $customers_values['customers_lastname'];
    $action= '<a href="'.tep_mailto($customers_values['customers_email_address'],$origin).'">'.tep_image(DIR_WS_ICONS.'icon_custom_mail.png',TXT_MINIF_EMAIL).'</a> '
	.'<a href="'.tep_href_link(FILENAME_CUSTOMERS,'cID=' . $customers_id. '&amp;origin='.urlencode($origin) ).'&amp;action=edit">'.tep_image(DIR_WS_ICONS.'icon_custom_edit.png',TXT_MINIF_DETAIL).'</a> '
	.'<a href="'.tep_href_link(FILENAME_STATS,'module=stats_customers').'">'.tep_image(DIR_WS_ICONS.'icon_stats.png',TXT_MINIF_STATS_BUY).'</a> '
	  .$action_supp;
    return sprintf($format,$nom, $action);
  }
}
?>
