<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  01/05/11, 09:17
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class dataTableJsonStatment
  @brief gestion des dataTable via ajax, tri, search
*/

class dataTableJsonStatment {

  /**
    @var string type (products/categories/etc...)
  */
  public static $type;
  /**
    @var string mode (page|content)
  */
  public static $mode;
  /**
    @var array modele tableau des col dispo pour search
  */
  public static $modele;
  /**
    @var array list tableau
  */
  public static $list;
  /**
    @var int page index page num
  */
  public static $page=1;
  /**
    @var int rowbyp filtre nombre lg
  */
  public static $rowbyp;
  /**
    @var string sOrder clause order
  */
  public static $sOrder= '';
  /**
    @var string sWhere clause where supp
  */
  public static $sWhere= '';
  /**
    @var ModTwo new module page
  */
  public static $ModTwo;



  public function __construct(){
    global $language;

    if(!isset($_REQUEST['type'])) return false;

    /// class (module) d'appel
    self::$type= $_REQUEST['type'];
    /// new module ModTwo
    self::$ModTwo = (isset($_REQUEST['ModTwo']))? true : false;

    /// definition for Datable
    self::$mode= (isset($_REQUEST['mod']))? $_REQUEST['mod'] : 'content';
    self::$page=($_REQUEST['iDisplayStart'] / $_REQUEST['iDisplayLength']) +1; /// for sql split, in xml modif for $_REQUEST['iDisplayStart'] / $_REQUEST['iDisplayLength']
    self::$rowbyp=( (isset($_REQUEST['iDisplayLength']) && $_REQUEST['iDisplayLength']>MAX_DISPLAY_ROW_BY_PAGE ) ? $_REQUEST['iDisplayLength'] : MAX_DISPLAY_ROW_BY_PAGE );

    $function='init_mod_'.self::$mode;
    self::$function();

    //! sort col
    if ( isset( $_REQUEST['iSortCol_0'] ) )  {

      foreach(self::$modele as $col=>$v) $mod[]=$col;

      for ( $i=0 ; $i< $_REQUEST['iSortingCols']  ; $i++ ) {
	if(!is_numeric($mod[$_REQUEST['iSortCol_'.$i]]) && (bool)self::$modele[$mod[$_REQUEST['iSortCol_'.$i]]]) self::$sOrder .= $mod[$_REQUEST['iSortCol_'.$i]]." ".tep_db_input($_REQUEST['sSortDir_'.$i] ) .", ";
      }
      self::$sOrder = substr_replace( self::$sOrder, "", -2 );
    }

    //! search mutli one input
    if ( $_REQUEST['sSearch'] != "" ) {
      self::$sWhere.= " AND (";
      foreach(self::$modele as $col=>$v)
	if(!is_numeric($col) && (bool)$v)  self::$sWhere .=" UPPER(".$col.") LIKE '%".strtoupper(tep_db_input( $_REQUEST['sSearch'] ))."%' OR ";

      self::$sWhere = substr(self::$sWhere,0,strlen(self::$sWhere)-3). " ) ";
    }
    //! search mutli, mutli input
    if ( isset( $_REQUEST['sSearch_0'] ) )  {
      $i=0;
      reset(self::$modele);
      foreach(self::$modele as $col=>$v){
	if(tep_not_null($_REQUEST['sSearch_'.$i]))  self::$sWhere .=" AND UPPER(".$col.") LIKE '%".strtoupper(tep_db_input( $_REQUEST['sSearch_'.$i] ))."%'  ";
	$i++;
      }
    }


  }


  /**
    Appel list proprement dite
  */
  public function listItem(){
    global $languages_id,$query_numrows;

    $function='list_mod_'.self::$mode;
    self::$function();

    $sortie=array();
    $sortie['sEcho']=intval($_REQUEST['sEcho']);
    $sortie['iTotalRecords']=count(self::$list);
    $sortie['iTotalDisplayRecords']=$query_numrows;

    foreach(self::$list as $item){
      $res=array();
      foreach($item as $k=>$v)
	$res[]=$v;
      $sortie['aaData'][]=$res;
    }
    echo convert_json($sortie);
    exit;
  }



  /**
    Init class soutient
  */
  private function init_mod_page(){
    $obj=self::$type;
    $oscss=oscss_cstr::getInstance();

    $oscss->pile_file_lang(DIR_WS_LANGUAGES . $oscss->the_var('language') . '/modules/pages/'.self::$type.'.txt');

    if (oscss_cstr::TestFile(DIR_WS_FUNCTIONS . 'lib.'. self::$type.'.php')) require(DIR_WS_FUNCTIONS.'lib.'.self::$type.'.php');
    require(DIR_WS_MODULES.'pages/'.$obj.'.php');

    /// module nextGen ModTwo Froce init conf
    if(self::$ModTwo) call_user_func(array(self::$type, 'GetConf'));

    self::$modele=call_user_func(array($obj, 'tep_get_modele'));


  }

  private function list_mod_page(){
    //! data array list
    self::$list=call_user_func(array(self::$type, 'tep_get_list'),self::$page,self::$rowbyp,self::$sOrder,self::$sWhere);
  }

  /**
    Init libs functions  soutient
  */
  private function init_mod_content(){

    include (DIR_WS_FUNCTIONS.'lib.'.self::$type.'.php');
    @include (DIR_WS_LANGUAGES.$language.'/'.self::$type.'.php');

    /// module nextGen ModTwo Froce init conf
    if(self::$ModTwo) call_user_func(array(self::$type, 'GetConf'));

    //! tableau modele col data
    $funct='tep_get_modele_'.self::$type;
    self::$modele=$funct();

  }

  private function list_mod_content(){
    //! data array list
    $funct='tep_get_list_'.self::$type;
    self::$list=$funct(0,self::$page,self::$rowbyp,self::$sOrder,self::$sWhere);
  }

}

?>