<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  12/12/10, 15:25
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @brief checkup system
*/

class checkupSys{

  private static $check;

  function __construct(){
    $messageStack=messageStack::getInstance();
    $checkup_sys=0;

      $checkup_sys=$this->checkup();

    if(is_array($checkup_sys)) {
      foreach($checkup_sys as $alert)
        $messageStack->add((string)$alert['mess'], $alert['type']) ;
    }

  }


  /**
    Mise en tampon des alerts
  */
  private function add($mess, $type){
    self::$check[]=array('mess'=>$mess, 'type'=>$type);
  }

  /**
    Checkup
  */
  private function checkup(){

  //!check if the 'install' directory exists, and warn of its existence
    if (_cst_bool('WARN_INSTALL_EXISTENCE'))
      if (file_exists(DIR_FS_CATALOG. 'install'))
        $this->add( WARNING_INSTALL_DIRECTORY_EXISTS, 'warning');


  //!check if the configure.php file is writeable
    if (_cst_bool('WARN_CONFIG_WRITEABLE'))
      if ( (file_exists(DIR_FS_CATALOG . 'includes/configure.php')) && (is_writeable(DIR_FS_CATALOG. 'includes/configure.php')) )
        $this->add( WARNING_CONFIG_FILE_WRITEABLE.tep_get_file_permissions(fileperms(DIR_FS_CATALOG. 'includes/configure.php')), 'warning');


  //!check if the session folder is writeable
  if (_cst_bool('WARN_SESSION_DIRECTORY_NOT_WRITEABLE'))
    if (STORE_SESSIONS == '')
      if (!is_dir(tep_session_save_path())) {
        $this->add( WARNING_SESSION_DIRECTORY_NON_EXISTENT, 'warning');
      } elseif (!is_writeable(tep_session_save_path())) {
        $this->add( WARNING_SESSION_DIRECTORY_NOT_WRITEABLE, 'warning');
      }


  //!check session.auto_start is disabled
  if ( (function_exists('ini_get')) && (_cst_bool('WARN_SESSION_AUTO_START')) )
    if (ini_get('session.auto_start') == '1')
      $this->add( WARNING_SESSION_AUTO_START, 'warning');


  if ( (_cst_bool('WARN_DOWNLOAD_DIRECTORY_NOT_READABLE')) && (_cst_bool('DOWNLOAD_ENABLED')) )
    if (!is_dir(DIR_FS_CATALOG.DIR_WS_DOWNLOAD))
      $this->add( WARNING_DOWNLOAD_DIRECTORY_NON_EXISTENT, 'warning');



  /// check if a default currency is set
    if (!defined('DEFAULT_CURRENCY'))
      $this->add(ERROR_NO_DEFAULT_CURRENCY_DEFINED, 'error');

  /// check if a default language is set
    if (!defined('DEFAULT_LANGUAGE'))
      $this->add(ERROR_NO_DEFAULT_LANGUAGE_DEFINED, 'error');

  //!
    if (function_exists('ini_get') && ((bool)ini_get('file_uploads') == false) )
      $this->add(WARNING_FILE_UPLOADS_DISABLED, 'warning');


     return self::$check;
  }

}

?>