<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  24/04/11, 00:05
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class export
*/


Class export {

  /**
    Public type (txt/csv) array
  */
  public $mode;
  /**
    Encodage
  */
  public $encode;

  /**
    Constructeur
  */
  function __construct($page_admin){

    $this->page=$page_admin;

    $this->mode=array(
		  array('id' => '', 'text' => 'Aucun'),
		  array('id' => 'csv', 'text' => 'CSV'),
		  array('id' => 'txt', 'text' => 'TXT')
		);

    $this->encode=array(
		  array('id'=>'utf-8','text'=>'utf-8'),
		  array('id'=>'iso8859-1','text'=>'iso8859-1'),
		  array('id'=>'iso8859-16','text'=>'iso8859-16'),
		);
  }

  /**
    @a $var array
  */
  public function pre_export($var){

    $this->encodage=$var['encodage'];
    $this->mode=$var['mode'];
    $this->page=$var['page_admin'];
    $this->export_type=$var['export_type'];

    $this->define_separator();
  }

  /**
    @a $var array
  */
  public function op_export($var){
    if(!is_array($var)) return null;

    $this->content=$var;

    $this->draw();
  }

  /**
    @brief process export and print
	This method finish by exit
  */
  private function  draw(){
    $data=array();

    $exp= $this->LoadChildsModule($this->export_type);

    /// @remarks if data is empty, return name col in export
    if(!isset($this->content) || empty($this->content) || count($this->content)<=0)
      $this->content = array( $exp->FormatExportCols() );


    /// @remarks format data
    foreach($this->content as $item)
      $data[]=$exp->FormatLigneValue($item);

// print_r($data);
// exit;

    header ("Content-type: application/".$this->mode."; chartset=".$this->encodage);
    header ("Content-Disposition:filename=".$this->export_type."_".$this->page.".".$this->mode);
    header ("Content-type:application/octetstream");

    /// @remarks process format rows in current mode export
    foreach($data as $item)
      echo $this->FormatLigneMode($item);

    exit;
  }


  /**
    @brief return array name colonne, for empty export
  */
  function FormatLigneMode($item){
    switch($this->mode){
      case 'txt':
      case 'csv':
	return implode($this->separator,$item ).$this->separator.$this->ligneseparator;
      break;
    }
  }




  /**
    @brief List des gabarit d'export disponible
	  Load Childs module for test var enable is true
    @param search key
    @return array for use un draw_menu
  */
  public function list_export_template($key=''){
    $file_extension = '.php';
    $directory_array = array();
    if ($dir = dir(DIR_WS_MODULES . 'template_export/')) {
      while ($file = $dir->read()) {
	if (!is_dir(DIR_WS_MODULES . 'template_export/' . $file)) {

	  if ( ((!empty($key) && (bool)strpos($file,$key)>=0) || empty($key) ) && substr($file, strrpos($file, '.')) == $file_extension) {

	  $f_short=substr($file, 0,strrpos($file, '.'));

	    /// @remarks load module export
	    $exp=$this->LoadChildsModule($f_short);

	    /// @remarks check enable
	    if($exp->enable){
	      $directory_array[] = $f_short;
	    }
	  }
	}
      }
      sort($directory_array);
      $dir->close();
    }

    for ($i=0, $n=sizeof($directory_array); $i<$n; $i++) {
      $modules_array[] = array('id' => $directory_array[$i], 'text' => $directory_array[$i] ) ;
    }
    return $modules_array;
  }


  /**
    Traitement des encode
  */
  public function decodage($var){
    if($this->encodage !='utf-8') return utf8_decode($var);
    return $var;
  }

  /**
    @brief define separator fields and line in rows
  */
  private function  define_separator(){
    switch($this->mode){
      case 'csv':
      case 'txt':
      default:
	$this->separator=';';
	$this->ligneseparator="\r\n";
    }
  }


  /**
    @brief Load childs module
    @return object module
  */
  private function LoadChildsModule($name){
    /// @remarks load module export
    include_once(DIR_WS_MODULES . 'template_export/' . $name.'.php' );

    $class_export='Export_'.$name;

    $exp = new $class_export($this->page);

    return $exp;
  }
}
?>