<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  09/11/10, 09:08
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  Example usage:

  $messageStack = new messageStack();
  $messageStack->add('Error: Error 1', 'error');
  $messageStack->add('Error: Error 2', 'warning');
  if ($messageStack->size > 0) echo $messageStack->output();
*/

class messageStack extends tableBlock {
  var $size = 0;

  protected static $_instance;

  protected function __construct() {
    global $messageToStack;

    $this->table_row_parameters = 'class="messageStack"';
    $this->errors = array();

    if (tep_session_is_registered('messageToStack')) {
      for ($i = 0, $n = sizeof($messageToStack); $i < $n; $i++) {
	$this->add($messageToStack[$i]['text'], $messageToStack[$i]['type']);
      }
      tep_session_unregister('messageToStack');
    }
  }

  public static function getInstance(){
      if(self::$_instance == null) self::$_instance = new self();
      return self::$_instance;
  }

  public static function resetInstance(){
      self::$_instance = null;
      return self::getInstance();
  }

  public function add($message, $type = 'error') {
    if ($type == 'error') {
      $this->errors[] = array('class' => 'messageStackError', 'text' =>  $message);
    } elseif ($type == 'warning') {
      $this->errors[] = array('class' => 'messageStackWarning', 'text' => $message);
    } elseif ($type == 'success') {
      $this->errors[] = array('class' => 'messageStackSuccess', 'text' =>  $message);
    } else {
      $this->errors[] = array('class' => 'messageStackError', 'text' => $message);
    }

    $this->size++;
  }

  public function add_session($message, $type = 'error') {
    global $messageToStack;

    if (!tep_session_is_registered('messageToStack')) {
      tep_session_register('messageToStack');
      $messageToStack = array();
    }

    $messageToStack[] = array('text' => $message, 'type' => $type);
  }

  public function reset() {
    $this->errors = array();
    $this->size = 0;
  }

  /**
    Compteur d'erreur
  */
  public function count_errors(){
    $i=0;
    foreach($this->errors as $item)
      if($item['class']=='messageStackError') $i++;
    return $i;
  }

  /**
  Alias
  */
  public function get_errors(){
    return $this->output();
  }

  public function output() {
    $this->table_data_parameters = 'class="messageBox"';
    return $this->tableBlock($this->errors);
  }
}
?>