<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package oscss-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  22/08/10, 09:26
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class qtproUtility
*/
class qtproUtility {

    //This is the most detailed doctor function for examining a product.
    //When is a product not healthy? Answer: there are three types of errors. The first is called "intruder" error. This is when there exist an attribute in the products_stock_attributes string which is not stocktracked. The Second type of error called "lack" error. This is when an attribute is missing in products_stock_attributes; that is: when the product has an attribute with tracked stock and that attribute is not in the products_stock_attributes. The third type of error is when the current summary stock for a product isn't the summary stock we get if we calculate it.
  static public function doctor_investigate_product($products_id){
    $facts_array = array();
    $facts_array['id'] = $products_id;
    $facts_array['any_problems'] = false;
    $facts_array['has_tracked_options'] = false;

    $facts_array['summary_and_calc_stock_match'] = true; //If summary_stock and calc_stock is the same value; this = true; else this = false
    $facts_array['summary_stock'] = 0; //The current summary stock for this product in the database.
    $facts_array['calc_stock'] = 0; //The summary stock calculated by looking at the options products_stock.

    $facts_array['stock_entries_healthy'] = true; //If any row is sick; this = true; else this = false;
    $facts_array['stock_entries_count'] = 0; //The number of rows this product had in the options products_stock database table.
    $facts_array['sick_stock_entries_count'] = 0;//The number of sick rows this product had in the options products_stock database table.
    $facts_array['lacks_id_array'] = array(); //An array with all the id:s of the options that were lacked anywhere in the options products_stock table.
    $facts_array['intruders_id_array'] = array(); //An array with all the id:s of the options that were intruding anywhere in the options products_stock table.

      $facts_array['has_tracked_options'] = qtproUtility::product_has_tracked_options($products_id);
      $facts_array['summary_stock'] = qtproUtility::get_products_summary_stock($products_id);

      //Calculate the summary stock by looking att the stock for the different options
      if($facts_array['has_tracked_options']){
	$products_stock_quantity_query = tep_db_query("SELECT products_stock_quantity FROM " . TABLE_PRODUCTS_STOCK . " WHERE products_id = '" . $products_id . "'");

	while($row = tep_db_fetch_array($products_stock_quantity_query))
	  //If they are negative they are oversold and this do not affect what we have on stock.
	  if($row['products_stock_quantity'] > 0) $facts_array['calc_stock']+= $row['products_stock_quantity'];

      }else{
	//Set the calc_stock to the summary stock
	$facts_array['calc_stock'] = $facts_array['summary_stock'];
      }

      //Decide summary_and_calc_stock_match
      if($facts_array['summary_stock'] == $facts_array['calc_stock']) $facts_array['summary_and_calc_stock_match'] = true;
      else $facts_array['summary_and_calc_stock_match'] = false;


      //Get all products_stock entries for the product. ---------------------------------------
      $attributes_stock_query = tep_db_query("SELECT products_stock_attributes FROM " . TABLE_PRODUCTS_STOCK . " WHERE products_id = '" . $products_id . "'");

      $facts_array['stock_entries_count'] = tep_db_num_rows($attributes_stock_query);

      if ($facts_array['stock_entries_count'] == 0){
	$facts_array['sick_stock_entries_count'] = 0;
	$facts_array['stock_entries_healthy'] = true;
      }else{
	//Get the id for all options this product has and put them in the array: $products_options_array  ---------------------------------------
	$products_options_query = tep_db_query("SELECT DISTINCT options_id FROM " . TABLE_PRODUCTS_ATTRIBUTES . " WHERE products_id = '" . $products_id . "'");
	$products_options_array = array();
	while ($products_option_id = tep_db_fetch_array($products_options_query))  $products_options_array[] =$products_option_id['options_id'];

	//Get the id for all attributes which are tracked and put them in the array: $tracked_options_array  ---------------------------------------
	$tracked_options_query = tep_db_query("SELECT DISTINCT products_options_id FROM " . TABLE_PRODUCTS_OPTIONS . " WHERE products_options_track_stock = 1");
	$tracked_options_array = array();
	while ($tracked_option_id = tep_db_fetch_array($tracked_options_query))  $tracked_options_array[] =$tracked_option_id['products_options_id'];

	//Ok so now we can check if the option_id 8 is tracked by running: in_array(8, $tracked_options_array) =)


	//Check every products_stock_attributes for errors
	while ($products_stock_attributes = tep_db_fetch_array($attributes_stock_query)) {
	  $this_row_is_sick = false;
	  $string_options_array = qtpro_products_attributes_string2options_array($products_stock_attributes['products_stock_attributes']);

	  //Now check for "intruder" errors (check for attributes which are there but should not as they are not stocktracked)
	  foreach($string_options_array as $option)
		  if(!in_array($option, $tracked_options_array)){
		    $this_row_is_sick = false;
		    $facts_array['sick_stock_entries_count']++;
		    $facts_array['stock_entries_healthy'] = false;
		    $facts_array['intruders_id_array'][] = $option;
		  }


	  //Now check for "lack" errors (check for attributes should be there, because they are stocktracked, but for some reason are not)
	  foreach($products_options_array as $product_option)
	    if(in_array($product_option, $tracked_options_array) && !in_array($product_option, $string_options_array)){
	      $this_row_is_sick = false;

	      $facts_array['stock_entries_healthy'] = false;
	      $facts_array['lacks_id_array'][] = $product_option;
	    }


	  if($this_row_is_sick){
	    $facts_array['sick_stock_entries_count']++;
	  }

	}
      }

    //Set the overwiev variables:
    if(!$facts_array['summary_and_calc_stock_match'] or !$facts_array['stock_entries_healthy']) $facts_array['any_problems'] = true;

    return $facts_array;
  }



  static public function product_has_tracked_options($products_id){
    //Get the id for all options this product has and put them in the array: $products_options_array  ---------------------------------------
    $products_options_query = tep_db_query("SELECT DISTINCT options_id FROM " . TABLE_PRODUCTS_ATTRIBUTES . " WHERE products_id = '" . $products_id . "'");
    $products_options_array = array();
    while ($products_option_id = tep_db_fetch_array($products_options_query))  $products_options_array[] =$products_option_id['options_id'];


    //Get the id for all attributes which are tracked and put them in the array: $tracked_options_array  ---------------------------------------
    $tracked_options_query = tep_db_query("SELECT DISTINCT products_options_id FROM " . TABLE_PRODUCTS_OPTIONS . " WHERE products_options_track_stock = 1");
    $tracked_options_array = array();
    while ($tracked_option_id = tep_db_fetch_array($tracked_options_query))  $tracked_options_array[] =$tracked_option_id['products_options_id'];

    //Ok so now we can check if the option_id 8 is tracked by running: in_array(8, $tracked_options_array) =)

    //Do the test:
    foreach($products_options_array as $products_option)
      if(in_array($products_option, $tracked_options_array))return true;


    return false;
  }

  static public function get_products_summary_stock($products_id){
    $products_summary_stock_query = tep_db_query("SELECT products_quantity FROM " . TABLE_PRODUCTS . " WHERE products_id = '" . $products_id . "'");
    $product_facts = tep_db_fetch_array($products_summary_stock_query);
    return $product_facts['products_quantity'];
  }


  //This function will delete all option stock entries from the product.
  static public function doctor_amputate_all_from_product($products_id){
    tep_db_query("DELETE FROM " . TABLE_PRODUCTS_STOCK . " WHERE products_id =". $products_id);
  }


  /*
  This function will take a string looking like "1-2,3-4,5-6" and return an array looking like:
  Array
  (
      [0] => 1
      [2] => 3
      [3] => 5
  )
  */
  static public function products_attributes_string2options_array($products_attributes_string){
    $ret_array = array();

    $optionchoise_array =explode(',', $products_attributes_string);// values in $option_choise_array looks like: '1-2'
    //Now put them into $ret_array in a correct way:
    foreach($optionchoise_array as $optionchoise){
	    $splitted_array = explode('-', $optionchoise);
	    $ret_array[] = $splitted_array[0];;
    }

    return $ret_array;
  }

  //This function will update the summary_stock for a product
  static public  function update_summary_stock($products_id){
    tep_db_query("UPDATE " . TABLE_PRODUCTS . " SET products_quantity = " . self::calculate_summary_stock($products_id) . " WHERE products_id = '" . $products_id . "'");
  }

  //This function will calculate and return the summary_stock for a product. If it is a product without tracked attributes the summary_stock will be returned anyway.
  //NOTE!!!: This function will include all entries. Even damaged ones...
  public static function calculate_summary_stock($products_id){
    $summary_stock_to_return = 0;
    if(self::product_has_tracked_options($products_id)){
      //Calculate the summary stock by looking att the stock for the different options
      //Get all products_stock entries for the product. ---------------------------------------
      $products_stock_quantity_query = tep_db_query("SELECT products_stock_quantity FROM " . TABLE_PRODUCTS_STOCK . " WHERE products_id = '" . $products_id . "'");
      while($row = tep_db_fetch_array($products_stock_quantity_query)){
	if($row['products_stock_quantity'] > 0){ //If they are negative they are oversold and this do not affect what we have on stock.
	  $summary_stock_to_return+= $row['products_stock_quantity'];
	}
      }

    }else{
      //Just return he current summary stock
      $summary_stock_to_return = qtproUtility::get_products_summary_stock($products_id);
    }
    return $summary_stock_to_return;
  }
}
?>