<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  10/06/10, 09:08
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/
class splitPageResults {
  function splitPageResults(&$current_page_number, $max_rows_per_page, &$sql_query, &$query_num_rows) {

    $DB=Database::getInstance();

    if (empty($current_page_number)) $current_page_number = 1;

    $pos_to = strlen($sql_query);
    $pos_from = stripos($sql_query, ' from', 0);

    $pos_group_by = stripos($sql_query, ' group by', $pos_from);
    if (($pos_group_by < $pos_to) && ($pos_group_by != false)) $pos_to = $pos_group_by;

    $pos_having = stripos($sql_query, ' having', $pos_from);
    if (($pos_having < $pos_to) && ($pos_having != false)) $pos_to = $pos_having;

    $pos_order_by = stripos($sql_query, ' order by', $pos_from);
    if (($pos_order_by < $pos_to) && ($pos_order_by != false)) $pos_to = $pos_order_by;

    if (!is_numeric($query_num_rows)) {
      $reviews_count_query = $DB->query($sql="select distinct count(*) as total " . substr($sql_query, $pos_from, ($pos_to - $pos_from)));
      if($reviews_count_query ==false) return false;
      $reviews_count = $reviews_count_query->fetchAssoc();
      $query_num_rows = $reviews_count['total'];
    }
    $num_pages = ceil($query_num_rows / $max_rows_per_page);
    if ($current_page_number > $num_pages && $num_pages > 0 ) {
      $current_page_number = $num_pages;
    }
    $offset = ($max_rows_per_page * ($current_page_number - 1));
    $sql_query .= " limit " . max($offset, 0) . ", " . $max_rows_per_page;
  }

  function display_links($query_numrows, $max_rows_per_page, $max_page_links, $current_page_number, $parameters = '', $page_name = 'page') {
    $PHP_SELF = preg_replace("/[?].*/i",'',$_SERVER['REQUEST_URI']);

    if ( tep_not_null($parameters) && (substr($parameters, -5) != '&amp;') ) $parameters .= '&amp;';

  // calculate number of pages needing links
    $num_pages = ceil($query_numrows / $max_rows_per_page);

    $pages_array = array();
    for ($i=1; $i<=$num_pages; $i++) {
      $pages_array[] = array('id' => $i, 'text' => $i);
    }

    if ($num_pages > 1) {
      $display_links = tep_draw_form('page_form', basename($PHP_SELF), '', 'get').'<p>';

      if ($current_page_number > 1) {
        $display_links .= '<a href="' . tep_href_link(basename($PHP_SELF), $parameters . $page_name . '=' . ($current_page_number - 1), 'NONSSL') . '" class="splitPageLink">' . PREVNEXT_BUTTON_PREV . '</a> ';
      } else {
        $display_links .= PREVNEXT_BUTTON_PREV . ' ';
      }

      $display_links .= sprintf(TEXT_RESULT_PAGE, tep_draw_pull_down_menu($page_name, $pages_array, $current_page_number, 'onchange="this.form.submit();"'), $num_pages);

      if (($current_page_number < $num_pages) && ($num_pages != 1)) {
        $display_links .= ' <a href="' . tep_href_link(basename($PHP_SELF), $parameters . $page_name . '=' . ($current_page_number + 1), 'NONSSL') . '" class="splitPageLink">' . PREVNEXT_BUTTON_NEXT . '</a>';
      } else {
        $display_links .= '&nbsp;&nbsp;' . PREVNEXT_BUTTON_NEXT;
      }

      if ($parameters != '') {
        if (substr($parameters, -5) == '&amp;') $parameters = substr($parameters, 0, -5);
        $pairs = explode('&amp;', $parameters);
        while (list(, $pair) = each($pairs)) {
                      list($key,$value) = explode('=', $pair);
          $display_links .= tep_draw_hidden_field(rawurldecode($key), '', rawurldecode($value));
        }
      }

      if (SID) $display_links .= tep_draw_hidden_field(tep_session_name(), '', tep_session_id());

      $display_links .= '</p></form>';
    } else {
      $display_links = sprintf(TEXT_RESULT_PAGE, $num_pages, $num_pages);
    }

    return $display_links;
  }

  function display_count($query_numrows, $max_rows_per_page, $current_page_number, $text_output) {
    $to_num = ($max_rows_per_page * $current_page_number);
    if ($to_num > $query_numrows) $to_num = $query_numrows;
    $from_num = ($max_rows_per_page * ($current_page_number - 1));
    if ($to_num == 0) {
      $from_num = 0;
    } else {
      $from_num++;
    }

    return sprintf($text_output, $from_num, $to_num, $query_numrows);
  }
}
?>