<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  10/06/10, 09:08
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
          ayatus - oscim - oscssTeam
  @encode UTF-8

  Constructeur de Contenu, qui ce charge de la mise en forme html.


  NOTE:
  Le tableau des separator doit necessairement être dans la key 0;


  Tableau d'une entrée
//   Array
// (
//     [0] => Array
//         (
//             [separator] => Array
//                 (
//                     [0] => tbody
//                     [1] => tr
//                     [2] => td
//                 )
//
//             [class] => view parent dataTableRow
//         )
//
//     [1] => Array
//         (
//             [text] => ....
//         )
// )
*/


class tableBlock {
    var $table_row_parameters ;
    var $table_data_parameters ;

    /**
      Defini les non de balise html par hieracrhie, master =0
      private
    */
    var $i_separator ;

    var $tableBox_string;

    /**
    public
    pile d'element pris en charge dans le draw
    */
    var $pile;


//     function __construct(){
//       $this->draw_separator();
//     }


    /**
      @param
        @p array $contents
      (options)
        @p array... (mutlitple)
    */
    public function tableBlock($contents='') {
      $tableBox_string ='';
      if(!isset($this->i_separator) || !is_array($this->i_separator)) $this->draw_separator();
      return $this->draw($contents);
    }

    /**
      @param
        @p array $contents
      (options)
        @p array... (mutlitple)
    */
    public function force_separator($options) {
      if(isset($options['separator']) && is_array($options['separator'])){
        $this->draw_separator();
        for($i=0,$max=count($options['separator']);$i<$max; $i++){
          $this->i_separator[$i]=$options['separator'][$i];
        }
      }
    }


  /**
      Classic
  */
  public function draw($contents) {
    $this->tableBox_string = '';
    $form_set = false;
    if (isset($contents['form'])) {
      $this->tableBox_string .= $contents['form'] . "\n";
      $form_set = true;
      array_shift($contents);
    }

    $this->st_cpt=0;
    $this->st_cpt_0=0;
    $this->_draw_recu($contents, false);

    if ($form_set == true) $this->tableBox_string .= '</form>' . "\n";

    return $this->tableBox_string;
  }

  /**
    Traitement des block de maniere recursive
  */
  function _draw_recu($block,$indent=false){
    $parent=false;$mode=false;$block_balise=false;
    $this->tableBox_s ='';
    $array_sep=$this->i_separator;

    if (is_array($block)) {
      $this->st_cpt++;
      for ($i=0, $n=sizeof($block); $i<$n; $i++) {
         $ss_blk=$block[$i];
        //! array separator
         if (isset($ss_blk['separator'] )) {
          $array_sep=$ss_blk['separator'];
          $mode=true;
         }
         //! array separator
         if (isset($ss_blk['block'] ) && $ss_blk['block'] =='separator') $block_balise=true;
         //! recusivite
         if (isset($ss_blk) && ( !isset($ss_blk['text']) && !isset($ss_blk['form']) && !isset($ss_blk['separator']) ) && is_array($ss_blk) ) $this->_draw_recu($ss_blk,true);
         //! traitement ligne
         elseif (isset($ss_blk['text']) && tep_not_null($ss_blk['text'])) {
            $this->tableBox_s .= '<'.$this->separator($this->st_cpt,$array_sep).''.$this->param_in_line(2,$ss_blk) .'>'. "\n";

            if (isset($ss_blk['form']) && tep_not_null($ss_blk['form']))
              $this->tableBox_s .= (string)$ss_blk['form'];

            $this->tableBox_s .= (string)$ss_blk['text'];

            if (isset($ss_blk['form']) && tep_not_null($ss_blk['form']))
               $this->tableBox_s .= '</form>'. "\n";

            $this->tableBox_s .= '</'.$this->separator($this->st_cpt,$array_sep).'>' . "\n";
          }
       }
   //! Parent
        $cpt_p=($this->st_cpt_0>0)? 1 : 0;
        $this->force_separator($this->i_separator);

        if($block_balise) $this->tableBox_string .= $this->tableBox_s ;
        elseif($this->separator($cpt_p,$array_sep) !=false && $indent) {
          $parent=true;
          $this->tableBox_string .= '  <'.$this->separator($cpt_p,$array_sep).''. $this->param_in_line(0,$block[0]) .'>'."\n" .  $this->tableBox_s . '  </'.$this->separator($cpt_p,$array_sep).'>' . "\n";
        }
        elseif(!$mode){ /// Classic
          $cpt_p=0;
          if( $this->separator($cpt_p,$array_sep) !=false && tep_not_null($this->tableBox_s ) ){
            $this->tableBox_string .= '  <'.$this->separator($cpt_p,$array_sep).' '. $this->table_row_parameters .'>'."\n" .  $this->tableBox_s . '  </'.$this->separator($cpt_p,$array_sep).'>' . "\n";
          }
        }
    }
  }


  /**
    passage de param ds la balise html
  @param
    @p int (0) master
    @p array tableau des params
  */
  private function param_in_line($type,$tabl){
    $s='';
    if (isset($tabl['class']) && tep_not_null($tabl['class'])) $s .= ' class="' . $tabl['class'] . '"';
    if (isset($tabl['params']) && tep_not_null(isset($tabl['params']))) $s .= ' ' . $tabl['params'];
    elseif ((int)$type == 0 && tep_not_null($this->table_row_parameters))  $s .= ' ' . $this->table_row_parameters;
    elseif ((int)$type != 0 && tep_not_null($this->table_data_parameters))  $s .= ' ' . $this->table_data_parameters;
    return $s;
  }

  /**
    Ce charge appliqué le nom de la bailse html en fonction du niveau hierachique
    @param
      defaut
        0 >> ul
        1 >> li

  */
  private function draw_separator(){
    $this->i_separator=array(
        0 => 'ul',
        1 => 'li',
        2 => 'li',
        );
  }


  /**
    determine le nom de la balise html a appliqué
    @param
      @p int qui detremine la key du i_separator
      @p array tableau de separator, si fournis, utilisé , sinon utilise i_separator
    @return string balise html
  */
  private function separator($key,$tabl=''){
    if(!is_array($tabl)){
      if(!isset($this->i_separator[$key]) && isset($this->i_separator[(count($this->i_separator)-1)]) && tep_not_null($this->i_separator[(count($this->i_separator)-1)]) ) return $this->i_separator[(count($this->i_separator)-1)];
      elseif(isset($this->i_separator[$key]) && tep_not_null($this->i_separator[$key])) return $this->i_separator[$key];
      else return false;
    }else {
      if(!isset($tabl[$key]) && isset( $tabl[(count($tabl)-1)]) && tep_not_null($tabl[(count($tabl)-1)]) ) return $tabl[(count($tabl)-1)];
      elseif(isset($tabl[$key]) && tep_not_null($tabl[$key]) )return $tabl[$key];
      else return false;
    }
  }


  /**
    Ajout item dans une colonne donnée
  */
  public function add_pile($col,$array){
    $this->pile[$col][]=$array;
  }

  /**
    Retour de la pile sous forme de tableau
  */
  public function _call_pile(){
    $s= $this->pile;
    $this->reset_pile();
    return $s;
  }

  /**
    Reinit de la pile
  */
  private function reset_pile(){
    $this->pile=array();
    $this->tableBox_string='';
    $this->tableBox_s = '';
    $this->st_cpt=0;
  }
}
?>