<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  21/03/11, 14:22
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class  tracked_stock
*/


class tracked_stock{

  function tracked_stock(){

    $this->configuration();
  }

  function configuration(){
    $this->config['STOCK_CHECK']=_cst_bool('STOCK_CHECK'); //! verife niveau stock avant commande
    $this->config['STOCK_LIMITED']=_cst_bool('STOCK_LIMITED'); //! decompte lors des commandes
    $this->config['STOCK_ALLOW_CHECKOUT']=_cst_bool('STOCK_ALLOW_CHECKOUT'); //! autorise achat host stock
    //! @a int niveau alerte resassort
      $this->config['STOCK_REORDER_LEVEL']=STOCK_REORDER_LEVEL;
  }


  /**
    Construit requte pour les alerte de stock
  */
  function db_low_stock(){
    global $languages_id;

     $products_query_raw = "select p.products_id, pd.products_name, p.products_model, p.products_quantity as stock, s.products_stock_quantity as option_stock, s.products_stock_attributes, p.products_price, l.name from  " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_LANGUAGES . " l, " . TABLE_PRODUCTS . " p LEFT JOIN  " . TABLE_PRODUCTS_STOCK . " s on p.products_id = s.products_id
        WHERE
          p.products_id = pd.products_id   and l.languages_id = pd.language_id
          and pd.language_id = '" . (int)$languages_id . "' AND pd.products_name <>''
          and(  p.products_quantity <= '".$this->config['STOCK_REORDER_LEVEL']."' OR   s.products_stock_quantity <= '".$this->config['STOCK_REORDER_LEVEL']."' )
          order by ".((isset($_GET['sort_by'])) ? $_GET['sort_by'] : ' p.products_quantity, s.products_stock_quantity ASC');

    $products_query = tep_db_query($products_query_raw);
    if(tep_db_num_rows($products_query)==0)  return false;
    $liste=array();
    while ($products = tep_db_fetch_array($products_query)) {
      if(!empty($products['option_stock']) ){
        $att=array();
        $attribut=explode(",",$products['products_stock_attributes']);
        foreach($attribut as $attribute) {
          $attr=explode("-",$attribute);
          $att[]=tep_values_name($attr[1]);
//           $products['products_price']+=$attributes_price[$attr[0]][$attr[1]];
        }
        $products['option']=$att;
      }

      $liste[]=$products;
    }

    return $liste;
  }


  /**
    Retour nom et id uniquement pour les option avec option tracked
    Interroge avec base produitc_id ou base option id
    @param
      @a int pId product_id
      @a int option_id l'id de l'option
  */
  function db_option_tracked_stock($pID='', $option_id=false){
    global $languages_id;
    $list=array();
    if($option_id==false) {
      $products_options_name_query = "SELECT distinct popt.products_options_id, popt.products_options_name
                                                  FROM " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_ATTRIBUTES . " patrib
                                                  WHERE patrib.products_id='" . (int)$pID . "'
                                                  AND patrib.options_id = popt.products_options_id
                                                  AND popt.products_options_track_stock = '1'
                                                  AND popt.language_id = '" . (int)$languages_id . "'
                                                  ORDER BY popt.products_options_id";
      $products_query = tep_db_query($products_options_name_query);
      while ($products = tep_db_fetch_array($products_query)) {
        $list[]=$products;
      }
    } else {
      $products_options_name_query = "SELECT popt.products_options_id, popt.products_options_name
                                                  FROM " . TABLE_PRODUCTS_OPTIONS . " popt
                                                  WHERE popt.products_options_id='" . (int)$option_id . "'
                                                  AND popt.products_options_track_stock = '1'
                                                  AND popt.language_id = '" . (int)$languages_id . "'
                                                  ORDER BY popt.products_options_id";
      $products_query = tep_db_query($products_options_name_query);
      $list[]=tep_db_fetch_array($products_query);
    }
    return $list;
  }

  /**
    Retour des valeur des attribute
    @param
      @a int pId product_id
  */
  function db_attribute_value($pID=''){
    $list=array();
    $products_attributes_query = "SELECT pa.options_id, pa.options_values_id, pa.options_values_price, pa.price_prefix
                                                    FROM " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                                                    WHERE pa.products_id = '" . (int)$pID . "'";
    $products_query = tep_db_query($products_attributes_query);
    while ($products = tep_db_fetch_array($products_query)) {
      $list[]=$products;
    }
    return $list;
  }
}



?>