<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package oscss-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  18/12/10, 09:26
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class worldUtility
*/
class worldUtility {


  /**
    @package oscss
    @author  OscssTeam
    @note Function to retrieve the state/province code (as in FL for Florida etc)
    @param string country:  country code
    @param int zone : state/province zone_id
    @param string def_state: default string if zone==0
    @return  state_prov_code   state/province code
  */
  public static function get_zone_code($country, $zone, $def_state) {

    $state_prov_query = tep_db_query("select zone_code from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' and zone_id = '" . (int)$zone . "'");

    if (!tep_db_num_rows($state_prov_query)) {
      $state_prov_code = $def_state;
    }
    else {
      $state_prov_values = tep_db_fetch_array($state_prov_query);
      $state_prov_code = $state_prov_values['zone_code'];
    }

    return $state_prov_code;
  }


  /**
    Returns an array with countries
    @package oscss
    @author  OscssTeam
    @table  countries
    @param string $default
    @param array $exclude liste exclusion
  */
  public static function get_countries($default = '', $exclude=array()) {
    $countries_array = array();
    if ($default) {
      $countries_array[] = array('id' => '', 'text' => $default);
    }
    $countries_query = tep_db_query("select countries_id, countries_name from " . TABLE_COUNTRIES . " order by countries_name");
    while ($countries = tep_db_fetch_array($countries_query)) {
      if(!in_array($countries['countries_id'],$exclude)) $countries_array[] = array('id' => $countries['countries_id'], 'text' => $countries['countries_name']);
    }

    return $countries_array;
  }


  /**
    return an array with country zones
      @package oscss
      @author  OscssTeam
  */
  public static function get_country_zones($country_id) {
    $zones_array = array();
    $zones_query = tep_db_query("select zone_id, zone_name from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country_id . "' order by zone_name");
    while ($zones = tep_db_fetch_array($zones_query)) {
      $zones_array[] = array('id' => $zones['zone_id'],
			      'text' => $zones['zone_name']);
    }

    return $zones_array;
  }



  /**
    appel des Zone
    @package oscss
    @author oscim - OscssTeam
    @param int $zone_class_id l'id selectionné
    @param string $key la clef du nom de input
    @param string $type  (Vat:/Shp:)
  */
  public static function cfg_pull_down_zone_classes($zone_class_id, $key = '', $type='1') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $zone_class_array = array(array('id' => '0', 'text' => TEXT_NONE));
    $zone_class_query = tep_db_query("select geo_zone_id, geo_zone_name from " . TABLE_GEO_ZONES . " WHERE geo_zone_type ='".$type."' order by geo_zone_name");
    while ($zone_class = tep_db_fetch_array($zone_class_query)) {
      $zone_class_array[] = array('id' => $zone_class['geo_zone_id'],'text' => $zone_class['geo_zone_name']);
    }
    return tep_draw_pull_down_menu($name, $zone_class_array, $zone_class_id);
  }

  /**
    @package oscss
    @author  OscssTeam
  */
  public static function get_country_name($country_id) {
    $country_query = tep_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$country_id . "'");
    if (!tep_db_num_rows($country_query))  return $country_id;
    else {
	$country = tep_db_fetch_array($country_query);
	return $country['countries_name'];
    }
  }

  /**
    @fn geo_zones_pull_down($parameters, $selected = '',$fisc=1)
    @param $parameters html for input select  string
    @param $selected string/int
    @param $fisc int(taxe = 1/shipping = 2/etc)
  */
  public static function geo_zones_pull_down($parameters, $selected = '',$fisc=1) {
    $wh= " WHERE  geo_zone_type ='".$fisc."' ";
    $select_string = '<select ' . $parameters . '>';
    $zones_query = tep_db_query($sql="select geo_zone_id, geo_zone_name from " . TABLE_GEO_ZONES . " ".$wh." order by geo_zone_name");
    while ($zones = tep_db_fetch_array($zones_query)) {
      $select_string .= '<option value="' . $zones['geo_zone_id'] . '"';
      if ($selected == $zones['geo_zone_id']) $select_string .= ' selected="selected"';
      $select_string .= '>' . $zones['geo_zone_name'] . '</option>';
    }
    $select_string .= '</select>';

    return $select_string;
  }

  /**
    @package oscss
    @author oscim - OscssTeam
  */
  public static function get_zone_class_title($zone_class_id) {
    if ($zone_class_id == '0')return TEXT_NONE;
    else {
      $classes_query = tep_db_query("select geo_zone_name from " . TABLE_GEO_ZONES . " where geo_zone_id = '" . (int)$zone_class_id . "'");
      if (!tep_db_num_rows($classes_query)) {
	return $zone_class_id;
      } else {
	$classes = tep_db_fetch_array($classes_query);
	return $classes['geo_zone_name'];
      }
    }
  }

  /** Alias */
  public static function get_geo_zone_name($geo_zone_id) { return self::get_zone_class_title($geo_zone_id); }
}
?>
