<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  28/12/10, 09:58
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

  /**
   * \brief as active / inactive cache and error return
   * @var boolean default:false
   */
  define('OSCSS_DEBUG', true);
  /**
   * \brief as active view query in error requet sql
   * @var boolean default:false
   */
  define('OSCSS_SHOW_QUERIES', true);
  /**
   * \brief as active / incative garbage collector error
   * @var boolean default:true
   */
  define('OSCSS_GARBAGE_ERROR', true);

// Define the webserver and path parameters
// * DIR_FS_* = Filesystem directories (local/physical)
// * DIR_WS_* = Webserver directories (virtual/URL)
  define('HTTP_SERVER', 'http://myurl'); // eg, http://localhost - should not be empty for productive servers
  define('HTTP_CATALOG_SERVER', 'http://myurl');
  define('HTTPS_CATALOG_SERVER', '');
  define('ENABLE_SSL', false);
  define('ENABLE_SSL_CATALOG', 'false'); // secure webserver for catalog module
  define('DIR_FS_DOCUMENT_ROOT', 'xxx/'); // where the pages are located on the server
  define('DIR_WS_ADMIN', '/xxx/admin/'); // absolute path required
  define('DIR_FS_ADMIN', '/xxx/admin/'); // absolute pate required
  define('DIR_WS_CATALOG', '/xxx/'); // absolute path required
  define('DIR_FS_CATALOG', '/xxx/'); // absolute path required
  define('DIR_CLASSES', 'classes/');
  define('DIR_FUNCTIONS', 'functions/');
  define('DIR_FONTS', 'fonts/');
  define('DIR_WS_IMAGES', 'images/');
  define('DIR_WS_ICONS', DIR_WS_IMAGES . 'icons/');
  define('DIR_WS_CATALOG_IMAGES', DIR_WS_CATALOG . 'images/');
  define('DIR_WS_INCLUDES', 'includes/');
  define('DIR_WS_BOXES', DIR_WS_INCLUDES . 'boxes/');
  define('DIR_WS_DOWNLOAD', DIR_WS_INCLUDES . 'download/');
  define('DIR_WS_FUNCTIONS', DIR_WS_INCLUDES . DIR_FUNCTIONS);
  define('DIR_WS_CLASSES', DIR_WS_INCLUDES . DIR_CLASSES);
  define('DIR_WS_MODULES', DIR_WS_INCLUDES . 'modules/');
  define('DIR_WS_LIB', DIR_WS_INCLUDES . 'lib/');
  define('DIR_WS_PLUGINS', DIR_WS_INCLUDES . 'plugins/');
  define('DIR_WS_FONTS', DIR_WS_INCLUDES . DIR_FONTS);
  define('DIR_WS_JS', DIR_WS_INCLUDES . 'javascript/');
  define('DIR_WS_WIDGET', DIR_WS_INCLUDES . 'widget/');
  define('DIR_WS_LANGUAGES', DIR_WS_INCLUDES . 'languages/');
  define('DIR_WS_CATALOG_LANGUAGES', DIR_WS_CATALOG . 'includes/languages/');
  define('DIR_FS_CATALOG_LANGUAGES', DIR_FS_CATALOG . 'includes/languages/');
  define('DIR_FS_CATALOG_IMAGES', DIR_FS_CATALOG . 'images/');
  define('DIR_FS_CATALOG_MODULES', DIR_FS_CATALOG . 'includes/modules/');
  define('DIR_FS_BACKUP', DIR_FS_ADMIN . 'backups/');
  define('DIR_FS_WORK', '/xxx/oscss_data/');
  define('DIR_FS_SESSIONS', DIR_FS_ADMIN . 'sessions/');

// Template System files
  define('DIR_FS_TEMPLATES', DIR_FS_CATALOG . 'templates/');
  define('DIR_WS_TEMPLATES', DIR_WS_CATALOG . 'templates/');
  define('DIR_WS_CATALOG_DOWNLOAD', DIR_WS_CATALOG . 'download/');

// Common
  define('DIR_WS_COMMON', 'common/');
  define('DIR_WS_COMMON_FUNCTIONS', DIR_WS_COMMON . DIR_FUNCTIONS);
  define('DIR_WS_COMMON_FONTS', DIR_WS_COMMON . DIR_FONTS);
  define('DIR_WS_COMMON_CLASSES', DIR_WS_COMMON . DIR_CLASSES);
  define('DIR_WS_COMMON_IMAGES', DIR_WS_TEMPLATES . 'layout/');

// define our database connection
  define('DB_CONNECTOR', 'mysql');
  define('DB_PORT', '3306');
  define('DB_CHARSET', 'utf8');
  define('DB_SERVER', 'localhost'); // eg, localhost - should not be empty for productive servers
  define('DB_SERVER_USERNAME', 'xxxxxxxx');
  define('DB_SERVER_PASSWORD', 'xxxxxxxx');
  define('DB_DATABASE', 'xxxxxxxx');
  define('DB_TABLE_PREFIX', 'osc_');
  define('USE_PCONNECT', 'false'); // use persisstent connections?
  define('STORE_SESSIONS', 'mysql'); // leave empty '' for default handler or set to 'mysql'
  
  
  
  /**
   * @brief method login active, separate by ;. the method is call in sort 
   * @example $conf['login']='oscss;openid';
   * @var $conf['login'] string 
   */
  $conf['login']='oscss;';
?>