<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  25/04/11, 10:34
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/



/**
  @class drivers_PHPlot
  @brief class support phplot lib graphs
*/
class drivers_PHPlot
  Implements DriversGraphs{

  /**
    @var object
  */
  protected static $Child;
  /**
    @var img path
  */
  protected static $img;
  /**
    @var img path
  */
  protected static $result;

  public function __construct(){
    require_once(DIR_WS_INCLUDES.'exts/PHPlot/PHPlot.php');

  }


  /**
    @brief load and conststrcu base call for PHPlot graphs
    @param $Child string name grpah_stats Module type init
    @param $option array option
    @return path img
  */
  public function CallConfig($Child,$option=array()){

    $val=self::$Child=new $Child();


    $stats=self::$Child->value;
    $les_color=self::$Child->les_color;
    $les_color_name=self::$Child->les_color_name;


    $get=tep_extrac_querystring();

    $mini=(((bool)$option['mini'])?false :true );
    $width= $option['width'];
    $height= $option['height'];
    self::$img=$option['PathImgCache'];

    $mode=(isset($get['mode_view'])) ? $get['mode_view'] : 'stackedbars';

    $graph = new PHPlot($width, $height,self::$img );

    $graph->SetFileFormat(GraphUtility::$_extension);
    $graph->SetIsInline(3);
    $graph->SetPrecisionY(2);
    $graph->SetDataType('text-data');


    //! bordure ext
    $graph->SetImageBorderType('plain');

    $graph->SetPlotType($mode); // bars, stackedbars, lines, linepoints, area, points, pie, thinbarline, squared, stackedarea

    //! SetPlotType= linepoints
    $graph->SetPointSizes(10); // int
    $graph->SetPointShapes('line'); //halfline, line, plus, cross, rect, circle, dot, diamond, triangle, trianglemid, delta, yield, star, hourglass, bowtie, target, box, home, up, down, none
    $graph->SetLineStyles('solid'); // dashed, solid, none

    $graph-> SetDrawXDataLabelLines ('lines'); //lines, points, linepoints, thinbarline

    $graph->SetPlotBorderType('none'); // left, sides, none, full

    $graph->SetDrawBrokenLines(true);
    $graph->SetLabelScalePosition(0.5);

    $graph->SetPointShapes('cross'); //halfline, line, plus, cross, rect, circle, dot, diamond, triangle, trianglemid, delta, yield, star, hourglass, bowtie, target, box, home, up, down, none'

    $graph->SetPlotBorderType( "left");
  //   $graph->SetVertTickPosition('plotleft');
    $graph->SetDataValues($stats);
    $graph->SetDataColors($les_color,$les_color);
  //   $graph->SetTransparentColor($les_color[1]);

    //! 3D
    $graph->SetShading(true);

    //! couleur de fond et arriere plan
  //   $graph->SetDrawPlotAreaBackground( true );
  //   $graph->SetPlotBgColor( "#cccccc");
    $graph->SetBackgroundColor('#f0f0ee');
    $graph->SetTransparentColor('#f0f0ee');

    //! grille
    $graph->SetDrawDashedGrid ('dashed') ; //solid or dashed
    $graph->SetDefaultDashedStyle('4-3');
    $graph->SetLightGridColor( "#828282");

    //! font , et taille
    $graph->SetTitleFontSize('3');
    $graph->SetTTFPath(DIR_FS_CATALOG.DIR_WS_COMMON_FONTS);
    $graph->SetDefaultTTFont('arial.ttf');
    $graph->SetFontTTF('x_label', 'arial.ttf','6');
    $graph->SetFontTTF('legend', 'arial.ttf','10');

    if($mini){
      //! tableau legende
      $graph->SetLegend($les_color_name);

      //! Title
      $graph->SetTitle(self::$Child->title);
    }

    //! label
  //   $plot->SetTitle('Candy Sales by Month and Product');
  //   $plot->SetYTitle('Millions of Units');
  //   $plot->SetXTitle('Millions of Units');
    $graph->SetXTickLabelPos('none');
    $graph->SetXTickPos('none');
    $graph->SetTextColor('#666666');

    if($mini){
      //! pos label X
      $graph->SetXDataLabelPos ('plotup') ; // plotup,plotdown,both, none
      $graph->SetXTickPos('none');
      //! Turn on Y data labels:
      $graph->SetYDataLabelPos('none'); // plotin, none
      $graph->SetYTickPos('none');
      //! incrementation
      $graph->SetVertTickIncrement(  self::$Child->base_y/10 );
      $graph->SetFontTTF('y_label', 'arial.ttf','8');
    }
    else {
      /**
	@remarks is mini graphs
      */
      //! pos label X
      $graph->SetXDataLabelPos ('none') ; // plotup,plotdown,both, none
      $graph->SetXTickPos('none');
      //! Turn on Y data labels:
      $graph->SetYDataLabelPos('none'); // plotin, none
      $graph->SetYTickPos('none');
      //! incrementation
      $graph->SetVertTickIncrement(  self::$Child->base_y );
      $graph->SetFontTTF('y_label', 'arial.ttf','0');
    }

    $graph->DrawGraph();

    self::$result=$graph->PrintImage();

    return self::$img;

  }


  /**
    @fn $var->CallGraph();
    @brief Call result construct graphs
    @return path img or null
  */
  public function CallGraph(){
    if(self::$result)return self::$img;
  }

}
?>