<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  03/01/11, 17:28
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @file
  @brief base functions and class fro login by methode
  Cette fonction assure l'identification par la methode intégres a oscss. 
  Cette methode require la class SimpleOpenId , dans common
  
  @note necessite la lib curl installé !
*/


Class openid {
	
  function __construct(){
  }
  
  /**
   * \fn draw()
   * \brief call html 
   */
  public function draw(){
  	if (!function_exists('curl_init')) return ;
  	return tep_get_include_contents('login.'.__CLASS__);
  }
  
  /**
   * \fn check()
   * \brief call check exe 
   */
  public function check(){
  	if (!function_exists('curl_init')) return null;
  	 
	  if( ( isset($_POST['openID']) && tep_not_null($_POST['openID']) || isset($_GET['openid_assoc_handle']) )) 
	     return $this->check_exe();
    else 
	     return null;
  }
  
  /**
   * \fn check()
   * \brief test and retrun bool
   * \return boolean
   */
	protected function check_exe(){
	 
	    // Get identity from user and redirect browser to OpenID Server
	    if (isset($_POST['openID'])){
	  $openid = new SimpleOpenID;
	  $openid->SetIdentity($_POST['openID']);
	  $openid->SetTrustRoot('http://' . $_SERVER["HTTP_HOST"]);
	  $openid->SetRequiredFields(array('email','fullname'));
	  $openid->SetOptionalFields(array('dob','gender','postcode','country','language','timezone'));
	  if ($openid->GetOpenIDServer()){
	      $openid->SetApprovedURL('http://' . $_SERVER["HTTP_HOST"] . $_SERVER["SCRIPT_NAME"]);      // Send Response from OpenID server to this script
	      $openid->Redirect();     // This will redirect user to OpenID Server
	  }else{
	      $error = $openid->GetError();
	      return false;
	  }
	  return false;
	    }
	    // Perform HTTP Request to OpenID server to validate key
	    elseif($_GET['openid_mode'] == 'id_res'){
	  $openid = new SimpleOpenID;
	  $openid->SetIdentity($_GET['openid_identity']);
	  $openid_validation_result = $openid->ValidateWithServer();
	  if ($openid_validation_result == true){
	    // OK HERE KEY IS VALID
	    return $this->recup_lid($_GET['openid_identity']);
	  }else if($openid->IsError() == true){
	    // ON THE WAY, WE GOT SOME ERROR
	    $error = $openid->GetError();
	    return false;
	  }else{
	    // Signature Verification Failed
	    echo "INVALID AUTHORIZATION";
	    return false;
	  }
	    }else if ($_GET['openid_mode'] == 'cancel'){
	      // User Canceled your Request
	      echo "USER CANCELED REQUEST";
	      return false;
	    }
	  

	}



  /**
   * \fn recup_lid($url_openid)
   * \brief call url in db 
   * \param $url_openid string
   * \return boolean
   */
  private function recup_lid($url_openid){
    $DB=Database::getInstance();
    $check_admin_query = $DB->query($sql="select admin_id as login_id  from " . TABLE_ADMIN . " where url_openid = '" . tep_db_input($url_openid) . "'");
    if (!$check_admin_query->__get('numRows')) {
      return false;
    } else {
      $check_admin = $check_admin_query->fetchAssoc();
      self::$lID=$check_admin['login_id'];

      return true;
    }
    return false;
  }


}



?>