<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  10/11/10, 16:36/
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class packageRepository
*/

if(!class_exists('package')) include_once(DIR_WS_MODULES .'pages/package.php');


class packageRepository
  extends package {

  public function __construct(){
  }


  /**
    Ajout d'un depot
  */
  public static function SourceAdd(){
  }

  /**
    Suppression d'un depot
  */
  public static function SourceRemove(){
  }

  /**
    Load xml data,
  */
  public static function SourceLoad(){
    global  $messageStack,$osCSS_Cache;
    try{
      //! load xml file
      if(!$Parser = @simplexml_load_file(DIR_FS_ADMIN.DIR_WS_INCLUDES.'data/'.self::REPOSITORY_SOURCE)) throw new Exception('Flux introuvable');
      $FeedItem = $Parser->xpath('channel');

      if(!$osCSS_Cache->read(parent::REPOSITORY_CACHE,0,true)) throw new Exception('Cache introuvable');
      //! recup info cache
      $var_file = $osCSS_Cache->getCache();

      foreach($FeedItem as $item){
	$item->last_update=(isset($var_file[(string)$item->key]['last_update'] ) ? $var_file[(string)$item->key]['last_update'] : 'N/A');
	parent::$FeedItem[]=$item;
      }
    }
    catch(Exception $e){
       $messageStack->add_session($e->getMessage(),'error' );
    }
  }


  public static function SourceLastUpdate($key){
  }

  /**
    Recup info depot par rapport a sa key
  */
  public static function SourceLoadByKey($key){
    global  $messageStack;
    try{
      //! load xml file
      if(!$Parser = @simplexml_load_file(DIR_FS_ADMIN.DIR_WS_INCLUDES.'data/'.self::REPOSITORY_SOURCE)) throw new Exception('Flux introuvable');
      $FeedItem = $Parser->xpath('channel');
      foreach($FeedItem as $item){
	if((string)$item->key == (string)$key) return $item;
      }
    }
    catch(Exception $e){
       $messageStack->add_session($e->getMessage(),'error' );
    }
  }

  /**
    Write file xml global source respoitory
    and mise en cache
  */
  public static function SourceUpdate(){
    global $messageStack;
    $osCSS_Cache = new osCSS_Cache;
    $var_file=$temparray=array();

    //! object global concatene object repository
    $globalRepository= array(); //new objectInfo(array());
    //! compteur entree global
    $compteur=0;
    $InternalID=1;


    try{
      //! declare cache
      $osCSS_Cache->read(parent::REPOSITORY_CACHE,0, true);

      $dom = new DomDocument('1.0');
      $rss = $dom->createElement("rss");
      $dom->appendChild($rss);
      $channel = $dom->createElement("channel");
      $rss->appendChild($channel);

      if(!$SP = simplexml_load_file(DIR_FS_ADMIN.DIR_WS_INCLUDES.'data/'.parent::REPOSITORY_SOURCE)) throw new Exception('Fichier Source introuvable '.DIR_WS_ADMIN.DIR_WS_INCLUDES.'data/'.parent::REPOSITORY_SOURCE);

      foreach($SP as $repo){
	if(!$re= fileUtility::url_fopen($repo->repository.$repo->rep_listing) ) $messageStack->add_session('recuperation repository impossible :'.$repo->repository,'error' );
	else {

	  if(!$Repos = simplexml_load_string($re)) $messageStack->add_session('Impossible lire le contenu :'.$repo->title,'error' );
	  else{
	    //! compteur entree / repository
	    $comp=0;
	    //! concatene



	    $objres=$Repos->channel->item;
	    foreach($objres as $item){
  	      $item->sourceTitle=(string)$repo->title;
  	      $item->sourceKey=(string)$repo->key;
	      $item->internalID=$InternalID;
	      $comp++;
	      $InternalID++;
  	      $dom_sxe = dom_import_simplexml($item);
	      $dom_sxe=$dom->importNode($dom_sxe, true);
	      $channel->appendChild($dom_sxe);
	      $dom->saveXML();

	      $temparray[(string)$repo->ident.'_'.(string)$repo->level]='';
	    }

	    //! mise en cache info
	    $var_file[(string)$repo->key]['last_update']= date("Y-m-d H:n:s");
	    $var_file[(string)$repo->key]['count']= $comp;
	    $var_file[(string)$repo->key]['title']= (string)$repo->title;
	    $var_file[(string)$repo->key]['link']= (string)$repo->repository;
// 	    $var_file[(string)$repo->key]['object']=$objres;

	    //! message
	    $messageStack->add_session(__('repository ok :').$repo->title,'success' );
	  }

	  $compteur +=$comp;
	}

	//! mise en cache global
	$var_file['global']['last_update']= date("Y-m-d H:n:s");
	$var_file['global']['count']= $compteur;
// 	$var_file['global']['object']=new objectInfo($globalRepository);

      }

      if(count($var_file)==0) throw new Exception('Erreur recuperation');

      //! add local package
      $locale=0;
      foreach(scan(DIR_FS_CIP) as $item){
	$pkg=(!is_dir(DIR_FS_CIP.$item))?substr($item, 0,(strlen($item) -4) ) : $item;
	if(!isset($temparray[$pkg]) && $pkg !='index.' && !empty($pkg)) {

	  $st=strpos($pkg,'_stable');
	  $unst=strpos($pkg,'_unstable');
	  if($st>0){
	    $ident=substr($pkg,0,$st);
	    $level=substr($pkg,$st+1);
	  }
	  elseif($unst>0){
	    $ident=substr($pkg,0,$unst);
	    $level=substr($pkg,$unst+1);
	  }
	  else{
	    $ident=$pkg;
	    $level='unstable';
	  }
	  $InternalID++;
	  $comp++;
	  $locale++;
	  $re="\n".'<item>'."\n".
	      '<title>'.$pkg.'</title>'."\n".
	      '<ident>'.$ident.'</ident>'."\n".
	      '<author>local</author>'."\n".
	      '<version>N/A</version>'."\n".
	      '<level>'.$level.'</level>'."\n".
	      '<checksum>'.md5(DIR_FS_CIP.$pkg).'</checksum>'."\n".
	      '<url_src></url_src>'."\n".
	      '<pid>'.$locale.'</pid>'."\n".
	      '<internalID>'.$InternalID.'</internalID>'."\n".
	      '<link></link>'."\n".
	      '<image></image>'."\n".
	      '<description>'.$ident.'</description>'."\n".
	      '<sourceTitle>local</sourceTitle>'."\n".
	      '</item>'."\n";
	  $res=simplexml_load_string($re);
	  $dom_sxe = dom_import_simplexml($res);
	  $dom_sxe=$dom->importNode($dom_sxe, true);
	  $channel->appendChild($dom_sxe);
	  $dom->saveXML();

	  //! mise en cache info
// 	  $var_file[$pkg]['last_update']= date("Y-m-d H:n:s");
// 	  $var_file[$pkg]['count']= $comp;
	}
      }
      //! message
      $messageStack->add_session(__('repository ok :').' local','success' );


      @unlink(DIR_FS_ADMIN.DIR_WS_INCLUDES.'data/'.parent::REPOSITORY_DATA);

      if($dom->save(DIR_FS_ADMIN.DIR_WS_INCLUDES.'data/'.parent::REPOSITORY_DATA) !=true)throw new Exception('erreur enregistrement');
      $osCSS_Cache->writeBuffer($var_file,true);


    }
    catch(Exception $e){
       $messageStack->add_session($e->getMessage(),'error' );
//        $messageStack->add($e->getMessage(),'error' );
    }
    return true;
  }


}


?>