<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  10/02/11, 11:08
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class packageUtility
*/

if(!class_exists('package')) include_once(DIR_WS_MODULES .'pages/package.php');

class packageUtility
  extends package {

  public function __construct(){


    parent::$set = (isset($_GET['set']) ? $_GET['set'] : '');
    parent::$class = (isset($_GET['class']) ? $_GET['class'] : '');

    parent::$code_inistalletd_array['checkout_process']=array('key'=>'MODULE_CHECKOUT_PROCESS_INSTALLED', 'value'=>MODULE_CHECKOUT_PROCESS_INSTALLED, 'module_directory'=> 'checkout_process/');
    parent::$code_inistalletd_array['shipping']=array('key'=>'MODULE_SHIPPING_INSTALLED', 'value'=>MODULE_SHIPPING_INSTALLED, 'module_directory'=>'shipping/');
    parent::$code_inistalletd_array['payment']=array('key'=>'MODULE_PAYMENT_INSTALLED', 'value'=>MODULE_PAYMENT_INSTALLED, 'module_directory'=> 'payment/');
    parent::$code_inistalletd_array['order_total']=array('key'=>'MODULE_ORDER_TOTAL_INSTALLED', 'value'=>MODULE_ORDER_TOTAL_INSTALLED, 'module_directory'=> 'order_total/');

    parent::$code_inistalletd_array['configuration']=array( 'key_BO'=>'MODULE_GENERIC_INSTALLED_BO', 'value_BO'=>'MODULE_GENERIC_INSTALLED','module_directory'=>'configuration/','module_language'=>DIR_FS_ADMIN.'includes/languages/');
    parent::$code_inistalletd_array['pages']=array('key_BO'=>'MODULE_GENERIC_INSTALLED_BO', 'value_BO'=>'MODULE_GENERIC_INSTALLED','module_directory'=>'pages/','module_language'=>DIR_FS_ADMIN.'includes/languages/');

    parent::$code_inistalletd_array['generic']=array('key'=>'MODULE_GENERIC_INSTALLED', 'value'=>MODULE_GENERIC_INSTALLED, 'key_BO'=>'MODULE_GENERIC_INSTALLED_BO', 'value_BO'=>MODULE_GENERIC_INSTALLED_BO,'module_directory'=>'generic/','module_language'=>DIR_FS_ADMIN.'includes/languages/');
    parent::$code_inistalletd_array['products']=array('key'=>'MODULE_ACAPRO_INSTALLED', 'value'=>MODULE_ACAPRO_INSTALLED,'key_BO'=>'MODULE_ACAPRO_INSTALLED_BO', 'value_BO'=>MODULE_ACAPRO_INSTALLED_BO,'module_directory'=> 'products/','module_language'=>DIR_FS_ADMIN.'includes/languages/' );
    parent::$code_inistalletd_array['content']=array('key'=>'MODULE_CONTENT_INSTALLED', 'value'=>MODULE_CONTENT_INSTALLED, 'key_BO'=>'MODULE_CONTENT_INSTALLED_BO', 'value_BO'=>MODULE_CONTENT_INSTALLED_BO,'module_directory'=>'content/','module_language'=>DIR_FS_ADMIN.'includes/languages/');
    parent::$code_inistalletd_array['categories']=array('key'=>'MODULE_ACACAT_INSTALLED', 'value'=>MODULE_ACACAT_INSTALLED ,'key_BO'=>'MODULE_ACACAT_INSTALLED_BO', 'value_BO'=>MODULE_ACACAT_INSTALLED_BO,'module_directory'=> 'categories/','module_language'=>DIR_FS_ADMIN.DIR_WS_LANGUAGES );
    parent::$code_inistalletd_array['account']=array('key'=>'MODULE_ACCOUNT_INSTALLED', 'value'=>MODULE_ACCOUNT_INSTALLED,'key_BO'=>'MODULE_ACCOUNT_INSTALLED_BO', 'value_BO'=>MODULE_ACCOUNT_INSTALLED_BO,'module_directory'=> 'account/','module_language'=>DIR_FS_ADMIN.DIR_WS_LANGUAGES  );
    parent::$code_inistalletd_array['listing']=array('key'=>'MODULE_LISTING_INSTALLED', 'value'=>MODULE_LISTING_INSTALLED,'key_BO'=>'MODULE_LISTING_INSTALLED_BO', 'value_BO'=>@MODULE_LISTING_INSTALLED_BO,'module_directory'=> 'listing/','module_language'=>DIR_FS_ADMIN.DIR_WS_LANGUAGES );
    parent::$code_inistalletd_array['home']=array('key'=>'MODULE_HOME_INSTALLED', 'value'=>MODULE_HOME_INSTALLED, 'key_BO'=>'MODULE_HOME_INSTALLED_BO', 'value_BO'=>MODULE_HOME_INSTALLED_BO ,'module_directory'=>'home/','module_language'=>DIR_FS_ADMIN.DIR_WS_LANGUAGES );


  }


  public static function load_product_info($id, $src){
    try{
      if(!$Sparser = @simplexml_load_file($FeedUrl)) throw new Exception('Flux introuvable');
      foreach($SimpleParser->xpath('channel/item') as $item) {
	  $FeedDate = $item->xpath('dc:date');
	  print("<dl>\n");
	  printf("<dt><a href='%s'>%s</a> <span class=\"date\">(%s)</span></dt>\n",(string)$item->link, (string)$item->title, str_replace(array('T','Z'),' ',(string)$FeedDate[0]));
	  printf("<dd>%s</dd>\n",(string)$item->description);
	  print("</dl>\n");
      }
    }
    catch(Exception $e){
      echo $e->getMessage();
    }
  }

  /**
    Config
  */
  public function right_bar(){
    global $language,$heading,$contents;

      switch (parent::$action) {
	case 'edit':

	$cls=strtoupper($_GET['class']);

// 	if(!isset($_GET['core']))
// 	  @include_once(DIR_FS_CATALOG_LANGUAGES . $language . '/modules/' . $_GET['set'] . '/' . parent::$modules_array[$_GET['set']][$cls]['file']);
// 	elseif(!@include_once(DIR_FS_ADMIN.DIR_WS_LANGUAGES . $language . '/modules/' . $_GET['set'] . '/' . parent::$modules_array[$_GET['set']][$cls]['file']))
// 	  @include_once(DIR_FS_CATALOG_LANGUAGES . $language . '/modules/' . $_GET['set'] . '/' . parent::$modules_array[$_GET['set']][$cls]['file']);

	$oscss=oscss_cstr::getInstance();
	if(isset($_GET['core'])) $oscss->pile_file_lang(DIR_FS_ADMIN.DIR_WS_LANGUAGES.$language.'/modules/'.$_GET['set'] . '/'.parent::$modules_array[$_GET['set']][$cls]['filelg'].'.txt');
	else $oscss->pile_file_lang(DIR_FS_CATALOG.DIR_WS_LANGUAGES.$language.'/modules/'.$_GET['set'] . '/' .parent::$modules_array[$_GET['set']][$cls]['filelg'].'.txt');

	if(!isset($_GET['core'])) include_once(parent::$modules_array[$_GET['set']][$cls]['path'].parent::$modules_array[$_GET['set']][$cls]['file']);
	else include_once(parent::$modules_array[$_GET['set']][$cls]['path_BO'].parent::$modules_array[$_GET['set']][$cls]['file']);


	  $module = new $_GET['class'];
	  $module_info = array('code' => $module->code,
			      'title' => $module->title,
			      'description' => $module->description,
			      'status' => $module->check());
	  $keys = '';
	  $module_keys = $module->keys();

	  if(!$module->check()){
	    $module->remove();
	    $module->install();
	  }

	    $keys_extra = array();
	    for ($j=0, $k=sizeof($module_keys); $j<$k; $j++) {
	      $key_value_query = tep_db_query("select configuration_title, configuration_value, configuration_description, use_function, set_function from " . TABLE_CONFIGURATION . " where configuration_key = '" . $module_keys[$j] . "'");
	      $key_value = tep_db_fetch_array($key_value_query);

	      $keys_extra[$module_keys[$j]]['title'] = $key_value['configuration_title'];
	      $keys_extra[$module_keys[$j]]['value'] = $key_value['configuration_value'];
	      $keys_extra[$module_keys[$j]]['description'] = $key_value['configuration_description'];
	      $keys_extra[$module_keys[$j]]['use_function'] = $key_value['use_function'];
	      $keys_extra[$module_keys[$j]]['set_function'] = $key_value['set_function'];
	    }

	    $module_info['keys'] = $keys_extra;

	    $mInfo = new objectInfo($module_info);

	  $get =(isset($_GET['class'] )) ? 'class='.$_GET['class'] : '';
	  $get .=(isset($_GET['core'] )) ? '&amp;core='.$_GET['core'] : '';
	  $get .=(isset($_GET['set'] )) ? '&amp;set='.$_GET['set'] : '';


	  $format['title']='<dt>%s</dt>';
	  $format['description']='<dd><label>%s</label>';
	  $format['block']='%s</dd>';

	  $keys .= '<dl>';
	  $keys .= configUtility::FormatEditAuto(array('array'=>$keys_extra, 'format'=>$format));
	  $keys .= '</dl>';

	  $heading[] = array('text' => '['.$_GET['set'].']'.$mInfo->title );

	  $contents = array('form' => tep_draw_form('modules', parent::FILENAME, $get.'&amp;action=save'));
	  $contents[] = array('class' => 'block_input','text' => $keys);
	  $contents[] = array('class' => 'button_nav', 'text' => tep_image_submit('button_update.gif', IMAGE_UPDATE) .  tep_js_back(tep_href_link(parent::FILENAME, $get.'&action=config'), IMAGE_CANCEL));
	break;
	default:
	  if(isset($mInfo) && is_object($mInfo)) {
	    $heading[] = array('text' => $mInfo->title );

	    if ($mInfo->status == '1') {
	      $keys = '';
	      reset($mInfo->keys);
	      while (list(, $value) = each($mInfo->keys)) {
		$keys .= '<strong>' . $value['title'] . '</strong><br />';
		if ($value['use_function']) {
		  $use_function = $value['use_function'];
		  $set_function =(isset($value['set_function'])) ? $value['set_function'] : $class_method[1];
		  if (preg_match('/->/', $use_function)) {
		    $class_method = explode('->', $use_function);
		    if ( isset(${$class_method[0]}) && !is_object(${$class_method[0]})) {
		      include_once(DIR_WS_CLASSES . $class_method[0] . '.php');
		      ${$class_method[0]} = new $class_method[0]();
		    }
		    $keys .= tep_call_function($set_function, $value['value'], ${$class_method[0]});
		  } else {
		    $keys .= tep_call_function($use_function, $value['value']);
		  }
		} else {
		  $keys .= $value['value'];
		}
		$keys .= '<br /><br />';
	      }
	      $keys = substr($keys, 0, strrpos($keys, '<br /><br />'));

	      $contents[] = array('text' => $mInfo->description);
	      $contents[] = array('text' => $keys);
	    } else {
	      $contents[] = array('text' => $mInfo->description);
	    }
	  }
	  break;
      }
  }



  public static function load_config_value(){

    $file_extension = '.php';
    $directory_array =$modules_array= array();
    foreach(parent::$code_inistalletd_array as $key=>$value) {

      if(!isset(parent::$modules_array[$key]))parent::$modules_array[$key]=array();

      //! Scan file FO
      $module_directory=DIR_FS_CATALOG_MODULES.$value['module_directory'];
      $module_directory_template=DIR_FS_CATALOG.'templates/'.TEMPLATE_NAME.'/'.DIR_WS_MODULES.$value['module_directory'];
      $module_directory_admin=DIR_FS_ADMIN.DIR_WS_MODULES.$value['module_directory'];
      if ($dir = @dir($module_directory)) {
	  while ($file = $dir->read()) {
	    if(!in_array($file,array('.','..','.svn','.htaccess','index.html')))
	      parent::$modules_array[$key]=array_merge((array) parent::$modules_array[$key],self::info_module($file,$module_directory, $module_directory_admin, $file_extension) );
	  }
	  sort($directory_array);
	  $dir->close();
      }
      //! Scan file template courant FO
       if ($dir = @dir($module_directory_template)) {
	  while ($file = $dir->read()) {
	    if(!in_array($file,array('.','..','.svn','.htaccess','index.html')))
	      parent::$modules_array[$key]=array_merge((array) parent::$modules_array[$key],self::info_module($file,$module_directory_template, $module_directory_admin, $file_extension) );

	  }
	  sort($directory_array);
	  $dir->close();
      }


      //! Scan file BO

      if ($dir = @dir($module_directory_admin)) {

	  while ($file = $dir->read()) {

	    if(!in_array($file,array('.','..','.svn','.htaccess','index.html')))
	      parent::$modules_array[$key]=array_merge((array) parent::$modules_array[$key],self::info_module($file,$module_directory, $module_directory_admin, $file_extension) );

	  }
	  sort($directory_array);
	  $dir->close();
      }
    }

  }

  /**
    @param
      @a string element file/dir
      @a string path shop
      @a string path admin
      @a string ext
  */
  private static function info_module($file,$ref_shop, $ref_admin, $ref_ext='.php'){
    $_array=array();
    $filelg='';
    //! module dans leur propre sous rep
    if(is_dir($ref_shop.$file)) {
      $ref_shop .= $file.'/';
      $ref_admin .= $file.'/';
      $file .=$ref_ext;
      $filelg = $file.'/';
    }

    //! verif file in ext php
    if (substr($file, strrpos($file, '.')) == $ref_ext) {
      $class=substr($file, 0, (strlen($file)-strlen($ref_ext)));
      $code=strtoupper($class);

      if (file_exists($ref_admin.$file))$_array[$code]['path_BO']=$ref_admin;
      if(file_exists($ref_shop.$file)) $_array[$code]['path']=$ref_shop;
      $_array[$code]['file']=$file;
      $_array[$code]['class']=$class;
      $_array[$code]['filelg']=$filelg.$class;
    }

    return $_array;
  }
}


?>