<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @originla author Made by Imrich Schindler <ischindl at progis.sk>
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  19/12/10, 18:52
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class Tc_add2end
  @brief add data in end file

  \EXAMPLE:
  <add2end>
    <file name="filename.php"/>
    <add type="php"><![CDATA[ ... ]]></add>
  </add2end>
*/
class Tc_add2end
  extends ContribInstallerBaseTag
    implements PackageTags {


  var $tag_name='add2end';


  function __construct($contrib='', $id='', $xml_data='', $dep='') {
      $this->params=array(
	'filename'=>array(
	  'sql_type'=>'varchar (255)',
	  'xml_error'=>"no file name; "
	  ),
	'add'=>array(
	  'sql_type'=>'text',
	  'xml_error'=>"no add section; "
	  ),
	'type'=>array(
	  'sql_type'=>"ENUM ('php', 'html')",
	  ),
      );
      $this->ContribInstallerBaseTag($contrib, $id, $xml_data, $dep);
  }



  public function get_data_from_xml_parser($xml_data='') {
    $this->data['filename'] = replace_path_admin($this->getTagAttr($xml_data,'file',0,'name'));
    $this->data['add']      = $this->getTagText($xml_data,'add',0);
    $this->data['type'] = $this->getTagAttr($xml_data,'add',0,'type');
    if(isset($this->data['find']) && $this->data['find']==''){
      $this->data['end'] = 1;
      $this->data['start'] =1;
    }
  }


  function write_to_xml() {
      $tag = '
      <'.$this->tag_name.'>
	  <file name="'.$this->data['filename'].'" />
	  <add '. (($this->data['type']) ? 'type="'.$this->data['type'].'"' : '') .'><![CDATA['. $this->data['add']. ']]></add>
      </'.$this->tag_name.'>';
      return $tag;
  }


/**-----------------------------permissions--------------------------- */

  public function permissions_check_for_install($name='') {
    if (!$name) $name=$this->fs_filename();
    if (!file_exists($name)) CIP::InProcess(__("cant read file").$name, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
    elseif(!is_writable($name)) CIP::InProcess(__("write permissins needed text").$name, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
    else return true;
    return false;
  }

  public function permissions_check_for_remove() {
    return $this->permissions_check_for_install($this->fs_filename());
  }

/**-----------------------------conflicts--------------------------- */

  public function conflicts_check_for_remove() {
    $find=$this->add_str();
    $new_file=$this->linebreak_fixing(file_get_contents($this->fs_filename()));
    $this->write_to_file($this->fs_filename(), $new_file);
    $count=substr_count($new_file, $find);
    //We can also check a database records for conflicts.
    if ($count==0) {
      $sg=__('couldnt find text').": ".nl2br(htmlspecialchars($find)). "<br />". __('in the file text'). $this->fs_filename();
      CIP::InProcess($sg, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
      return false;
    }
    return true;
  }

/**
  TODO: controler le checksum
  @date  25/07/10, 12:50
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
*/
  public function conflicts_check_for_install() { return true; }

/**-----------------------------EXE--------------------------- */

  function do_install() {
    if(!$this->add_file_end($this->data['filename'],$this->add_str($this->data['add']))) return false;
    return true;

  }

  function do_remove() {
    if(!$this->remove_file_part($this->data['filename'],$this->add_str($this->data['add']))) return false;
    return true;
  }
}


?>