<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  19/12/10, 18:52
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class Tc_add2endlg
  @brief add data in end file  for file language. loop for language

  \EXAMPLE:
  <add2endlg>
    <file name="admin/includes/languages/%LANGUAGE%/boxes/07_catalog.php" />
    <add type="php"  lgref="fr_FR"><![CDATA[define('BOX_CATALOG_MANUFACTURERS', 'fabricants');]]></add>
  </add2endlg>

*/
class Tc_add2endlg
  extends ContribInstallerBaseTag
    implements PackageTags {


  var $tag_name='add2endlg';


  function __construct($contrib='', $id='', $xml_data='', $dep='') {
      $this->params=array(
	'filename'=>array(
	  'sql_type'=>'varchar (255)',
	  'xml_error'=>"no file name; "
	  ),
	'add'=>array(
	  'sql_type'=>'text',
	  'xml_error'=>"no add section; "
	  ),
	'type'=>array(
	  'sql_type'=>"ENUM ('php', 'html')",
	  ),
	'lgref'=>array(
		      'sql_type'=>'varchar(255)',
		      ),
      );
      $this->ContribInstallerBaseTag($contrib, $id, $xml_data, $dep);
  }



  public function get_data_from_xml_parser($xml_data='') {
    $this->data['filename']=array();
    $this->data['add']=array();

    $this->data['type'] = $this->getTagAttr($xml_data,'add',0,'type');
    if(isset($this->data['find']) && $this->data['find']==''){
      $this->data['end'] = 1;
      $this->data['start'] =1;
    }

    $languages = tep_get_languages();
    $n=count($languages);

    for ($j=0; $j<$n; $j++) {
      $path = $languages[$j]['directory'];
      $this->data['filename'][$j] = str_replace('%LANGUAGE%',$path ,replace_path_admin($this->getTagAttr($xml_data,'file',0,'name')) );
      $this->data['lgref'][$j] = $this->getTagAttr($xml_data,'add',0,'lgref') ;
      $this->data['add'][$j] =$this->getTagText($xml_data,'add',0);
    }

  }


  function write_to_xml() {
      $tag = '
      <'.$this->tag_name.'>
	  <file name="'.$this->data['filename'].'" />
	  <add '. (($this->data['type']) ? 'type="'.$this->data['type'].'"' : '') .'><![CDATA['. $this->data['add']. ']]></add>
      </'.$this->tag_name.'>';
      return $tag;
  }


/**-----------------------------permissions--------------------------- */

  public function permissions_check_for_install() {
    if (!CIP::check_bylevel(1))return false;
    for($i = 0; $i < count($this->data['filename']);$i++){
      $fs_filename=replace_path_admin($this->fs_filename($i));
      $path=dirname($fs_filename);

      if(!is_dir($path))parent::recursive_mkdir($path);

      if(!is_writable($path)) {
	CIP::InProcess('check'.__('write permissins needed text').$path, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
	return false;
      }
      if(file_exists($fs_filename) && !is_writable($fs_filename)) {
	CIP::InProcess('check'.__('write permissins needed text').$this->fs_filename($i), __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
	return false;
      }
    }
    return true;
  }

  public function permissions_check_for_remove() {
    return $this->permissions_check_for_install($this->fs_filename());
  }

/**-----------------------------conflicts--------------------------- */

  public function conflicts_check_for_remove() { return true; }

/**
  TODO: controler le checksum
  @date  25/07/10, 12:50
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
*/
  public function conflicts_check_for_install() { return true; }

/**-----------------------------EXE--------------------------- */

  function do_install() {

    for($i = 0; $i < count($this->data['filename']);$i++){
      if(!$this->add_file_end($this->data['filename'][$i],$this->add_str($this->data['add'][$i]))) return false;
    }

    return true;

  }

  function do_remove() {
    for($i = 0; $i < count($this->data['filename']);$i++){
      if(!$this->remove_file_part($this->data['filename'][$i],$this->add_str($this->data['add'][$i]))) return false;
    }
    return true;
  }
}


?>