<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @original author Vlad Savitsky
  @Support: http://forums.oscommerce.com/index.php?showuser=20490,  http://forums.oscommerce.com/index.php?showtopic=156667
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  24/07/10, 18:07
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class Tc_addfile

  NOTE:
    Class Description operates with description-tag from install.xml.

  <addfile>
    <file name="admin/includes/modules/products/attributeManager.php" />
    <file name="includes/modules/products/attributeManager.php" />
  </addfile>

*/

class Tc_addfile
  extends ContribInstallerBaseTag
    implements PackageTags{

  var $tag_name='addfile';

  var $params;//array with attributes

  /**
    @param array liste des fichier a backup
  */
  protected static $backup_file=array();
  /**
    @param array liste des fichier a backup
  */
  protected static $restore_file=array();

  /**
    Collecteur d'erreur non fatal
  */
  private static $Exceptions = array();

  public function __construct($contrib='', $id='', $xml_data='', $dep='') {
    $this->params=array(
	'filename'=>array(
		      'sql_type'=>'varchar(255)',
		      'xml_error'=>__('name of file missing in addfile section text')
		      ),
	'srcdir'=>array(
		      'sql_type'=>'varchar(255)',
		      ),
    );
    $this->ContribInstallerBaseTag($contrib, $id, $xml_data, $dep);
  }

//  Class Methods
  public function get_data_from_xml_parser($xml_data='') {
    $this->data['filename']=array();
    $this->data['srcdir'] = array();
    $tags = $xml_data->getElementsByTagName('file');
    for ($i = 0; $i < $tags->length; $i++) {
      $this->data['filename'][$i] = $this->getITagAttr($tags,$i,'name');
      $this->data['srcdir'][$i] = $this->getITagAttr($tags,$i,'srcdir');
      if($this->data['srcdir'][$i]==NULL)$this->data['srcdir'][$i] = 'catalog';
    }
  }

  public function write_to_xml() {
    $tag =  '<'.$this->tag_name.'>';
    for($i = 0; $i < count($this->data['filename']);$i++){
	$tag .='<file name="'.$this->data['filename'][$i].'" srcdir="'.$this->data['srcdir'][$i].'"/>';
    }
    $tag.='</'.$this->tag_name.'>';
  }


/**-----------------------------permissions--------------------------- */
  public function permissions_check_for_remove() {
    for($i = 0; $i < count($this->data['filename']);$i++){
      $fs_filename=replace_path_admin($this->fs_filename($i));
      $path=dirname($fs_filename);

      if(!is_writable($path)) {
	CIP::InProcess('check'.__('write permissins needed text').$path."/", __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
	return false;
      }
      if(file_exists($fs_filename) && !is_writable($fs_filename)) {
	CIP::InProcess('check'.__('write permissins needed text').$fs_filename, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
	return false;
      }
    }
    return true;
  }

  public function permissions_check_for_install() {
    if (!CIP::check_bylevel(1))return false;
    for($i = 0; $i < count($this->data['filename']);$i++){
      $fs_filename=replace_path_admin($this->fs_filename($i));
      $path=dirname($fs_filename);

      if(!is_dir($path))parent::recursive_mkdir($path);

      if(!is_writable($path)) {
	CIP::InProcess('check'.__('write permissins needed text').$path, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
	return false;
      }
      if(file_exists($fs_filename) && !is_writable($fs_filename)) {
	CIP::InProcess('check'.__('write permissins needed text').$this->fs_filename($i), __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
	return false;
      }
    }
    return true;
  }

/**-----------------------------conflicts--------------------------- */

  public function conflicts_check_for_install() {
    if (!CIP::check_bylevel(1)) return false;

    for($i = 0; $i < count($this->data['filename']);$i++){
      $fs_filename=replace_path_admin($this->fs_filename($i));
      $backup_file=DIR_FS_BACKUP.CONTRIB_INSTALLER_NAME."_".CONTRIB_INSTALLER_VERSION.'/'. $this->data['filename'][$i];

      // check if file is already copied
      if($this->equal_files($backup_file,$fs_filename)) continue;

      if (!_cst_bool('ALLOW_OVERWRITE_MODIFIED')) {
	if (!is_file($cip_file)) {

	  $msg="Backup file ".$backup_file." is not exists. This file needed to check if file". $fs_filename. " was modified since Contrib Installer have been installed.
	  <br /><b>CIP.NET.UA Advise</b>:<br />
	  Set \"Allow Overwrite Existing Modified Files\" to TRUE and all modified files will be overwritten.
	  All changes will be lost!<br />
	  <i>or</i><br />
	  Copy clean osCommerce files to     ".DIR_FS_CIP."/".CONTRIB_INSTALLER_NAME."_".CONTRIB_INSTALLER_VERSION. "/catalog/ and try again.";

	  CIP::InProcess($msg, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'noblock');
	}
	elseif (file_exists($fs_filename) && file_exists($backup_file)&& !$this->equal_files($fs_filename, $backup_file)) {
	  $msg="File ".$current_file." exists and was modified since Contrib Installer have been installed. Overwriting is not allowed.<br /><b>CIP.NET.UA Advise</b>:<br />Set \"Allow Overwrite Existing Modified Files\" to TRUE or change install.xml.";
	  CIP::InProcess($msg, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
	  return false;
	}
      }
    }
    return true;
  }

  function conflicts_check_for_remove() {
    for($i = 0; $i < count($this->data['filename']);$i++){

      $cip_file=DIR_FS_CIP.'/'.$this->contrib.'/'.$this->data['srcdir'][$i].'/'.$this->data['filename'][$i];
      $current_file=$this->fs_filename($i);
      $backup_file=DIR_FS_BACKUP.$this->contrib.'/'.$this->data['filename'][$i];

      //! This is not an error because we could add new file:
      if (!file_exists($backup_file)) CIP::InProcess(__('backup file not exists text').' '. $backup_file, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'noblock');

      /**
	If file doesn't exists it's not an error and we will restore him.
	An error if file exists and have been modified and ALLOW_OVERWRITE_MODIFIED=='false'
      */
      if (!is_file($current_file)){
	CIP::InProcess(__('Le fichier est manquant ').$current_file, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'info');
	self::$Exceptions[]=$current_file;
      }
      /**
	If file was modified since CIP have been installed and
	ALLOW_OVERWRITE_MODIFIED set to FALSE we couldn't overwrite.
      */
      if (!_cst_bool('ALLOW_OVERWRITE_MODIFIED')) {
	if (is_file($cip_file)) {
	  if (!$this->equal_files($current_file, $cip_file)) {
	    CIP::InProcess("File ".$current_file." exists and was modified since CIP have been installed. Overwriting is not allowed.<br /><b>CIP.NET.UA Advise</b>:<br />Set \"Allow Overwrite Existing Modified Files\" to TRUE or change install.xml.".$cip_file, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
	    return false;
	  }
	} else {
	  CIP::InProcess("File ".$cip_file." needed to check if file". $current_file. " was modified since CIP have been installed.
	  <br /><b>CIP.NET.UA Advise</b>:<br />
	  Restore CIP files in Contributions folder and try again.<br />
	  <i>or</i><br />
	  Set \"Allow Overwrite Existing Modified Files\" to TRUE and all modified files will be overwritten.
	  All changes will be lost!", __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
	  return false;
	}
      }
    }
     return true;
  }



/**-----------------------------EXE--------------------------- */

  public function do_install() {
    if (!CIP::check_bylevel(1)) return false;

    for($i = 0; $i < count($this->data['filename']);$i++){
      $cip_file=DIR_FS_CIP.$this->contrib.'/'.$this->data['srcdir'][$i].'/'.$this->data['filename'][$i];
      $fs_filename=replace_path_admin($this->fs_filename($i));

      if (!file_exists($cip_file) && is_file($cip_file)) {
	CIP::InProcess("Run time error: <strong>".__("le fichier de la contrib n'existe pas ")."</strong><br /> fichier :: ".$cip_file, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
	return true;
      }

      if (is_file($fs_filename)) {

	//!if file is copied
	if($this->equal_files($cip_file,$fs_filename)){
	  CIP::InProcess("Run time : ".__('les fichiers sont identique ok! sortie  pour ').$fs_filename, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'info');
	  continue;
	}

	/**
	  If file exists we should backup them. Later we could restore him.
	  If we couldn't backup we should print an error and stop.
	  If Total_Backup havn't been done we should do it.
	*/
	if (_cst_bool('ALLOW_FILES_BACKUP')) parent::backup_file(replace_path_admin($this->data['filename'][$i]));

	if(!ci_remove($this->fs_filename($i)))CIP::InProcess("Run time error: ".__('impossible supprimer ce fichier ').$fs_filename, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'info');
      }

      //! We copy file to right location:
      if(fileUtility::_copy($cip_file, $fs_filename) ===false) {
	CIP::InProcess("Run time error: ".__('couldnt copy to text')."<br /> original:: ".$cip_file."<br /> copy:: ".$fs_filename, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
// 	trigger_error(__CLASS__.sprintf(' error %s', __FUNCTION__), E_USER_ERROR);
	return false;
      }

      if (file_exists($fs_filename))fileUtility::_chmod($fs_filename, 0777);
    }

    return true;
  }

  public function do_remove() {
    foreach($this->data['filename'] as $file){
      $fs_file=replace_path_admin($file);
      if(!in_array($this->get_fs_filename($file) ,self::$Exceptions)){
	$backup_file=DIR_FS_BACKUP.$this->contrib.'/'.$file;
	if (_cst_bool('ALLOW_FILES_RESTORE') && file_exists($backup_file) && !dir($backup_file) ){
	  if(!parent::restore_file($file)) return false;
	}
	else{
	  if(!ci_remove(DIR_FS_CATALOG.$fs_file)) return false;
	}

      }
    }
    return true;
  }

}

?>