<?php
/**
 @licence GPL 2005-2009  The osCSS developers - osCSS Open Source E-commerce
  @package oscss-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  19/12/10, 15:38
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class Tc_addfilelg
  @brief   Gestion de l'ajout de fichier de langue, en focntion des langue installé sur osc.
	    Si langue configuré non presente dans le cip, uen copie de la langue par defaut est faites.

  \EXAMPLE USAGE
  <addfilelg>
    <file name="newsletters_subscribers_view.php" srcdir="catalog/admin/includes/languages/%LANGUAGE%/"  lgref="fr_FR"/>
    <file name="newsletters.php"   srcdir="catalog/admin/includes/languages/%LANGUAGE%/" lgref="fr_FR"/>

    <file name="subscribe.php" srcdir="catalog/includes/languages/%LANGUAGE%/" lgref="fr_FR">
  </addfilelg>

  @a string lgref représente la langue de base de la contrib. si la contrib contient plusieur langue, seul la langue de base doit être declaré.  Les autre langue seront uniqument dependante de la shop sur laquel la contrib est installé
  @a string %LANGUAGE% rprente le code de langue a remplacé
  @a string srcdir le chemin du repertoire du fichier
  @a string  name  le non du fichier

*/
class Tc_addfilelg
  extends Tc_addfile /*ContribInstallerBaseTag*/
/*    implements PackageTags*/ {

  var $tag_name='addfilelg';
  var $data;
  /**
    @param array with attributes
  */
  var $params;



  /**
    Class Constructor
  */
  function __construct($contrib='', $id='', $xml_data='', $dep='') {
      $this->params=array(
	  'filename'=>array(
			    'sql_type'=>'varchar(255)',
			    'xml_error'=>__('name of file missing in addfile section text')
			    ),
	  'srcdir'=>array(
			  'sql_type'=>'varchar(255)',
			  ),
	  'lgref'=>array(
			'sql_type'=>'varchar(255)',
			),
	  'lgfile'=>array(
			'sql_type'=>'varchar(255)',
			),
      );
      parent::ContribInstallerBaseTag($contrib, $id, $xml_data, $dep);
  }

  /**
    Generation tableau base des element du tag , duplique en focntion des langeu installé
  */
  function get_data_from_xml_parser($xml_data='') {
    $this->data['filename']=array();
    $this->data['srcdir'] = array();
    $tags = $xml_data->getElementsByTagName('file');
    $languages = tep_get_languages();
    $n=count($languages);
    $c=0;
    $tags->length;
    for ($i = 0; $i < $tags->length; $i++) {
      reset($languages);
      for ($j=0; $j<$n; $j++) {
	$path = $languages[$j]['directory'];
	$this->data['filename'][$c] = str_replace('%LANGUAGE%',$path ,$this->getITagAttr($tags,$i,'name'));
	$this->data['srcdir'][$c] = str_replace('%LANGUAGE%',$path ,$this->getITagAttr($tags,$i,'srcdir'));
	$this->data['lgref'][$c] = $this->getITagAttr($tags,$i,'lgref') ;

	//! lang file en cours
	$this->data['lgfile'][$c] = $path ;

	if($this->data['srcdir'][$c]==NULL)$this->data['srcdir'][$c] = 'catalog';
	$c++;
      }
    }
  }


  function write_to_xml() {
      $tag =  '<'.$this->tag_name.'>';
      for($i = 0; $i < count($this->data['filename']);$i++){
	  $tag .='<file name="'.$this->data['filename'][$i].'" srcdir="'.$this->data['srcdir'][$i].'"/>';
      }
      $tag.='</'.$this->tag_name.'>';
  }


  public function do_install() {
    if (!CIP::check_bylevel(1)) return false;

    for($i = 0; $i < count($this->data['filename']);$i++){
      $cip_file=DIR_FS_CIP.$this->contrib.'/'.$this->data['srcdir'][$i].'/'.$this->data['filename'][$i];
      $fs_filename=replace_path_admin($this->fs_filename($i));

      //! si element de langueu absnet, remplace par celui de reference, cf attributes lgref
      if (!file_exists($cip_file))
	$cip_file=DIR_FS_CIP.$this->contrib.'/'. str_replace($this->data['lgfile'][$i] ,$this->data['lgref'][$i],$this->data['srcdir'][$i].'/'.$this->data['filename'][$i]);

      if (is_file($fs_filename)) {
	//!if file is copied
	if($this->equal_files($cip_file,$fs_filename)){
	  CIP::InProcess("Run time : ".__('les fichiers sont identique ok! sortie  pour ').$fs_filename, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'info');
	  continue;
	}

	/**
	  If file exists we should backup them. Later we could restore him.
	  If we couldn't backup we should print an error and stop.
	  If Total_Backup havn't been done we should do it.
	*/
	if (_cst_bool('ALLOW_FILES_BACKUP')) parent::backup_file(replace_path_admin($this->data['filename'][$i]));

	if(!ci_remove($this->fs_filename($i)))CIP::InProcess("Run time error: ".__('impossible supprimer ce fichier ').$fs_filename, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'info');
      }

      //! We copy file to right location:
      if(!fileUtility::_copy($cip_file, $fs_filename)) {
	CIP::InProcess("Run time error: ".__('couldnt copy to text')."<br /> original:: ".$cip_file."<br /> copy:: ".$fs_filename, __CLASS__.'->'.__FUNCTION__.'::'.__LINE__,'block');
	trigger_error(__CLASS__.sprintf(' error %s', __FUNCTION__), E_USER_ERROR);
	return false;
      }

      if (file_exists($fs_filename))chmod($fs_filename, 0777);
    }

    return true;
  }

  public function do_remove() {
    foreach($this->data['filename'] as $file){
      $fs_file=replace_path_admin($file);
//       if(!in_array($this->get_fs_filename($file) ,self::$Exceptions)){
	$backup_file=DIR_FS_BACKUP.$this->contrib.'/'.$file;
	if (_cst_bool('ALLOW_FILES_RESTORE') && file_exists($backup_file) && !dir($backup_file) ){
	  if(!parent::restore_file($file)) return false;
	}
	else{
	  if(!ci_remove(DIR_FS_CATALOG.$fs_file)) return false;
	}

//       }
    }
    return true;
  }


}

?>