<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @original author Vlad Savitsky
  @Support: http://forums.oscommerce.com/index.php?showuser=20490,  http://forums.oscommerce.com/index.php?showtopic=156667
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  24/07/10, 18:07
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class Tc_config

  NOTE

  <config>
  <title></title>
  <key></key>
  <group_key></group_key>
  [<value></value>]
  [<descr></descr>]
  [<sort_order></sort_order>]
  [<use_function></use_function>]
  [<set_function></set_function>]
  [<lang></lang>]
  </config>

*/

class Tc_config
  extends ContribInstallerBaseTag
    implements PackageTags{

  /**
    Tag xlm
  */
  var $tag_name = 'config';
  /**
    @param int group id
  */
  public static $gid;


  // Class Constructor
  function __construct($contrib = '', $id = '', $xml_data = '', $dep = '') {
    $this->params = array (
      'title' => array (
	'sql_type' => 'varchar(64)',
	'xml_error' => __('no title tag in config section text')
      ),
      'key' => array (
	'sql_type' => 'varchar(64)',
	'xml_error' => __('no key tag in config section text')
      ),
      'value' => array (
	'sql_type' => 'varchar(255)',
      ),
      'descr' => array (
	'sql_type' => 'varchar(255)',
      ),
      'group_key' => array (
	'sql_type' => 'varchar(255)',
	'xml_error' => __('no groupkey tag in config section text')
      ),
      'sort_order' => array (
	'sql_type' => 'int(5)',
      ),
      'use_function' => array (
	'sql_type' => 'varchar(255)',
      ),
      'set_function' => array (
	'sql_type' => 'varchar(255)',
      ),
//       'lang' => array (
// 	'sql_type' => 'varchar(64)',
//       ),
    );
    parent::ContribInstallerBaseTag($contrib, $id, $xml_data, $dep);
  }
	//  Class Methods
  function get_data_from_xml_parser($xml_data = '') {
    $this->data['title'] = $this->getTagText($xml_data, 'title', 0);
    $this->data['key'] = $this->getTagText($xml_data, 'key', 0);
    $this->data['value_type'] = $this->getTagAttr($xml_data, 'value', 0,'type');
    $this->data['value'] = $this->getTagText($xml_data, 'value', 0);
    $this->data['descr'] = $this->getTagText($xml_data, 'descr', 0);
    $this->data['group_key'] = $this->getTagText($xml_data, 'group_key', 0);
    $this->data['sort_order'] = $this->getTagText($xml_data, 'sort_order', 0);
    $this->data['use_function'] = $this->getTagText($xml_data, 'use_function', 0);
    $this->data['set_function'] = $this->getTagText($xml_data, 'set_function', 0);

    if ($this->data['value'] == NULL) $this->data['value'] = '';
    if($this->data['value_type']=="php"){
      if (isset($this->data['value'])) $this->data['value'] = @eval("return ".$this->data['value']);
      else $this->data['value']='';
    }
    if ($this->data['descr'] == NULL) $this->data['descr'] = '';
//     $this->data['lang'] = $this->getTagText($xml_data, 'lang', 0);
//     if ($this->data['lang'] == NULL)
// 	    $this->data['lang'] = 'english';
//     $this->data['add'] = "define('TEXT_CONF_".$this->data['key']."','".$this->data['title']."');\ndefine('TEXT_CONF_DESC_".$this->data['key']."','".$this->data['descr']."');";
//     $this->data['filename'] = 'admin/includes/languages/'.$this->data['lang'].'/box_configuration.php';
  }

  function write_to_xml() {
    $tag = '<' . $this->tag_name . '>' . "\n";
    $tag .= ' <title>' . $this->data['title'] . '</title>' . "\n";
    $tag .= ' <key>' . $this->data['key'] . '</key>' . "\n";
    $tag .= ' <group_key>' . $this->data['group_key'] . '</group_key>' . "\n";
    if ($this->data['value'] != NULL)
      $tag .= ' <value'.($this->data['value_type'] != NULL?' type="'.$this->data['value_type'].'"':'').'>' . $this->data['value'] . '</value>' . "\n";
    if ($this->data['descr'] != NULL)
      $tag .= ' <descr>' . $this->data['descr'] . '</descr>' . "\n";
    if ($this->data['sort_order'] != NULL)
      $tag .= ' <sort_order>' . $this->data['sort_order'] . '</sort_order>' . "\n";
    if ($this->data['use_function'] != NULL)
      $tag .= ' <use_function>' . $this->data['use_function'] . '</use_function>' . "\n";
    if ($this->data['set_function'] != NULL)
      $tag .= ' <set_function>' . $this->data['set_function'] . '</set_function>' . "\n";
//     $tag .= ' <lang>' . $this->data['lang'] . '</lang>' . "\n";
    $tag .= '</' . $this->tag_name . '>';
    return $tag;
  }

/**-----------------------------permissions--------------------------- */

  public function permissions_check_for_install() {return true; }
  public function permissions_check_for_remove() {  return true; }



/**-----------------------------conflicts--------------------------- */

  public function conflicts_check_for_install() {
    $query = "select configuration_group_id as gid from " . TABLE_CONFIGURATION_GROUP . " where configuration_group_key='" . $this->data['group_key'] . "'";
    $rs = tep_db_query($query);

    if (!($row = tep_db_fetch_array($rs)))  CIP::InProcess(__('Configuration group does not exists with key:').$this->data['group_key'], __CLASS__.'->'.__FUNCTION__,'block');
    else self::$gid=$this->data['gid'] = $row['gid'];
  }

  public function conflicts_check_for_remove() { return true; }


/**-----------------------------EXE--------------------------- */

  function do_install() {
    $DB=Database::getInstance();
    $rs = $DB->query("select configuration_id from " . TABLE_CONFIGURATION . " where configuration_key='" . $this->data['key'] . "'");

    if (!$rs->__get('numRows')) {
      $query = "insert into " . TABLE_CONFIGURATION .
		"(configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) " .
		" values ('','" . $this->data['title'] . "','" . $this->data['key'] . "','" . $this->data['value'] . "','" . $this->data['descr'] . "'," . self::$gid . "," . ($this->data['sort_order'] == NULL ? "NULL" : $this->data['sort_order']) . ",now(),now()," . ($this->data['use_function'] == NULL ? "NULL" : "'".$this->data['use_function']."'") . "," . ($this->data['set_function'] == NULL ? "NULL" : "'".$this->data['set_function']."'") . ")";
      if(!$DB->query($query)){
	CIP::InProcess(__('erreur insert into ').TABLE_CONFIGURATION.' '.$this->data['key'].__('requete').'<br />'.$query, __CLASS__.'->'.__FUNCTION__,'block');;
	return false;
      }
    }
    else CIP::InProcess(__('configuration key deja existante ::').$this->data['key'], __CLASS__.'->'.__FUNCTION__,'noblock');

    return true;
  }


  function do_remove() {
    $DB=Database::getInstance();
    $rs = $DB->query("select configuration_id from " . TABLE_CONFIGURATION . " where configuration_key='" . $this->data['key'] . "'");

    if (!$rs->__get('numRows')) {
      CIP::InProcess(__('non installé:').$this->data['key'], __CLASS__.'->'.__FUNCTION__,'noblock');
    }
    else
      $DB->query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = '" . $this->data['key'] . "'");

    return true;
  }

}

?>