<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  26/07/10, 11:30
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @portion code by Imrich Schindler <ischindl at progis.sk>


<depend>
    <cip [version="1.0"] [level="stable"] >ADMIN_BOXES</cip>
    <active>
      ....
    </active>
    <inactive>
      ...
    </inactive>
</depend>

*/


class Tc_depend
  extends ContribInstallerBaseTag
    implements PackageTags{


    var $tag_name='depend';
    var $count_php_tags = 0;
    var $contrib_data = array();

    // Class Constructor
    function Tc_depend($contrib='', $id='', $xml_data='', $dep='') {
        $this->params=array(
            'cip_ident'=>array(
                                'sql_type'=>'varchar (255)',
                                'xml_error'=>"no CIP ident"
                                ),
            'cip_version'=>array(
                                'sql_type'=>'varchar (255)',
                                ),
            'cip_level'=>array(
                                'sql_type'=>'varchar (255)',
                                ),
        );
        $this->ContribInstallerBaseTag($contrib, $id, $xml_data, $dep);
    }
//  Class Methods

    function get_data_from_xml_parser($xml_data='') {
        $this->data['cip_ident']   =$this->getTagText($xml_data,'cip',0);
        $this->data['cip_version'] =$this->getTagAttr($xml_data,'cip',0,'version');
        $this->data['cip_level'] =$this->getTagAttr($xml_data,'cip',0,'level');

        $active = false;
//         if($this->data['cip_ident'] == 'CORE'){
// 	  if($this->isJoscom()) $active = true;
//         }else{
	  $query = 'select * from '.TABLE_CIP. ' where cip_ident="'.$this->data['cip_ident'].($this->data['cip_level']!=NULL? '_'.$this->data['cip_level']: '' ) .'" '.($this->data['cip_version']==NULL?'':' and cip_version="'.$this->data['cip_version'].'"').' and cip_installed=1';
	  $result = cip_db_query($query,'return');
	  $active =(tep_db_num_rows($result)>0);
// 	}
        if($active){
	  //if cip installed
	  $obj = $xml_data->getElementsByTagName('active');
	  if(is_object($obj))$mtag = $obj->item(0);
        }else{
	  $obj = $xml_data->getElementsByTagName('inactive');
	  if(is_object($obj))$mtag = $obj->item(0);
        }
        if(is_object($mtag)) $this->getSubTags($mtag);
    }


    function write_to_xml() {
        $tag = '
        <'.$this->tag_name.'>
            <cip' . ($this->data['cip_version'] == NULL ? '' : ' version="' . $this->data['cip_version'] . '"') . '>'.$this->data['cip_ident'].'</cip>
            <active>'. $this->data['active']. '</active>
            <inactive>'. $this->data['inactive']. '</inactive>
        </'.$this->tag_name.'>';
       return $tag;
    }




  function permissions_check_for_install() {


    foreach ($this->contrib_data as $tag)
      if ( $tag->permissions_check_for_remove() ===false){
	CIP::InProcess(__("Erreur durant traitement de cette fonction   "),'tag_xml-['.$id.']'. $tag->tag_name.'->permissions_check_for_remove()','block');
	break;
      }
    return true;
  }

  function permissions_check_for_remove() {
    foreach ($this->contrib_data as $tag)
      if ( $tag->permissions_check_for_remove() ===false){
	CIP::InProcess(__("Erreur durant traitement de cette fonction   "),'tag_xml-['.$id.']'. $tag->tag_name.'->permissions_check_for_remove()','block');
	break;
      }
    return true;
  }

  function conflicts_check_for_install() {
    //! control db nettoayge
    $query = "delete  from " . TABLE_CIP_DEPEND . " where cip_ident='" . $this->cip->getIdent() . "' and cip_ident_req='" . $this->data['cip_ident'].($this->data['cip_level']!=NULL? '_'.$this->data['cip_level']: '' ) . "' ";
    tep_db_query($query);


    foreach ($this->contrib_data as $id=>$tag)
      if ( $tag->conflicts_check_for_install() ===false){
	CIP::InProcess(__("Erreur durant traitement de cette fonction   "),'tag_xml-['.$id.']'. $tag->tag_name.'->conflicts_check_for_install()','block');
	break;
      }
    return true;
  }

  function conflicts_check_for_remove() {

    foreach ($this->contrib_data as $tag)
      if ( $tag->conflicts_check_for_install() ===false){
	CIP::InProcess(__("Erreur durant traitement de cette fonction   "),'tag_xml-['.$id.']'. $tag->tag_name.'->conflicts_check_for_install()','block');
	break;
      }

    return true;
  }


  //===============================================================
  function do_install() {

    //!Mise a niveau table des dependance
    $query = 'insert into ' . TABLE_CIP_DEPEND . '(cip_ident, cip_ident_req, cip_req_type) values("' . $this->cip->getIdent() . '","' . $this->data['cip_ident'].($this->data['cip_level']!=NULL? '_'.$this->data['cip_level']: '' ) . '",2)';
    tep_db_query($query);

    //! boucle install sous tag dependance
    foreach ($this->contrib_data as $tag)
      if ( $tag->do_install() ===false){
	CIP::InProcess(__("Erreur durant traitement de cette fonction   "),'tag_xml-['.$id.']'. $tag->tag_name.'->do_install()','block');
	break;
      }
    return true;
  }

  function do_remove() {

    //!Mise a niveau table des dependance
    $query = 'delete from ' . TABLE_CIP_DEPEND . ' where cip_ident = "' . $this->cip->getIdent() . '" and cip_ident_req= "' . $this->data['cip_ident'].($this->data['cip_level']!=NULL? '_'.$this->data['cip_level']: '' ) . '" and cip_req_type=2';
    tep_db_query($query);

    //! boucle install sous tag dependance
    foreach ($this->contrib_data as $tag)
      if ( $tag->do_remove() ===false){
	CIP::InProcess(__("Erreur durant traitement de cette fonction   "),'tag_xml-['.$id.']'. $tag->tag_name.'->do_remove()','block');
	break;
      }

    return true;
  }

  function getSubTags($mtag){
    $tagcnt = array();
    foreach ($mtag->childNodes as $id=>$tag_data) {
	if(sizeof($tag_data)==0) continue;
	// ignore xml comments
	if ($tag_data->nodeName=='#comment') continue;

	if(array_key_exists($tag_data->nodeName,$tagcnt)){
	  $tagcnt[$tag_data->nodeName]++;
	}else{
	  $tagcnt[$tag_data->nodeName] = 0;
	}

	if (strtolower($tag_data->nodeName)=='php')$this->count_php_tags++;

	$clsname='Tc_'.strtolower($tag_data->nodeName);

	if (class_exists($clsname)) $this->contrib_data[] = new $clsname($this->cip, $tagcnt[$tag_data->nodeName], $tag_data," in depend #".$this->id. $this->depend);
	else {
	  CIP::InProcess('Tag'.$tag_data->nodeName.' is not supported. Class '.$clsname.' does NOT exist.',__CLASS__.'->'.__FUNCTION__.'('.__LINE__.')','block');
// 	    $this->error('Tag'.$tag_data->nodeName.' is not supported. Class '.$clsname.' does NOT exist.');
	  return false;
	}
    }
  }
}

?>