<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @original author Vlad Savitsky
  @Support: http://forums.oscommerce.com/index.php?showuser=20490,  http://forums.oscommerce.com/index.php?showtopic=156667
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  24/07/10, 18:07
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class Tc_description

  NOTE:
    Class Description operates with description-tag from install.xml.


  <description>
        <details contrib_ref="" forum_ref="" contrib_type="" status="" last_update=""/>
        <comments><![CDATA[ ... ]]></comments>
        <credits><![CDATA[ ... ]]></credits>
        <ident>ADMIN_BOXES</ident> - identifier of CIP for require and depend tags
        <version>1.0</version> - identifier of CIP version for require and depend tags
    <post_install_notes>God bless you!</post_install_notes> - message that will be shown after install
  </description>
*/




class Tc_description
  extends ContribInstallerBaseTag
  implements PackageTags{


  function __construct($contrib='', $id='', $xml_data='', $dep='') {
    $this->tag_name='description';
    $this->params=array(
        'contrib_ref'=>array(
                            'sql_type'=>'smallint unsigned',
                            'xml_error'=>__('no contrib ref parameter in details tag text')
                            ),
        'forum_ref'=>array(
                            'sql_type'=>'smallint unsigned',
                            'xml_error'=>__('no forum ref parameter in details tag text')
                            ),
        'oscss_forum_ref'=>array(
                            'sql_type'=>'smallint unsigned',
                            'xml_error'=>__('no oscss forum ref parameter in details tag text')
                            ),
        'contrib_type'=>array(
                            'sql_type'=>'varchar(100)',
                            'xml_error'=>__('no contrib type parameter in details tag text')
                            ),
        'status'=>array(
                            'sql_type'=>'tinyint unsigned',
                            'xml_error'=>''//NO_STATUS_PARAMETER_IN_DETAILS_TAG_TEXT')
                            ),
        'last_update'=>array(
                            'sql_type'=>'varchar(30)',
                            'xml_error'=>__('no last update parameter in details tag text')
                            ),
        'comments'=>array(
                            'sql_type'=>'text',
                            'xml_error'=>__('no comments tag in description section text')
                            ),
        'credits'=>array(
                            'sql_type'=>'text',
                            'xml_error'=>__('no credits tag in description section text')
                            ),
        'author_pkg'=>array(
                          'sql_type'=>'text',
                          'xml_error'=>__('no author pkg tag in description section text')
                        ),
        'ident'=>array(
                            'sql_type'=>'varchar(255)',
                            ),
        'version'=>array(
                            'sql_type'=>'varchar(20)',
                            ),
        'post_install_notes'=>array(
                            'sql_type'=>'text',
                            ),

    );
    $this->ContribInstallerBaseTag($contrib, $id, $xml_data, $dep='');
  }
//Class Methods
//=============================================================
  public function get_data_from_xml_parser($xml_data='') {
    $this->data['contrib_ref']    =$this->getTagAttr($xml_data,'details',0,'contrib_ref');
    $this->data['forum_ref']      =$this->getTagAttr($xml_data,'details',0,'forum_ref');
    $this->data['oscss_forum_ref']=$this->getTagAttr($xml_data,'details',0,'oscss_forum_ref');
    $this->data['contrib_type']   =$this->getTagAttr($xml_data,'details',0,'contrib_type');
    $this->data['status']         =$this->getTagAttr($xml_data,'details',0,'status');
    $this->data['last_update']    =$this->getTagAttr($xml_data,'details',0,'last_update');
    $this->data['author_pkg']        =$this->getTagText($xml_data,'author_pkg',0);
    $this->data['comments']       =$this->getTagText($xml_data,'comments',0);
    $this->data['credits']        =$this->getTagText($xml_data,'credits',0);
    $this->data['ident']          =$this->getTagText($xml_data,'ident',0);
    $this->data['version']        =$this->getTagText($xml_data,'version',0);
    $this->data['post_install_notes']=$this->getTagText($xml_data,'post_install_notes',0);

    if($this->data['ident']==NULL)$this->data['ident'] = $this->contrib;
    if($this->data['version']==NULL)$this->data['version'] = '1.0';
  }


//   public  function write_to_xml() {
//     return '
//     <'.$this->tag_name.'>
//         <details contrib_ref="'.$this->data['contrib_ref'].'" forum_ref="'.$this->data['forum_ref'].'"
//           contrib_type="'.$this->data['contrib_type'].'" status="'.$this->data['status'].'" last_update="'.$this->data['last_update'].'"/>
//         <comments><![CDATA['.$this->data['comments'].']]></comments>
//         <credits><![CDATA['.$this->data['credits'].']]></credits>
//             <ident>'.$this->data['ident'].'</ident>
//             <version>'.$this->data['version'].'</version>
//         <post_install_notes>'.$this->data['post_install'].'</post_install_notes>
//     </'.$this->tag_name.'>';
//   }

/**-----------------------------permissions--------------------------- */

  public function permissions_check_for_install() {  /*return true; */}
  public function permissions_check_for_remove() {/* return true; */}




/**-----------------------------conflicts--------------------------- */

  public function conflicts_check_for_install() { /*return true; */ }

  public function conflicts_check_for_remove() {
    /**
      Control des dependance de ce paquet avant suppression
    */
//     $query = 'select * from '.TABLE_CIP_DEPEND.' where cip_ident_req="'.$this->data['ident'].'" and cip_req_type=1';
//     $rs = tep_db_query($query);
//     $cips = '';
//     while($cp = tep_db_fetch_array($rs)) $cips =($cips=='')? $cp['cip_ident'] :  ','.$cp['cip_ident'];
//     if($cips !=''){
//       CIP::$ArrayError[]=__("Some another CIP's requires this CIP and it can't be removed!")." (".$cips.")";
//       trigger_error(__CLASS__.sprintf(' error %s', __FUNCTION__).__('Unrecoverable error "').$zipfile->errorName(true).$le_file , E_USER_ERROR);
//       return false;
//     }
//     return true;
  }


/**-----------------------------EXE--------------------------- */
  public function do_install(){ /*return true;*/ }
  public function do_remove(){ /*return true;*/ }
}

?>