<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  23/06/10, 12:02
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8

  exemple:
  <extractzip>
    <zip name="productQuantity.zip" />
    <path name="templates/%TEMPLATE_NAME%/includes/plugins/" />
  </extractzip>
*/

class Tc_extractzip
  extends ContribInstallerBaseTag {
    var $tag_name='extractzip';

    function __construct($contrib='', $id='', $xml_data='', $dep='') {
        $this->params=array(
            'zip'=>array(
                  'sql_type'=>'varchar (255)',
                  'xml_error'=>"no file name; "
                  ),
            'path'        =>array(
                'sql_type'=>'varchar (255)',
                'xml_error'=>"no path section; "
                ),
        );
        $this->ContribInstallerBaseTag($contrib, $id, $xml_data, $dep);
    }


  function get_data_from_xml_parser($xml_data='') {
    $this->data['zip']   =$this->getTagAttr($xml_data,'zip',0,'name');
    $this->data['path']  =replace_path_admin(trim(str_replace("%TEMPLATE_NAME%",TEMPLATE_NAME,$this->getTagAttr($xml_data,'path',0,'name')))) ;
  }


  function write_to_xml() {
      return '
      <'.$this->tag_name.'>
	  <zip name="'.$this->data['zip'].'" />
	  <path name="'.$this->data['path'].'" />
      </'.$this->tag_name.'>';
  }




  public function permissions_check_for_install() { return true; }
  public function permissions_check_for_remove() {  return true; }

  public function conflicts_check_for_install() { return true; }
  public function conflicts_check_for_remove() { return true; }


  public function do_install() {
    if(!$this->unpack_plus($this->data['zip'],$this->data['path'])) return false;
    else{
      // deplacement admin
      $folder_admin=substr(DIR_WS_ADMIN, strlen(DIR_WS_CATALOG) );
      if(file_exists(DIR_FS_CATALOG.'admin') && $folder_admin !='admin/' ){
	parent::recurse_copy(DIR_FS_CATALOG.'admin',DIR_FS_ADMIN);
	parent::recursive_rmdir(DIR_FS_CATALOG.'admin/');
      }
      return true;
    }
  }

  public function do_remove() {
//         $this->recursive_rmdir();
      return true;
  }


/** =============================================================== PRIVATE  =============================================================== */
  private function unpack_plus($file,$dir) {
    $le_file=DIR_FS_CIP.'/'.$this->contrib.'/'.$file;
    $zipfile = new PclZip( $le_file );
    if($this->cip->is_Windows())   if(!defined('OS_WINDOWS'))define('OS_WINDOWS',1);
    else  if(!defined('OS_WINDOWS'))define('OS_WINDOWS',0);

    $ret = $zipfile->extract( PCLZIP_OPT_PATH, DIR_FS_CATALOG.$dir );
    if($ret == 0) {
      CIP::$error=true;
      trigger_error(__CLASS__.sprintf(' error %s', __FUNCTION__).__('Unrecoverable error "').$zipfile->errorName(true).$le_file , E_USER_ERROR);
      return false;
    }
    return true;
  }


//   function permissions_check_for_install($name='') {
//     if (!file_exists(DIR_FS_CATALOG.$this->data['path'])){
//       CIP::$error= true;
//       trigger_error(__CLASS__.sprintf('error %s', __FUNCTION__).__('Unrecoverable error "').$this->data['path'] , E_USER_ERROR);
//     }
//     elseif(!is_writable(DIR_FS_CATALOG.$this->data['path'])){
//       CIP::$error= true;
//       trigger_error(__CLASS__.sprintf('error %s', __FUNCTION__).__('impossible d\'ecrire dans : ').$this->data['path']  , E_USER_ERROR);
//     }
//
//     return CIP::$error;
//   }

//   function permissions_check_for_remove() {
//     return $this->permissions_check_for_install();
//   }

//     function conflicts_check_for_remove() {
//       $find=$this->add_str();
//       $new_file=$this->linebreak_fixing(file_get_contents($this->fs_filename()));
//       $this->write_to_file($this->fs_filename(), $new_file);
//       $count=substr_count($new_file, $find);
//         //We can also check a database records for conflicts.
//             if ($count==0) {
//           CIP::$error(COULDNT_FIND_TEXT.": ".nl2br(htmlspecialchars($find)). "<br>". IN_THE_FILE_TEXT. $this->fs_filename());
//             }
//             return CIP::$error;
//     }
}

?>