<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @portion-original code  Imrich Schindler <ischindl at progis.sk>
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  26/07/10, 13:34
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8


<requirements>
  <require [version="2.0.9q"] [level="stable|unstable"]>CORE</require>
  [<require [version="1.2"] [level="stable"]>CIP_IDENT</require>]

  [<conflit [version="1.2"] [level="stable"]>CIP_IDENT</conflit>]
</requirements>
*/


class Tc_requirements
  extends ContribInstallerBaseTag
    implements PackageTags{


  var $tag_name='requirements';
  var $req = array();
  var $ver = array ();


  // Class Constructor
  function __construct($contrib='', $id='', $xml_data='', $dep='') {
      $this->params=array();


      $this->ContribInstallerBaseTag($contrib, $id, $xml_data, $dep);
  }

//  Class Methods

  function get_data_from_xml_parser($xml_data='') {
    $t=array( 'r'=>'require',
	      'c'=>'conflit');

    foreach($t as $key=>$value) {
      $requis=array();
      $tags = $xml_data->getElementsByTagName($value);
      for($i=0 ;$i < $tags->length; $i++){
	$res=array();
	$res['name']= $this->getITagText($tags,$i);
	$res['version'] = $this->getITagAttr($tags, $i, 'version');
	$res['level'] = $this->getITagAttr($tags, $i, 'level');

	$requis[]=$res;
      }
      $this->data[$value]=$requis;
    }

  }

  function write_to_xml() {
    $tag = '<'.$this->tag_name.'>';
    for ($i = 0; $i < count($this->req['r']); $i++)
      $tag .= '<require' . ($this->ver['r'][$i] == NULL ? '' : ' version="' . $this->ver['r'][$i] . '"') . '>' . $this->req['r'][$i] . '</require>';

    $tag .= '</'.$this->tag_name.'>';
    return $tag;
  }


/**-----------------------------permissions--------------------------- */

  function permissions_check_for_install() {

    //! require
    foreach ($this->data['require'] as $id => $contraint) {
      $contraint=new objectInfo($contraint);
      //! control version noyau
      if (strtoupper($contraint->name ) ==='CORE') {
	if( ($contraint->version !=NULL) && !version_compare($contraint->version, get_info_core(DIR_FS_CATALOG. DIR_WS_COMMON.'oscss.version.xml','version'),'>=')  ){
	  CIP::InProcess(__("REQUIRE osCSS equal or superior ::").(int)$contraint->version ,'tag_xml-['.$id.']'. $this->tag_name.'->permissions_check_for_install()','block');
	  return false;
	}
// 	continue;
      }
      else{

	/**
	  TODO: Integrer control avec si installé / si present
	  @date  26/07/10, 14:23
	  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
	*/
	$query = "select * from " . TABLE_CIP . " where cip_ident" . self::extension_name($contraint, true) . ' '.($contraint->version != NULL?' and cip_version="' . $contraint->version  . '"':''). ' and cip_installed=1';
	$result = CIP::$DB->query($query);

	if($result->__get('numRows')==0){
	  CIP::InProcess(__("REQUIRE ::").$contraint->name.($contraint->level!=NULL? '_'.$contraint->level: '' ) ,'tag_xml-['.$id.']'. $this->tag_name.'->permissions_check_for_install()','block');
	  return false;
	}
      }
    }

    /**
      TODO: Integrer control avec si installé / si present
      @date  26/07/10, 14:23
      @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
    */
    //! conflit
    foreach ($this->data['conflit'] as $id => $contraint) {
      $contraint=new objectInfo($contraint);
      $query = 'select * from ' . TABLE_CIP . ' where cip_ident="' . self::extension_name($contraint, true)   . '"'.($contraint->version != NULL?' and cip_version="' . $contraint->version . '"':''). ' and cip_installed=1';
      $result = CIP::$DB->query($query);

      if($result->__get('numRows')==0){
	//required CIP not installed
	CIP::InProcess(' --- info:: <br /> '.self::extension_name($contraint).__(' is installed and is conflit with ').$this->cip->getIdent(),$this->tag_name.'->permissions_check_for_install()','block');
	return false;
      }
    }



    return true;
  }

  public function permissions_check_for_remove(){ return true; }

/**-----------------------------conflicts--------------------------- */

  public function conflicts_check_for_install(){ return true; }

  public function conflicts_check_for_remove(){ return true; }



/**-----------------------------EXE--------------------------- */

  /**
   Insert all info about requirements of this CIP
  */
  public function do_install() {
    foreach ($this->data['require'] as $id => $contraint) {
      $contraint=new objectInfo($contraint);
      $query = 'insert into ' . TABLE_CIP_DEPEND . '(cip_ident, cip_ident_req, cip_req_type) values("' . $this->cip->getIdent() . '","' . self::extension_name($contraint)  . '",1)';
      CIP::$DB->query($query);
    }
  }

  /**
    Remove all info about requirements of this CIP
  */
  public function do_remove() {
    foreach ($this->data['conflit'] as $id => $contraint) {
      $contraint=new objectInfo($contraint);
      $query = 'delete from ' . TABLE_CIP_DEPEND . ' where cip_ident = "' . $this->cip->getIdent() . '" and cip_ident_req= "' .  self::extension_name($contraint)  . '" and cip_req_type=1';
      CIP::$DB->query($query);
    }
  }


  /**
    @return name or name_level | =name_level or LIKE name_%
  */
  private static function extension_name($obj,$sql=false){
    if(!$sql) return ($obj->level!=NULL?  $obj->name.'_'.$obj->level: $obj->name);
    else return ($obj->level!=NULL?  " ='".$obj->name.'_'.$obj->level."'": " LIKE '".$obj->name."_%' " );
  }

}


?>