<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  17/10/10, 17:52
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

/**
  Include classes automatically when they are instantiated.
  @package oscss-2 <www http://www.oscss.org>
  @original-code TYPOlight Open Source CMS Copyright (C) 2005-2010 Leo Feyer
  @param string
  @param string $type type module
*/
function __autoload($strClassName) {
  // standard
  if (file_exists(DIR_FS_ADMIN.DIR_WS_CLASSES . $strClassName . '.php')) {
    include_once(DIR_FS_ADMIN.DIR_WS_CLASSES . $strClassName . '.php');
    return;
  }
  if (file_exists(DIR_FS_ADMIN.DIR_WS_CLASSES . 'osCSS_'.$strClassName . '.php')) {
    include_once(DIR_FS_ADMIN.DIR_WS_CLASSES . 'osCSS_'.$strClassName . '.php');
    return;
  }
  // Common
  if (file_exists(DIR_FS_CATALOG.DIR_WS_COMMON_CLASSES . $strClassName . '.php')) {
    include_once(DIR_FS_CATALOG.DIR_WS_COMMON_CLASSES . $strClassName . '.php');
    return;
  }
  if (file_exists(DIR_FS_CATALOG.DIR_WS_COMMON_CLASSES . 'osCSS_'.$strClassName . '.php')) {
    include_once(DIR_FS_CATALOG.DIR_WS_COMMON_CLASSES . 'osCSS_'.$strClassName . '.php');
    return;
  }
  // Exts in folder
  if (file_exists(DIR_FS_ADMIN.DIR_WS_MODULES . $strClassName . '/' . $strClassName . '.php')) {
    include_once(DIR_FS_ADMIN.DIR_WS_MODULES . $strClassName . '/' . $strClassName . '.php');
    return;
  }
  /** Nom class et path imbrique mondossier_maclass = mondossier/maclass.php
      Uniquement dans admin/includes
  */
  $strClassName=str_replace('_','/',$strClassName);
  if (file_exists(DIR_FS_ADMIN. DIR_WS_INCLUDES. dirname($strClassName) . '/' . basename($strClassName) . '.php')) {
    include_once(DIR_FS_ADMIN. DIR_WS_INCLUDES. dirname($strClassName) . '/' . basename($strClassName) . '.php');
    return basename($strClassName);
  }

//   trigger_error(sprintf('Could not load class %s', $strClassName), E_USER_ERROR);
  return false;
}


/**
  @author oscim - OscssTeam
  @version 1.0
    Verifie si user loggé, sinon renvoi sur login
    Verifie l'acl sur la page en cours, sinon renvoi vers forbiden
*/
function tep_admin_check_login() {
  global  $navigation, $current_page;
  if (!tep_session_is_registered('login_id')) {
    $navigation->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  } else {
    $filename = trim($current_page);
    $authorise=array(FILENAME_DEFAULT,FILENAME_FORBIDEN,FILENAME_LOGOFF,FILENAME_ADMIN_ACCOUNT);
    if (!in_array($filename,$authorise) && !in_array(substr($filename,0,strpos($filename,'?') ),array('attributeManager.php'))){
      $db_file_query = tep_db_query("select admin_files_name from " . TABLE_ADMIN_FILES . " where FIND_IN_SET( '" . $_SESSION['login_groups_id'] . "', admin_groups_id) and admin_files_name = '" . $filename . "'");
      if (!tep_db_num_rows($db_file_query)) {
        tep_redirect(tep_href_link(FILENAME_FORBIDEN,'', 'NONSSL'));
      }
    }
  }
}

/**
  @author OscssTeam
  @version 1.0
  @return 'true' or 'false' value to display boxes and files in index.php
*/
function tep_admin_check_boxes($filename, $boxes='') {
  global $login_groups_id;
  if($login_groups_id==1)return true;
  $dbquery = tep_db_query("select admin_files_id from " . TABLE_ADMIN_FILES . " where FIND_IN_SET( '" . $login_groups_id . "', admin_groups_id) and admin_files_is_boxes = '1' and admin_files_name = '" . $filename . "'");

  $return_value = false;
  if (tep_db_num_rows($dbquery)) {
    $return_value = true;
  }
  return $return_value;
}


/**
 * \fn tep_redirect($url)
 * \brief Redirect to another page or site
 * @param $url string path
 */
function tep_redirect($url) {

  if ( (strstr($url, "\n") != false) || (strstr($url, "\r") != false) ) tep_redirect(tep_href_link(FILENAME_DEFAULT, '', 'NONSSL', false));

  if ( (ENABLE_SSL == true) && (getenv('HTTPS') == 'on') ) { // We are loading an SSL page
    if (substr($url, 0, strlen(HTTP_SERVER)) == HTTP_SERVER) { // NONSSL url
      $url = HTTPS_SERVER . substr($url, strlen(HTTP_SERVER)); // Change it to SSL
    }
  }

  header('Location: ' . $url);

  if(OSCSS_GARBAGE_ERROR==true) osC_ErrorHandler::stop();
  exit;
}

/**
  @fn tep_get_http()
  @brief retrun url server
*/
function tep_get_http(){
  return  ( (ENABLE_SSL == true) && (getenv('HTTPS') == 'on') ) ? HTTPS_SERVER : HTTP_SERVER;
}

/**
  @fn tep_get_httpdir()
  @brief return http and base dir server
*/
function tep_get_httpdir(){
  return  ( (ENABLE_SSL == true) && (getenv('HTTPS') == 'on') ) ? HTTPS_SERVER.DIR_WS_HTTPS_CATALOG : HTTP_SERVER.DIR_WS_HTTP_CATALOG;
}


/**
 * \fn tep_parse_input_field_data($data, $parse)
 * \brief Parse the data used in the html tags to ensure the tags will not break
 * @param $data
 * @param $parse
 */
function tep_parse_input_field_data($data, $parse) {
  return strtr(trim($data), $parse);
}

/**
  @author OscssTeam
*/
function tep_output_string($string, $translate = false, $protected = false) {
  if ($protected == true) return htmlspecialchars($string);
  else {
    if ($translate == false) return tep_parse_input_field_data($string, array('"' => '&quot;'));
    else return tep_parse_input_field_data($string, $translate);
  }
}

/**
  @author OscssTeam
*/
function tep_output_string_protected($string) {
  return tep_output_string($string, false, true);
}

/**
  @author OscssTeam
    Correction retour get ou post (secure)
*/
function tep_sanitize_string($string) {
  $string = preg_replace('/ +/', ' ', $string);
  return preg_replace("/[<>]/", '_', $string);
}

/**
  Convetion de langue Generation 2
  @package oscss-2
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  @param
    @a string la chaine
    @a string class d'appel
    @a boolena (print_r())
*/
function __($str,$ext='',$mode=false) {
  global $lang;
  if(!empty($ext)) $lang[$ext][$str]=$str;
  if($mode)print_r($lang);
  return isset($lang[$str]) ? $lang[$str] : $str;
}

/**
  @author oscim - OscssTeam
  @version 1.6
  Suppression systhematqiue de la var page_admin specifique au rewriting
*/
function tep_get_all_get_params($exclude_array = '',$w3c=true) {
  global $_GET;
  if ($exclude_array == '') $exclude_array = array('page_admin',tep_session_name(),'error');
  else {$exclude_array[]='page_admin';$exclude_array[]=tep_session_name();$exclude_array[]='error'; }
  $get_url = '';
  reset($_GET);
  while (list($key, $value) = each($_GET))
      if (!in_array($key, $exclude_array)) $get_url .= $key . '=' . tep_sanitize_string($value) . (($w3c)?'&amp;':'&');

  return $get_url;
}

/**
  @author oscim - OscssTeam
  @version 1.6
  Suppression systhematqiue de la var page_admin specifique au rewriting
*/
function tep_get_all_post_params($exclude_array = '') {
  global $_GET;
  if ($exclude_array == '') $exclude_array = array('page_admin',tep_session_name(),'error');
  else {$exclude_array[]='page_admin';$exclude_array[]=tep_session_name();$exclude_array[]='error'; }
  $add_post='';
  reset($_GET);
  while (list($key, $value) = each($_GET))
    if (!in_array($key, $exclude_array)) $add_post .= tep_draw_hidden_field($key, '', htmlspecialchars(stripslashes(tep_sanitize_string($value))));

  return $add_post;
}

/**
  @package oscss
  @author  OscssTeam
*/
function tep_date_long($raw_date) {
  if ( ($raw_date == '1000-01-01 00:00:00') || ($raw_date == '') ) return false;

  $year = (int)substr($raw_date, 0, 4);
  $month = (int)substr($raw_date, 5, 2);
  $day = (int)substr($raw_date, 8, 2);
  $hour = (int)substr($raw_date, 11, 2);
  $minute = (int)substr($raw_date, 14, 2);
  $second = (int)substr($raw_date, 17, 2);

  return tep_strftime(DATE_FORMAT_LONG, mktime($hour, $minute, $second, $month, $day, $year));
}

/**
  @author OscssTeam
Output a raw date string in the selected locale date format
 $raw_date needs to be in this format: YYYY-MM-DD HH:MM:SS
 NOTE: Includes a workaround for dates before 01/01/1970 that fail on windows servers
*/
function tep_date_short($raw_date) {
  if ( ($raw_date == '1000-01-01 00:00:00') || ($raw_date == '') ) return false;

  $year = substr($raw_date, 0, 4);
  $month = (int)substr($raw_date, 5, 2);
  $day = (int)substr($raw_date, 8, 2);
  $hour = (int)substr($raw_date, 11, 2);
  $minute = (int)substr($raw_date, 14, 2);
  $second = (int)substr($raw_date, 17, 2);

  if (@date('Y', mktime($hour, $minute, $second, $month, $day, $year)) == $year)  return date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, $year));
  else return str_replace('2037', $year, date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, 2037)));
}

function tep_datetime_short($raw_datetime) {
  if ( ($raw_datetime == '1000-01-01 00:00:00') || ($raw_datetime == '') ) return false;

  $year = (int)substr($raw_datetime, 0, 4);
  $month = (int)substr($raw_datetime, 5, 2);
  $day = (int)substr($raw_datetime, 8, 2);
  $hour = (int)substr($raw_datetime, 11, 2);
  $minute = (int)substr($raw_datetime, 14, 2);
  $second = (int)substr($raw_datetime, 17, 2);

  return tep_strftime(DATE_TIME_FORMAT, mktime($hour, $minute, $second, $month, $day, $year));
}


/**
  @package oscss
  @author OscssTeam
  @version 2
  Réecriture des dates dans des formats correctes pour la langue
*/
function tep_strftime($format, $timestamp=false) {
  if (!$timestamp) $timestamp = time();
  $pattern = array(
                '%a'=>array('const'=>'NameOf_DAY_MINI','ftime'=>'%w'),
                '%A'=>array('const'=>'NameOf_DAY','ftime'=>'%w'),
                '%b'=>array('const'=>'NameOf_MONTH_MINI','ftime'=>'%m'),
                '%B'=>array('const'=>'NameOf_MONTH','ftime'=>'%m')
                );
  foreach ($pattern as $code=>$infos)
        if (preg_match("/$code/",$format) && defined($infos['const'].'_'.strftime($infos['ftime'], $timestamp)))
        $format = preg_replace("/$code/", constant($infos['const'].'_'.strftime($infos['ftime'], $timestamp)), $format);
  return strFtime($format, $timestamp);
}


/**
  @package oscss
  @author  OscssTeam
*/
function tep_break_string($string, $len, $break_char = '-') {
  $l = 0;
  $output = '';
  for ($i=0, $n=strlen($string); $i<$n; $i++) {
    $char = substr($string, $i, 1);
    if ($char != ' ')  $l++;
    else  $l = 0;
    if ($l > $len) {
      $l = 1;
      $output .= $break_char;
    }
    $output .= $char;
  }
  return $output;
}

/**
  @package oscss
  @author  OscssTeam
*/
function tep_not_null($value) {
  if (is_array($value)) {
    if (sizeof($value) > 0)  return true;
    else  return false;
  } else {
    if ( (is_string($value) || is_int($value)) && ($value != '') && ($value != 'NULL') && (strlen(trim($value)) > 0))  return true;
    else  return false;
  }
}

/**
  @package oscss
  @author  OscssTeam
*/
function tep_browser_detect($component) {
  return stristr($_SERVER['HTTP_USER_AGENT'], $component);
}



/**
Wrapper function for round()
  @package oscss
  @author  OscssTeam
*/
function tep_round($value, $precision) {
  return round($value, $precision);
}

/**
  custom class exists
  load class :: path_class_and_class_name >> include(path/class/and/class/name) et class_exists(name)
  @param string path et class name
  @return bool
*/
function tep_class_exists($namespace_class){
  return ( (($class=__autoload($namespace_class)) && $class !=false) && class_exists($class) )? true : false;
}

/**
  @package oscss
  @author oscim - OscssTeam
  @version 2.0
  @note Appel de function. ou de class
*/
function tep_call_function($function, $parameter, $object = '') {
  if (is_string($object) && $object == '') return call_user_func($function, $parameter);
  else return call_user_func(array($object, $function), $parameter);
}


/**
  Sets timeout for the current script.Cant be used in safe mode.
    @package oscss
    @author  OscssTeam
*/
function tep_set_time_limit($limit) {
  if (!get_cfg_var('safe_mode')) set_time_limit($limit);
}

/**
  @package oscss
  @author oscim - OscssTeam
*/
function tep_rand($min = null, $max = null) {
  static $seeded;

  if (!$seeded) {
    mt_srand((double)microtime()*1000000);
    $seeded = true;
  }

  if (isset($min) && isset($max)) {
    if ($min >= $max) return $min;
    else return mt_rand($min, $max);
  } else {
    return mt_rand();
  }
}


/**
  @package oscss-Rv
  @author oscim - OscssTeam
  @version 1.2
*/
function tep_convert_linefeeds($from, $to, $string) {
  return str_replace($from, $to, $string);
}


/**
  @package oscss
  @author oscim - OscssTeam
*/
function tep_string_to_int($string) {
  return (int)$string;
}


/**
  @package  oscss
  @author OscssTeam
*/
function tep_array_to_string($array, $exclude = '', $equals = '=', $separator = '&') {
  if (!is_array($exclude)) $exclude = array();
  $get_string = '';
  if (sizeof($array) > 0) {
    while (list($key, $value) = each($array)) {
      if ( (!in_array($key, $exclude)) && ($key != 'x') && ($key != 'y') ) {
        $get_string .= $key . $equals . $value . $separator;
      }
    }
    $remove_chars = strlen($separator);
    $get_string = substr($get_string, 0, -$remove_chars);
  }
  return $get_string;
}


/**
  Map global to GET variable
  @package  oscss
  @author OscssTeam
  @note  Replication lib public
*/
function link_get_variable($var_name){
  if (isset($_GET[$var_name]))$GLOBALS[$var_name] =& $_GET[$var_name];
}


/**
Map global to POST variable
  @package  oscss
  @author OscssTeam
  @note  Replication lib public
*/
function link_post_variable($var_name){
  if (isset($_POST[$var_name])) $GLOBALS[$var_name] =& $_POST[$var_name];
}

/**
  @author oscim - OscssTeam
  @param string/boolean defini par une constante!
  @return boolean true/false
*/
function _cst_bool($text){
  if(!tep_not_null($text)) return false;
  $value=tep_cst_define($text);
  if( (is_string($value) && strtoupper($value)=='TRUE')||( is_bool($value) && $value==TRUE)  )  return true;
  elseif( (is_string($value) && (strtoupper($value)=='FALSE'))  || ( is_bool($value) && $value==FALSE)  ) return false;
  return false;
}

/**
  @package oscss-major
  @author oscim - OscssTeam
  @param string/boolean
  @return boolean true/false
*/
function _test_bool($value){
  if(!tep_not_null($value)) return false;
  if( (is_string($value) && (strtoupper($value)=='TRUE' || $value=='1' ) )||( is_bool($value) && ($value==TRUE || $value==1) ) || (is_numeric($value) && $value=1)  )  return true;
  elseif( (is_string($value) && (strtoupper($value)=='FALSE'))  || ( is_bool($value) && $value==FALSE)  ) return false;
  return false;
}

/**
  @author oscim - OscssTeam
  @version 1.0
   Test si une constante est defini , si celle-ci existe, renvoi sa valeur, sinon return (string)'false'
*/
function tep_cst_define($text){
  if(defined(strtoupper($text))) return constant(strtoupper($text));
  else return 'false';
}

/**
  Extraction chaine type GET en tableau
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  @param
    @a string class=www&fucntion=ddd
    @a string [null] la clef de tableau a retourner
  @return array
*/
function tep_extrac_querystring($query='',$search=''){
  $s=(!empty($query))?$query : $_SERVER['QUERY_STRING'];

  $r=explode('&',$s);
  foreach($r as $e){
    $i=strpos($e,'=');
    $f[substr($e,0,$i)]=substr($e,($i+1));
  }
  if(!empty($search) && isset($f[$search]) ) return $f[$search];
  elseif (!empty($search)) return false;
  else return $f;
}

/**
  Convertion de tableau au format json
  @param array
*/
function  convert_json($array){
  if(function_exists('json_encode'))return json_encode($array);
  else return FastJSON::convert($array);
}


/**
 Recup info sys
 @package osc 2.2Ms2
*/
function tep_get_system_information() {

    $db_query = tep_db_query("select now() as datetime");
    $db = tep_db_fetch_array($db_query);

    list($system, $host, $kernel) = preg_split('/[\s,]+/', @exec('uname -a'), 5);

    return array('date' => tep_datetime_short(date('Y-m-d H:i:s')),
                  'system' => $system,
                  'kernel' => $kernel,
                  'host' => $host,
                  'ip' => gethostbyname($host),
                  'uptime' => @exec('uptime'),
                  'http_server' => $_SERVER['SERVER_SOFTWARE'],
                  'php' => PHP_VERSION,
                  'zend' => (function_exists('zend_version') ? zend_version() : ''),
                  'db_server' => DB_SERVER,
                  'db_ip' => gethostbyname(DB_SERVER),
                  'db_version' => 'MySQL ' . (function_exists('mysql_get_server_info') ? mysql_get_server_info() : ''),
                  'db_date' => tep_datetime_short($db['datetime']));
}

/**
  @fn get_info_core($file,$name='svn')
  @brief Recuperation des element de svn basé sur le fichier oscss.version.xml
  @param $file path acces file
  @param $name string le tag qui doit être retourné
*/
function get_info_core($file,$name='svn'){
  if(!file_exists($file)) return die(__('Erreur récuperation fichier'));
  $SimpleParser = simplexml_load_file($file);
  if(!isset($SimpleParser->$name)) die(__('Erreur récuperation tag '.$name)) ;
  else return (string)$SimpleParser->$name;
}

/**
  @package oscss-2 <www http://www.oscss.org>
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  @return array for tep_tab_menu
  @param
    @a string type status
*/
function tep_get_status_array($type='orders'){
  global $languages_id;
  $list=array();
  $DB=Database::getInstance();
  $list_query = $DB->query($sql="select status_id, status_name from " . TABLE_STATUS . " where status_type='".$type."' and language_id='".(int)$languages_id."' order by status_id ASC");
  while ($status=$list_query->fetchAssoc())  $list[] = array('id' => $status['status_id'], 'text' => $status['status_name']);

  return $list;
}


/**
  @package oscss
  @author  OscssTeam
*/
function tep_tax_classes_pull_down($parameters, $selected = '') {
  $select_string = '<select ' . $parameters . '>';
  $classes_query = tep_db_query("select tax_class_id, tax_class_title from " . TABLE_TAX_CLASS . " order by tax_class_title");
  while ($classes = tep_db_fetch_array($classes_query)) {
    $select_string .= '<option value="' . $classes['tax_class_id'] . '"';
    if ($selected == $classes['tax_class_id']) $select_string .= ' selected="selected"';
    $select_string .= '>' . $classes['tax_class_title'] . '</option>';
  }
  $select_string .= '</select>';

  return $select_string;
}

/**
Returns the tax rate for a tax class
  @package oscss-Rv
  @author  oscim - OscssTeam
  @table tax_rates
*/
function tep_get_tax_rate_value($class_id) {
  $tax_query = tep_db_query("select tax_rate, tax_zone_id from " . TABLE_TAX_RATES . " where tax_class_id = '" . (int)$class_id . "' order by tax_priority");
  if (tep_db_num_rows($tax_query)) {
    $tax_table = array('tax_zone_id' => '0', 'tax_rate' => '0');
    while ($tax = tep_db_fetch_array($tax_query)) {
      if ($tax_table['tax_zone_id'] == '0'){
        $tax_table['tax_zone_id'] = $tax['tax_zone_id'];
        $tax_table['tax_rate'] = $tax['tax_rate'];
      }elseif ($tax_table['tax_zone_id'] == $tax['tax_zone_id']) $tax_table['tax_rate'] += $tax['tax_rate'];
    }
    return $tax_table['tax_rate'];
  }
  else return 0;
}


/**
  @package oscss-2 <www http://www.oscss.org>
  @version 1
  @date  11/03/10, 11:02
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  Suppression des cms
*/
function tep_remove_cms($cms_id){
  tep_db_query("delete from " . TABLE_CONTENT . " where content_id = '" . (int)$cms_id . "'");
  tep_db_query("delete from " . TABLE_CONTENT_DESCRIPTION . " where content_id = '" . (int)$cms_id . "'");
  tep_db_query("delete from " . TABLE_CONTENT_TO_CATEGORIES . " where content_id = '" . (int)$cms_id . "'");

//   osCSS_Cache::clear('cms_list');
}

/**
  suppression de commandes
  @package oscss-major
  @author oscim
  @version 4.1
  @page held_orders.php,orders.php
*/
function tep_remove_order($order_id, $restock = false,$customers_id='') {
  error_reporting(E_ALL);
    global $products_modules;
  if ($restock =='on'){
    tep_products_restock($order_id,$customers_id);
  }
  tep_db_query("delete from " . TABLE_ORDERS . " where orders_id = '" . (int)$order_id . "'");
  tep_db_query("delete from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . (int)$order_id . "'");
  tep_db_query("delete from " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . " where orders_id = '" . (int)$order_id . "'");
  tep_db_query("delete from " . TABLE_ORDERS_STATUS_HISTORY . " where orders_id = '" . (int)$order_id . "'");
  tep_db_query("delete from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . (int)$order_id . "'");
}

/**
  @fn  status_name($type , $status_id, $language_id = '')
  @brief public methode return name human
  @param type status string
  @param $status_id int
  @param $language_id int
  @return array
*/
function status_name($type , $status_id, $language_id = '') {
  global $languages_id;

  if (!is_numeric($language_id)) $language_id = $languages_id;

  $status_query = tep_db_query("select status_name from " . TABLE_STATUS . " where status_type='".$type."' AND  status_id = '" . $status_id . "' and language_id = '" . $language_id . "'");
  $status = tep_db_fetch_array($status_query);

  return $status['status_name'];
}
/**
  Alias
*/
function tep_get_orders_status_name($orders_status_id, $language_id = '') {
  return status_name('orders',$orders_status_id, $language_id);
}



/**
  TODO: Revoir le nom de cette fonction, et l'integer dans la class image
  @date  22/08/10, 01:30
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
*/
function tep_banner_image_extension() {
  if (function_exists('imagetypes')) {
    if (imagetypes() & IMG_PNG) return 'png';
    elseif (imagetypes() & IMG_JPG)return 'jpg';
    elseif (imagetypes() & IMG_GIF) return 'gif';
  }
  elseif (function_exists('imagecreatefrompng') && function_exists('imagepng')) return 'png';
  elseif (function_exists('imagecreatefromjpeg') && function_exists('imagejpeg')) return 'jpg';
  elseif (function_exists('imagecreatefromgif') && function_exists('imagegif')) return 'gif';
  return false;
}

/**
  list templates directorys
  @package  oscss
  @author OscssTeam
*/
function oscss_list_templates_admin() {
  $dir = dir(DIR_FS_ADMIN . DIR_WS_INCLUDES . 'template/');
  $themes_array = array();
  while ($file = $dir->read())
	  if($file != '..' && $file !='.' && $file !='' && file_exists(DIR_FS_ADMIN . DIR_WS_INCLUDES . 'template/'.$file.'/gabarit-' . $_SESSION['login_groups_id'] . '.php'))
			  $themes_array[] = array( 'id' => $file, 'text' => $file );
  $dir->close();
  return $themes_array;
}

/**
  list templates directorys
    @package  oscss
    @author OscssTeam
*/
function oscss_check_url($url) {
  return preg_match("%^http://[_A-Z0-9-]+\.[_A-Z0-9-]+[.A-Z0-9-]*(/~|/?)[/_.A-Z0-9#?&=+-]*$%i",$url);
}

/**
  @package  SEOURLs
  @author OscssTeam
  @version 2.1
  @note  Function to reset SEO URLs database cache entries
*/
function tep_reset_cache_data_seo_urls($action){
  switch ($action){
    case 'reset':
      tep_db_query("DELETE FROM " . TABLE_SEO_CACHE . " WHERE cache_name LIKE '%seo_urls%'");
      tep_db_query("UPDATE ".TABLE_CONFIGURATION." SET configuration_value='false' WHERE configuration_key='SEO_URLS_CACHE_RESET'");
    break;
    default:
  }
  # The return value is used to set the value upon viewing
  # It's NOT returining a false to indicate failure!!
  return 'false';
}



/**
  @package oscss
  @author oscim - OscssTeam
  @version 1.0
  Control la présence d'une constante de langue en remplacement de l'intitulé des menu de l'admin. Si cette constante n'est pas défini, une alerte est produite
  ne préciser que le contenu de la colonne key
*/
function tep_cst_menu_conf($cst){
    if (defined(strtoupper($cst))) return @constant(strtoupper($cst));
    elseif (defined('BOX_HEADING_CONF_'.strtoupper($cst))) return @constant('BOX_HEADING_CONF_'.strtoupper($cst));
    else return '<span class="error">'.'Erreur:: constante absente, nommé (BOX_HEADING_CONF_'.strtoupper($cst).') dans votre fichier de langue principal et  ('.strtoupper($cst).') représente la key de la table sql'.'</span>';
}


/**
  Fonctions remplacé par des class
  => Retrocompatibilité
*/
function ajax_in_Sats($cl=''){
  if(!class_exists('ajax_in_Sats'))require_once(DIR_WS_MODULES.'pages/'.'graphs_stats'.'.php');
  return graphs_stats::ajax_in_Sats($cl);
}

function tep_get_file_permissions($mode) { return fileUtility::get_file_permissions($mode);}
function tep_remove($source) { return fileUtility::_rmdir($source); }
function bu_gzip($directory, $file_in, $ext='zip',$delete_file = false, $level = 6) { return fileUtility::compress_dir($directory, $file_in, $ext, $delete_file , $level); }
function tep_zip_extractto($archive, $destination, $ext='zip') { return fileUtility::extractto($archive, $destination, $ext );}
function scan($strFolder) { return fileUtility::_scandir($strFolder); }



function tep_customers_name($customers_id) { return customerUtility::customers_name($customers_id); }
function tep_get_address_formats() { return customerUtility::address_format(); }
function tep_address_format($address_format_id, $address, $html, $boln, $eoln) { return customerUtility::address_format($address_format_id, $address, $html, $boln, $eoln); }

function tep_get_zone_code($country, $zone, $def_state) { return worldUtility::get_zone_code($country, $zone, $def_state); }
function tep_get_countries($default = '', $exclude=array()) { return worldUtility::get_countries($default, $exclude); }
function tep_get_country_zones($country_id) { return worldUtility::get_country_zones($country_id); }
function tep_get_zone_class_title($zone_class_id){return worldUtility::get_zone_class_title($zone_class_id); }
function tep_cfg_pull_down_zone_classes($zone_class_id, $key = '', $type='1'){return worldUtility::cfg_pull_down_zone_classes($zone_class_id, $key, $type); }
function tep_cfg_pull_down_zone_shipping($zone_class_id, $key = ''){ return worldUtility::cfg_pull_down_zone_classes($zone_class_id, $key , '2'); }
function tep_get_country_name($country_id){ return worldUtility::get_country_name($country_id); }
function tep_geo_zones_pull_down($parameters, $selected = '',$fisc=false){ return worldUtility::geo_zones_pull_down($parameters, $selected ,$fisc); }
function tep_get_geo_zone_name($geo_zone_id){ return worldUtility::get_geo_zone_name($geo_zone_id); }

function tep_get_languages($byindex=false, $public=true) { return language::get_languages($byindex, $public); }

function get_cat_list($current_ID='',$incre=false){ return categorieUtility:: get_cat_list($current_ID,$incre); }
function tep_childs_in_category_count($categories_id) { return categorieUtility::childs_in_category_count($categories_id); }
function tep_get_generated_category_path_ids($id, $from = 'category') { return categorieUtility::get_generated_category_path_ids($id, $from); }
function tep_get_category_tree($parent_id = '0', $spacing = '', $exclude = '', $category_tree_array = '', $include_itself = false) { return categorieUtility::get_category_tree($parent_id, $spacing, $exclude, $category_tree_array, $include_itself); }
function tep_parse_category_path($cPath) { return categorieUtility::parse_category_path($cPath); }
function tep_get_category_name($category_id, $language_id='') { return categorieUtility::get_category_name($category_id, $language_id); }
function tep_generate_category_path($id, $from = 'category', $categories_array = '', $index = 0) { return categorieUtility::generate_category_path($id, $from, $categories_array, $index); }

function tep_get_products_special_price($product_id) { return productUtility::get_products_special_price($product_id); }
function tep_get_uprid($prid, $params) { return productUtility::get_uprid($prid, $params); }
function tep_get_prid($uprid) { return productUtility::get_prid($uprid); }
function tep_get_products_name($product_id, $language_id = 0) { return productUtility::get_products_name($product_id, $language_id); }
function tep_remove_product($product_id) { return productUtility::remove_product($product_id); }
function tep_products_restock($order_id, $customers_id=''){ return productUtility::products_restock($order_id, $customers_id); }
function tep_get_product_list($exclude = ''){ return productUtility::get_product_list($exclude); }
function tep_options_name($options_id) { return productUtility::options_name($options_id); }
function tep_values_name($values_id) { return productUtility::values_name($values_id); }
function tep_get_product_extra_value($epf_id, $product_id, $language_id) { return productUtility::get_product_extra_value($epf_id, $product_id, $language_id); }
function tep_get_extra_field_list_value($value_id, $show_chain = false) { return productUtility::get_extra_field_list_value($value_id, $show_chain); }
function tep_list_epf_children($parent_id) { return productUtility::list_epf_children($parent_id); }
function tep_build_epf_pulldown($epf_id, $languages_id, $value_array = '', $parent_id = 0, $indent = '') { return productUtility::build_epf_pulldown($epf_id, $languages_id, $value_array, $parent_id , $indent); }
function tep_set_product_status($products_id, $status) { return productUtility::set_product_status($products_id, $status); }

function tep_get_tax_rate($class_id, $country_id = -1, $zone_id = -1)   { global $price; return $price->get_tax_rate($class_id, $country_id, $zone_id); }
function tep_get_tax_description($class_id, $country_id, $zone_id)      { global $price; return $price->get_tax_description($class_id, $country_id, $zone_id); }
function tep_add_tax($products_price, $tax, $force=false, $strict=true) { global $price; return $price->display_with_tax($products_price, $tax, $force, $strict); }
function tep_calculate_tax($products_price, $tax,$strict=false)         { global $price; return $price->get_tax_amount($products_price, $tax,$strict=false); }
function tep_display_tax_value($value, $padding = TAX_DECIMAL_PLACES)   { global $price; return $price->display_tax_value($value, $padding); }
function tep_get_tax_class_title($tax_class_id) 			{ global $price; return $price->tep_get_tax_class_title($tax_class_id); }

function qtpro_doctor_investigate_product($products_id){ return qtproUtility::doctor_investigate_product($products_id);}
function qtpro_product_has_tracked_options($products_id){ return qtproUtility::product_has_tracked_options($products_id);}
function qtpro_get_products_summary_stock($products_id){ return qtproUtility::get_products_summary_stock($products_id);}
function qtpro_doctor_amputate_all_from_product($products_id){ return qtproUtility::doctor_amputate_all_from_product($products_id);}
function qtpro_products_attributes_string2options_array($products_attributes_string){ return qtproUtility::products_attributes_string2options_array($products_attributes_string);}
function qtpro_update_summary_stock($products_id){ return qtproUtility::update_summary_stock($products_id);}
function qtpro_calculate_summary_stock($products_id){ return qtproUtility::calculate_summary_stock($products_id);}

function tep_create_rma_value($length, $type = 'digits') {return ReturnsUtility::CreateReturnsKey($length, $type) ;}
function tep_calculate_deduct($price, $tax){return  ReturnsUtility::CalculateDeduct($price, $tax); }
function tep_get_return_reason(){return ReturnsUtility::list_return_reasons();}
function tep_get_returns_status(){return ReturnsUtility::list_returns_status();}
function tep_get_refund_method(){return ReturnsUtility::list_refund_method();}
function tep_remove_return($order_id, $restock = false){return ReturnsUtility::RemoveReturns($order_id, $restock);}
function tep_get_return_reason_name($return_reason_id, $language_id = ''){return ReturnsUtility::status_name('return_reasons' , $return_reason_id, $language_id) ;}
function tep_get_returns_status_name($returns_status_id, $language_id = ''){return ReturnsUtility::status_name('returns' ,$returns_status_id, $language_id);}
function tep_get_refund_method_name($refund_method_id, $language_id = ''){return ReturnsUtility::status_name('refund_method' ,$refund_method_id, $language_id) ;}

function tep_mail($to_name, $to_email_address, $email_subject, $email_text, $from_email_name='', $from_email_address='') {  return emailUtility::tep_mail($to_name, $to_email_address, $email_subject, $email_text, $from_email_name, $from_email_address);}
function tep_replace_for_mail($txt_mail,$subject,$html_reg,$text_reg,$mode='HTML') {  return emailUtility::replace_for_mail($txt_mail,$subject,$html_reg,$text_reg,$mode);}
function tep_post_prepare_email($template,$language,$myarray,$print=false) {  return emailUtility::post_prepare_email($template,$language,$myarray,$print);}
function tep_recup_template_mail() {  return emailUtility::recup_template_mail();}

function quote_oanda_currency($code, $base = DEFAULT_CURRENCY) {return localizationUtility::oanda_currency($code, $base);}
function quote_xe_currency($to, $from = DEFAULT_CURRENCY){return localizationUtility::xe_currency($to, $from);}


/**
  @fn alias oscss_cstr::test_gab_theme($element,$ext='php')
  @brief load Template Environement
  @return (bool)false OR string path file
*/
function tep_test_gab_ele($element,$ext='php'){ return oscss_cstr::test_gab_theme($element,$ext); }

/** @fn alias MGabCont::CallGab($filename); */
function tep_get_include_contents($filename) { return MGabCont::CallGab($filename); }
?>