<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  06/02/11, 19:57
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8

*/

/**
  @brief The HTML href link wrapper function
*/
function tep_href_link($page = '', $parameters = ''/*, $connection = 'NONSSL'*/) {
  if ($page == '') $page=basename(preg_replace("/[?].*/i",'',$_SERVER['REQUEST_URI']));


  if (ENABLE_SSL == true)  $link = HTTPS_SERVER . DIR_WS_ADMIN;
  else  $link = HTTP_SERVER . DIR_WS_ADMIN;


  if ($parameters == '')  $link = $link . $page . '?' . SID;
  else  $link = $link . $page . '?' . $parameters . '&amp;' . SID;

  while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);
  while ( (substr($link, -5) == '&amp;') ) $link = substr($link, 0, -5);

  return $link;
}

/**
  @version 2.0
  @brief Ultimate SEO URLs v2.1 The HTML href link wrapper function Or href classic
  @param $page string name page destination
  @param $parameters Get value
  @param $linkadmin bool add link for connectin front for admin user
*/
if (_cst_bool('SEO_ENABLED')) {
  function tep_catalog_href_link($page = '', $parameters = '', $connection = 'NONSSL', $linkadmin= true) {
    global $languages_id,$SecuKey;
    $add_session_id = true;
    $search_engine_safe = true;
    /// force offline mode
    if($linkadmin)$parameters =(empty($parameters)? '' : '&'  ).'admin='.md5($SecuKey);

    $seo_urls = seo_url::getInstance($languages_id);
    return preg_replace('/&/','&',$seo_urls->href_link($page, $parameters, $connection, $add_session_id));
  }
} else {
  function tep_catalog_href_link($page = '', $parameters = '', $connection = 'NONSSL', $linkadmin= true) {
    global $SecuKey;

    if ($connection == 'NONSSL')  $link = HTTP_SERVER . DIR_WS_HTTP_CATALOG;
    elseif ($connection == 'SSL')  $link = tep_get_httpdir();
    else die('<br /><br /><span class="error"><strong>Error!</strong><br /><br /><strong>Unable to determine connection method on a link!<br /><br />Known methods: NONSSL SSL<br /><br />Function used:<br /><br />tep_href_link(\'' . $page . '\', \'' . $parameters . '\', \'' . $connection . '\')</strong></span>');

    /// force offline mode
     if($linkadmin)$parameters =(empty($parameters)? '' : '&'  ).'admin='.md5($SecuKey);

    if ($parameters == '')$link .= $page;
    else $link .= $page . '?' . $parameters;

    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);

    return $link;
  }

}


/**
  Draw a 1 pixel black line
  @file order.php
*/
function tep_black_line() {
  return tep_image(DIR_WS_IMAGES . 'pixel_black.gif', '', '100%', '1');
}

/**
  Output a separator either through whitespace, or with an image
  @file order.php
*/
function tep_draw_separator($image = 'pixel_black.gif', $width = '100%', $height = '1') {
  return tep_image(DIR_WS_IMAGES . $image, '', $width, $height);
}


/**
  @author oscim - OscssTeam
  @version 1.1
  Appel des fichiers est evite doublon
  ([[[$value(string) path ou url de base],(option)$ref (boolean|string) le path ou url absolu, si true, ref sur base admin si false ref public],(option)$force(boolean) pour forcer chargement meme deja chargee])
*/
function tep_include_file ($value,$ref=false,$force=false) {
  static $deja_charge;
  if (!tep_not_null($value)) return false;
  if ($ref){
    $refe['url']= tep_get_http() . DIR_WS_ADMIN;
    $refe['path']= DIR_FS_ADMIN;
  } else  {
    $refe['url']= tep_get_http();
    $refe['path']= DIR_FS_CATALOG;
  }

  $long=strlen($value);
  $key=md5($value);
  if (!isset($deja_charge[$key]) || $force) {
    if (substr($value,($long-3),$long)=='css') print "<link rel=\"stylesheet\" href=\"".$refe['url'].$value."\"  type=\"text/css\" media=\"all\" />\n";
    elseif (substr($value,($long-2),$long)=='js') print '<script type="text/javascript" src="'.$refe['url'].$value.'"></script>'."\n";
    elseif(substr($value,($long-3),$long)=='php'||substr($value,($long-3),$long)=='inc') include ($refe['path'].$value);
  }
  $deja_charge[$key]='';
}

/**
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  @version 1.1
  Permet d'ajouter en tete de colonne de tableau le tri asc ou desc, sur une colonne SQL. Construit l'appel les class, et place les images
  tep_link_sort_by([[$filename string le FILENAME de la page],$sql_sort string la colonne sql a trier])
*/
function tep_link_sort_by($filename,$sql_sort){
  $filename=substr($filename,0,strpos('?',$filename));
  $option=strchr($filename,'?');
  if(isset($get['sort_by'])) $get['sort_by']=tep_sanitize_string($_GET['sort_by']);
  return "<span class=\"sort_by\"> <a class=\"".(isset($get['sort_by'])&&(preg_match('/'.$sql_sort.'[[:blank:]]*(ASC)$/i',$get['sort_by']))?'Selected':'')."\" href=\"" . tep_href_link( $filename, tep_get_all_get_params(array('page_admin','sort_by')).'sort_by='.$sql_sort.' ASC')."\" >".tep_image(DIR_WS_ICONS . 'icon_up.gif', TEXT_ASCENDINGLY)."</a> <a class=\"".(isset($get['sort_by'])&&(preg_match('/'.$sql_sort.'[[:blank:]]*(DESC)$/i',$get['sort_by']))?'Selected':'')."\" href=\"" . tep_href_link( $filename,tep_get_all_get_params(array('page_admin','sort_by')).'sort_by='.$sql_sort.' DESC')."\" >".tep_image(DIR_WS_ICONS . 'icon_down.gif', TEXT_DESCENDINGLY)."</a></span>";
}

/**
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  @version 1.0
  Nettoyeur de chaine de caratére, ou le reverse de htmlentites
  unhtmlentities([[$chaineHtml string],$utf8 (option) boolean])
*/
function unhtmlentities($chaineHtml,$utf8=false) {
  $tmp = get_html_translation_table(HTML_ENTITIES);
  $tmp = array_flip ($tmp);
  $chaineTmp = ($utf8==true) ?utf8_encode(strtr ($chaineHtml, $tmp)) : strtr ($chaineHtml, $tmp);
  return $chaineTmp;
}


/**
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  @version 1.0
  Chargeur de browser d 'images, si l'argument de l'id du retour de l'url de l'image est absent, alors la function charge le block header, sinon prend en charge l'appel du browser
  tep_get_filebroswerserveur([$getElementById (option) id de l'element pour le retourde url])
*/
function tep_get_filebroswerserveur($getElementById=false,$type='image',$folder=''){
  $filebrowser= (tep_cst_define('BO_FILEBROSWER_SERVER_USE') =='false' || BO_FILEBROSWER_SERVER_USE ==false) ?'filebrowser' : BO_FILEBROSWER_SERVER_USE;

  switch($filebrowser){
    case 'tinybrowser':
            if ($getElementById !=false) return 'tinyBrowserPopUp(\''.$type.'\', \''.$getElementById.'\',\''.$folder.'\');return false;';
            else return '<script type="text/javascript" src="editeur/tiny_mce/plugins/tinybrowser/tb_standalone.js.php"></script>';
    break;
    case 'toolbar':
    default:
        if ($getElementById !=false) return 'window.open(\'editeur/toolbar/images-popup.php?'.tep_session_name().'='.tep_session_id().'&p_content='.$getElementById.'&lg='.DEFAULT_LANGUAGE.'&mode=popup&type='.$type.'&folder='.$folder.'\',\'popupImageWindow\',\'width=650,height=600,scrollbars=yes,resizable=yes,status=yes,titlebar=0\');return false;';
  }

}


/**
  @fn row_by_page($file,$row_bypage_array,  $row_by_page, $class="fleft",$form=true)
  @brief Constructeur du block form + select, du  rows_by_page et de sa section placé dans le top
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  @param $file string
  @param $row_bypage_array array
  @param $row_by_page int
  @param $class string
  @param $form bool
  return string
*/
function row_by_page($file,$row_bypage_array,  $row_by_page, $class="fleft",$form=true) {
    $s='';
    if($form)$s.= tep_draw_form('form_row_by_page', $file, '', 'get',' class="'.$class.'" ');
    $s.='<p class="inline">';
    if($form)
      foreach($_GET as $k=>$v)
	if ($k !='page_admin' && $k !='row_by_page') $s.=tep_draw_hidden_field( $k, $k,$v);
    $s.=''.TEXT_MAXI_ROW_BY_PAGE . '&nbsp;&nbsp;' . tep_draw_pull_down_menu('row_by_page', $row_bypage_array,  $row_by_page, 'id="row_by_page_select" onchange="this.form.submit();"').'</p>';
    if($form) $s.='</form>';
    return $s;
}

/**
  @fn tep_mailto($customer_email,$origin='')
  @brief mail to for customer
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  @note idem tep_href_link, mais pour le mailto
  @param customer_email string  mail du client
  @param origin string  page back
*/
function tep_mailto($customer_email,$origin='') {
  if(!empty($origin))return tep_href_link(FILENAME_MAIL, 'customer=' . $customer_email.'&amp;origin='.urlencode($origin), 'NONSSL');
  else return tep_href_link(FILENAME_MAIL, 'customer=' . $customer_email, 'NONSSL');
}



/**
  @fn tep_decal($c)
  @brief this function add espace for display hierarchy in category
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  @param $c int number repeat
*/
function tep_decal($c){
  $g='';
  for($i=0;$i<$c;$i++) $g.= '&nbsp;&nbsp;';
  return $g;
}


/**
  @fn tep_js_back($href,$text=IMAGE_BACK)
  @brief Prend en charge le bouton retour, et ajoute close box popup si ouvert via fancy
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  @param $href string url by href_link
  @param $text string text
  @return string  <a class="button ActionBack" href="' . $href . '" '.$js.'>'.$text.'</a>
*/
function tep_js_back($href,$text=IMAGE_BACK){
  $js = (isset($_GET['fancy']) || isset($_GET['forceview'])) ? ' onclick="parent.$.fancybox.close();" ': (isset($_GET['forceajax']) ? ' onclick="$.fancybox.close();return false;" ' : '') ;
  return '<a class="button ActionBack" href="' . $href . '" '.$js.'>'.$text.'</a>';
}

/**
  Fonctions remplacé par des class
  => Retrocompatibilité
*/
function tep_customers_row_action($customers_id,$opt='') { return customerUtility::DisplayRowAction($customers_id,$opt); }
function tep_image($src, $alt = '', $width = '', $height = '', $parameters = '',$mode=false) { $img=image_ratio::getInstance(); return $img->tep_image($src, $alt, $width, $height, $parameters,$mode); }
function tep_info_image($image, $alt, $width = '', $height = '') { return tep_image(DIR_WS_CATALOG_IMAGES . $image, $alt, $width, $height); }


function tep_image_submit($image, $alt = '', $parameters = '',$classCss='') { return formUtility::image_submit($image, $alt, $parameters ,$classCss); }
function tep_image_button($image, $alt = '', $params = ''){ return formUtility::image_button($image, $alt, $parameters ); }
function tep_draw_form($name, $action, $parameters = '', $method = 'post', $params = ''){ return formUtility::draw_form($name, $action, $parameters, $method, $params ); }
function tep_draw_input_field($name, $id='', $value = '', $parameters = '', $required = false, $type = 'text', $reinsert_value = true) { return formUtility::draw_input_field($name, $id, $value, $parameters, $required , $type, $reinsert_value ); }
function tep_draw_password_field($name, $id='', $value = '', $required = false) { return formUtility::draw_input_field($name, $id, $value, 'maxlength="40"', $required, 'password', false); }
function tep_draw_file_field($name, $id='', $required = false,$parameters = '') { return formUtility::draw_input_field($name, $id, '', $parameters, $required, 'file' ); }
function tep_draw_selection_field($name, $id='', $type, $value = '', $checked = false, $compare = '', $parameters = ''){ return formUtility::draw_selection_field($name, $id, $type, $value , $checked , $compare, $parameters ); }
function tep_draw_checkbox_field($name, $id = '', $value = '', $checked = false, $compare = '', $parameters = '') { return formUtility::draw_selection_field($name, $id, 'checkbox', $value, $checked, $compare, $parameters ); }
function tep_draw_radio_field($name, $id = '', $value = '', $checked = false, $compare = '', $parameters = ''){ return formUtility::draw_selection_field($name, $id, 'radio', $value, $checked, $compare, $parameters ); }

function tep_draw_textarea_field($name, $id = '', $width, $height, $text = '', $parameters = '', $reinsert_value = true) { return formUtility::draw_textarea_field($name, $id , $width, $height, $text , $parameters , $reinsert_value); }
function tep_draw_hidden_field($name, $id = '', $value = '', $parameters = '') { return formUtility::draw_hidden_field($name, $id , $value, $parameters ); }
function tep_draw_pull_down_menu($name, $values, $default = '', $parameters = '', $required = false) { return formUtility::draw_pull_down_menu($name, $values, $default, $parameters, $required ); }
?>