<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  19/12/10, 19:49
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

/**
  Sets the status of a banner
  @package oscss-2 <www http://www.oscss.org>
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
*/
function tep_set_banner_status($banners_id, $status) {
  if ($status == '1') {
    return tep_db_query("update " . TABLE_BANNERS . " set status = '1', expires_impressions = NULL, expires_date = NULL, date_status_change = NULL where banners_id = '" . $banners_id . "'");
  } elseif ($status == '0') {
    return tep_db_query("update " . TABLE_BANNERS . " set status = '0', date_status_change = now() where banners_id = '" . $banners_id . "'");
  } else {
    return -1;
  }
}


/**
  Banniere 3j infobox
  @package oscss-2 <www http://www.oscss.org>
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
*/
function banner_infobox($banner_id,$banner_stats,$days){

  $banner_extension = tep_banner_image_extension();

  include(DIR_WS_CLASSES . 'phplot.php');

  $stats = array();
  $banner_stats_query = tep_db_query("select dayofmonth(banners_history_date) as name, banners_shown as value, banners_clicked as dvalue from " . TABLE_BANNERS_HISTORY . " where banners_id = '" . $banner_id . "' and to_days(now()) - to_days(banners_history_date) < " . $days . " order by banners_history_date");
  while ($banner_stats = tep_db_fetch_array($banner_stats_query)) {
    $stats[] = array($banner_stats['name'], $banner_stats['value'], $banner_stats['dvalue']);
  }

  if (sizeof($stats) < 1) $stats = array(array(date('j'), 0, 0));

  $img='images/graphs/banner_infobox-' . $banner_id . '.' . $banner_extension;

  $graph = new PHPlot(200, 220,$img );

  $graph->SetFileFormat($banner_extension);
  $graph->SetIsInline(1);
  $graph->SetPrintImage(0);

  $graph->draw_vert_ticks = 0;
  $graph->SetSkipBottomTick(1);
  $graph->SetDrawXDataLabels(0);
  $graph->SetDrawYGrid(0);
  $graph->SetPlotType('bars');
  //$graph->SetDrawDataLabels(1);
  $graph->SetLabelScalePosition(1);
  $graph->SetMarginsPixels(15,15,15,30);

  //! font , et taille
  $graph->SetTitleFontSize('3');
  $graph->SetTTFPath(DIR_FS_CATALOG.DIR_WS_COMMON_FONTS);
  $graph->SetDefaultTTFont('arial.ttf');
  $graph->SetFontTTF('x_label', 'arial.ttf','8');
  $graph->SetFontTTF('y_label', 'arial.ttf','8');
  $graph->SetFontTTF('legend', 'arial.ttf','10');

  $graph->SetTitle(utf8_decode(TEXT_BANNERS_LAST_3_DAYS));

  $graph->SetBackgroundColor('#f0f0ee');
  $graph->SetTransparentColor('#f0f0ee');

  $graph->SetDataValues($stats);
  $graph->SetDataColors(array('blue','red'),array('blue', 'red'));

  $graph->DrawGraph();

  $graph->PrintImage();

  return $img;
}
?>