<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  19/12/10, 19:49
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/



/**
  Banniere banner_daily
  @package oscss-2 <www http://www.oscss.org>
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
*/
function banner_daily($banner_id,$banner){

  $banner_extension = tep_banner_image_extension();

  include(DIR_WS_CLASSES . 'phplot.php');

  $year = (isset($_GET['year']) ? $_GET['year'] : date('Y'));
  $month = (isset($_GET['month']) ? $_GET['month'] : date('n'));

  $days = (date('t', mktime(0,0,0,$month))+1);
  $stats = array();
  for ($i=1; $i<$days; $i++) {
    $stats[] = array($i, '0', '0');
  }

  $banner_stats_query = tep_db_query("select dayofmonth(banners_history_date) as banner_day, banners_shown as value, banners_clicked as dvalue from " . TABLE_BANNERS_HISTORY . " where banners_id = '" . $banner_id . "' and month(banners_history_date) = '" . $month . "' and year(banners_history_date) = '" . $year . "'");
  while ($banner_stats = tep_db_fetch_array($banner_stats_query)) {
    $stats[($banner_stats['banner_day']-1)] = array($banner_stats['banner_day'], (($banner_stats['value']) ? $banner_stats['value'] : '0'), (($banner_stats['dvalue']) ? $banner_stats['dvalue'] : '0'));
  }

  $graph = new PHPlot(600, 350, 'images/graphs/banner_daily-' . $banner_id . '.' . $banner_extension);

  $graph->SetFileFormat($banner_extension);
  $graph->SetIsInline(1);
  $graph->SetPrintImage(0);

  $graph->SetSkipBottomTick(1);
  $graph->SetDrawYGrid(1);
  $graph->SetPrecisionY(0);
  $graph->SetPlotType('lines');

  //! font , et taille
  $graph->SetTitleFontSize('3');
  $graph->SetTTFPath(DIR_FS_CATALOG.DIR_WS_COMMON_FONTS);
  $graph->SetDefaultTTFont('arial.ttf');
  $graph->SetFontTTF('x_label', 'arial.ttf','8');
  $graph->SetFontTTF('y_label', 'arial.ttf','8');
  $graph->SetFontTTF('legend', 'arial.ttf','10');

  $graph->SetPlotBorderType('left');
  $graph->SetTitle(utf8_decode(sprintf(TEXT_BANNERS_DAILY_STATISTICS, $banner['banners_title'], tep_strftime('%B', mktime(0,0,0,$month)), $year)));

  $graph->SetBackgroundColor('white');
//   $graph->SetTransparentColor('white');

  $graph->SetVertTickPosition('plotleft');
  $graph->SetDataValues($stats);
  $graph->SetDataColors(array('blue','red'),array('blue', 'red'));

  $graph->DrawGraph();

  $graph->PrintImage();

  return $stats;
}

/**
  Banniere banner_daily
  @package oscss-2 <www http://www.oscss.org>
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
*/
function banner_monthly($banner_id,$banner){

  $banner_extension = tep_banner_image_extension();

  include(DIR_WS_CLASSES . 'phplot.php');

  $year = (isset($_GET['year']) ? $_GET['year'] : date('Y'));

  $stats = array();
  for ($i=1; $i<13; $i++) {
    $stats[] = array(tep_strftime('%b', mktime(0,0,0,$i)), '0', '0');
  }

  $banner_stats_query = tep_db_query("select month(banners_history_date) as banner_month, sum(banners_shown) as value, sum(banners_clicked) as dvalue from " . TABLE_BANNERS_HISTORY . " where banners_id = '" . $banner_id . "' and year(banners_history_date) = '" . $year . "' group by banner_month");
  while ($banner_stats = tep_db_fetch_array($banner_stats_query)) {
    $stats[($banner_stats['banner_month']-1)] = array(tep_strftime('%b', mktime(0,0,0,$banner_stats['banner_month'])),
						      (($banner_stats['value']) ? $banner_stats['value'] : '0'),
						      (($banner_stats['dvalue']) ? $banner_stats['dvalue'] : '0'));
  }

  $graph = new PHPlot(600, 350, 'images/graphs/banner_monthly-' . $banner_id . '.' . $banner_extension);

  $graph->SetFileFormat($banner_extension);
  $graph->SetIsInline(1);
  $graph->SetPrintImage(0);

// $graph->SetXLabelType('data', 2, '', '\xe2\x82\xac');
  //! font , et taille
  $graph->SetTitleFontSize('3');
  $graph->SetTTFPath(DIR_FS_CATALOG.DIR_WS_COMMON_FONTS);
  $graph->SetDefaultTTFont('arial.ttf');
  $graph->SetFontTTF('x_label', 'arial.ttf','8');
  $graph->SetFontTTF('y_label', 'arial.ttf','8');
  $graph->SetFontTTF('legend', 'arial.ttf','10');

  $graph->SetSkipBottomTick(1);
  $graph->SetDrawYGrid(1);
  $graph->SetPrecisionY(0);
  $graph->SetPlotType('lines');

  $graph->SetPlotBorderType('left');
  $graph->SetTitle(sprintf(TEXT_BANNERS_MONTHLY_STATISTICS, $banner['banners_title'], $year));

  $graph->SetBackgroundColor('white');
//   $graph->SetTransparentColor('white');

  $graph->SetVertTickPosition('plotleft');
  $graph->SetDataValues($stats);
  $graph->SetDataColors(array('blue','red'),array('blue', 'red'));

  $graph->DrawGraph();

  $graph->PrintImage();

  return $stats;
}


/**
  Banniere banner_daily
  @package oscss-2 <www http://www.oscss.org>
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
*/
function banner_yearly($banner_id,$banner){

  $banner_extension = tep_banner_image_extension();

  include(DIR_WS_CLASSES . 'phplot.php');

  $stats = array(array('0', '0', '0'));
  $banner_stats_query = tep_db_query("select year(banners_history_date) as year, sum(banners_shown) as value, sum(banners_clicked) as dvalue from " . TABLE_BANNERS_HISTORY . " where banners_id = '" . $banner_id . "' group by year");
  while ($banner_stats = tep_db_fetch_array($banner_stats_query)) {
    $stats[] = array($banner_stats['year'], (($banner_stats['value']) ? $banner_stats['value'] : '0'), (($banner_stats['dvalue']) ? $banner_stats['dvalue'] : '0'));
  }

  $graph = new PHPlot(600, 350, 'images/graphs/banner_yearly-' . $banner_id . '.' . $banner_extension);

  $graph->SetFileFormat($banner_extension);
  $graph->SetIsInline(1);
  $graph->SetPrintImage(0);

  //! font , et taille
  $graph->SetTitleFontSize('3');
  $graph->SetTTFPath(DIR_FS_CATALOG.DIR_WS_COMMON_FONTS);
  $graph->SetDefaultTTFont('arial.ttf');
  $graph->SetFontTTF('x_label', 'arial.ttf','8');
  $graph->SetFontTTF('y_label', 'arial.ttf','8');
  $graph->SetFontTTF('legend', 'arial.ttf','10');

  $graph->SetSkipBottomTick(1);
  $graph->SetDrawYGrid(1);
  $graph->SetPrecisionY(0);
  $graph->SetPlotType('lines');

  $graph->SetPlotBorderType('left');
  $graph->SetTitle(sprintf(TEXT_BANNERS_YEARLY_STATISTICS, $banner['banners_title']));

  $graph->SetBackgroundColor('white');
//   $graph->SetTransparentColor('white');

  $graph->SetVertTickPosition('plotleft');
  $graph->SetDataValues($stats);
  $graph->SetDataColors(array('blue','red'),array('blue', 'red'));

  $graph->DrawGraph();

  $graph->PrintImage();

  return $stats;
}
?>