<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  19/12/10, 19:46
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

/**
  @version 1.1
  @note Construit la sortie du chemin (fil arine ) de la catégory sous forme texte
*/
function tep_output_generated_category_path($id, $from = 'category') {
    $calculated_category_path_string = 'racine &nbsp;&gt;&nbsp;';
    $calculated_category_path = tep_generate_category_path($id, $from);
    for ($i=0, $n=sizeof($calculated_category_path); $i<$n; $i++) {
      for ($j=0, $k=sizeof($calculated_category_path[$i]); $j<$k; $j++) {
        $calculated_category_path_string .= $calculated_category_path[$i][$j]['text'] . '&nbsp;&gt;&nbsp;';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -16) ;
    }
//     $calculated_category_path_string = substr($calculated_category_path_string, 0, -4);

    if (strlen($calculated_category_path_string) < 1) $calculated_category_path_string = TEXT_TOP;

    return $calculated_category_path_string;
}




/**
  @version 1.1
  @note
*/
function tep_remove_category($category_id) {
  $category_image_query = tep_db_query("select categories_image from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$category_id . "'");
  $category_image = tep_db_fetch_array($category_image_query);

  $duplicate_image_query = tep_db_query("select count(*) as total from " . TABLE_CATEGORIES . " where categories_image = '" . tep_db_input($category_image['categories_image']) . "'");
  $duplicate_image = tep_db_fetch_array($duplicate_image_query);

  if ($duplicate_image['total'] < 2) {
    if (file_exists(DIR_FS_CATALOG_IMAGES . $category_image['categories_image'])) {
      @unlink(DIR_FS_CATALOG_IMAGES . $category_image['categories_image']);
    }
  }

  tep_db_query("delete from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$category_id . "'");
  tep_db_query("delete from " . TABLE_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "'");

  osCSS_Cache::clear('categoriesBox');
  osCSS_Cache::clear('category_tree');
  osCSS_Cache::clear('also_purchased');
}

/**
  @version 1.1
  @note  Return l'id de
*/
function tep_get_path($current_category_id = '') {
  global $cPath_array;

  if ($current_category_id == '') {
    $cPath_new = implode('_', $cPath_array);
  } else {
    if (sizeof($cPath_array) == 0) {
      $cPath_new = $current_category_id;
    } else {
      $cPath_new = '';
      $last_category_query = tep_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$cPath_array[(sizeof($cPath_array)-1)] . "'");
      $last_category = tep_db_fetch_array($last_category_query);

      $current_category_query = tep_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$current_category_id . "'");
      $current_category = tep_db_fetch_array($current_category_query);

      if ($last_category['parent_id'] == $current_category['parent_id']) {
        for ($i = 0, $n = sizeof($cPath_array) - 1; $i < $n; $i++) {
          $cPath_new .= '_' . $cPath_array[$i];
        }
      } else {
        for ($i = 0, $n = sizeof($cPath_array); $i < $n; $i++) {
          $cPath_new .= '_' . $cPath_array[$i];
        }
      }

      $cPath_new .= '_' . $current_category_id;

      if (substr($cPath_new, 0, 1) == '_') {
        $cPath_new = substr($cPath_new, 1);
      }
    }
  }

  return 'cPath=' . $cPath_new;
}



/**
  @fn tep_products_in_category_count($categories_id, $include_deactivated = false)
  @brief Count how many products exist in a category
  @param $categories_id integer
  @param $include_deactivated boolean true = status products 1 | false status products null
  @return integer count child products in catg
*/
function tep_products_in_category_count($categories_id, $include_deactivated = false) {
  $products_count = 0;

  if ($include_deactivated)  $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p2c.categories_id = '" . (int)$categories_id . "'");
  else  $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p.products_status = '1' and p2c.categories_id = '" . (int)$categories_id . "'");

  $products = tep_db_fetch_array($products_query);
  $products_count += $products['total'];
  $childs_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$categories_id . "'");
  if (tep_db_num_rows($childs_query))
    while ($childs = tep_db_fetch_array($childs_query))  $products_count += tep_products_in_category_count($childs['categories_id'], $include_deactivated);

  return $products_count;
}

/**
  @fn tep_cms_in_category_count($categories_id, $include_deactivated = false)
  @brief Count how many cms exist in a category
  @param $categories_id integer
  @param $include_deactivated boolean true = status content 1 | false status content null
  @return integer count child content in catg
*/
function tep_cms_in_category_count($categories_id, $include_deactivated = false) {
  $products_count = 0;

  if ($include_deactivated)  $products_query = tep_db_query("select count(*) as total from " . TABLE_CONTENT . " p, " . TABLE_CONTENT_TO_CATEGORIES . " p2c where p.content_id = p2c.content_id and p2c.categories_id = '" . (int)$categories_id . "'");
  else  $products_query = tep_db_query("select count(*) as total from " . TABLE_CONTENT . " p, " . TABLE_CONTENT_TO_CATEGORIES . " p2c where p.content_id = p2c.content_id and p.content_status = '1' and p2c.categories_id = '" . (int)$categories_id . "'");

  $products = tep_db_fetch_array($products_query);
  $products_count += $products['total'];
  $childs_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$categories_id . "'");
  if (tep_db_num_rows($childs_query))
    while ($childs = tep_db_fetch_array($childs_query))  $products_count += tep_cms_in_category_count($childs['categories_id'], $include_deactivated);

  return $products_count;
}



?>