<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  19/12/10, 19:49
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

/**
  Construction d'un sous menu des page de configuration, s'appuiyant sur la valeur de l'id parent.
*/
function tep_ssmenu_configuration($parent_id,$option=''){
  $format_line_ssmenu= (isset($option['format_line_ssmenu']))  ? $option['format_line_ssmenu'] : "%1\$s"; //'<li class="'."%2\$s".'">'."%1\$s".'</li>' ."\n";
  $link='';
  $configuration_groups_query = tep_db_query("SELECT configuration_group_id AS cgID, configuration_group_title AS cgTitle from " . TABLE_CONFIGURATION_GROUP . " WHERE configuration_group_group_id LIKE '".$_SESSION['login_groups_id']."' AND configuration_group_parentid  ='".$parent_id."' ORDER BY configuration_group_parentid ,  sort_order ASC");

  while ($configuration_groups = tep_db_fetch_array($configuration_groups_query)) {
      $link .=sprintf($format_line_ssmenu,
                      '<a href="' . tep_href_link(FILENAME_CONFIGURATION, 'gparentID=' . $parent_id.'&amp;gID=' . $configuration_groups['cgID'], 'NONSSL') . '" class="menuBoxContentLink config'.$configuration_groups['cgID'].'">' . tep_cst_menu_conf($configuration_groups['cgTitle']) . '</a>'."\n"
		    ,$parent_id);
  }

 return $link;
}


/**
  Alias function for Store configuration values in the Administration Tool
*/
function tep_cfg_select_option($select_array, $key_value, $key = '') {
  $string = '';
  for ($i=0, $n=sizeof($select_array); $i<$n; $i++) {
      $name = ((tep_not_null($key)) ? 'configuration[' . $key . ']' : 'configuration_value');
      $string .= '<input type="radio" name="' . $name . '" value="' . $select_array[$i] . '"';
      if ($key_value == $select_array[$i]) $string .= ' checked="checked"';
      $string .= '/> ' . $select_array[$i] . '<br />';
  }
  return $string;
}


/**
  Function de la table admin_config; met en forme le tableau d'option,possible avec un tabelau clef/valeur, avec la key pour valeur db et value pour lecture humaine
  $select_array = array(key=value => value=text)
*/
function tep_cfg_select_option_bis($select_array, $key_value, $key = '') {
  $string = '';
  while($rs=each($select_array)){
    $name = ((tep_not_null($key)) ? 'configuration[' . $key . ']' : 'configuration_value');
    $string .= '<input type="radio" name="' . $name . '" value="' . $rs['key'] . '"';
    if ($key_value == $rs['key']) $string .= ' checked="checked"';
    $string .= '/> ' . $rs['value'] . '<br />';
  }
  return $string;
}

/**
  Alias tep_cfg_select_option_bis en Select
*/
function tep_cfg_select_pull_down($select_array, $key_value, $key = '') {
  $name = (tep_not_null($key) ? 'configuration[' . $key . ']' : 'configuration_value');

  foreach ($select_array as $k=>$v) $list_array[] = array('id' => $k, 'text' => $v);

  return tep_draw_pull_down_menu($name, $list_array, $key_value);
}

/**
  Function de la table admin_config; utlisé pour la definition d'image, via le broswer de fichier
*/
function tep_cfg_choose_img($key_value,$key='') {
  $name = ((tep_not_null($key)) ? 'configuration[' . $key . ']' : 'configuration_value');
  $string=tep_get_filebroswerserveur();
  $string.= '<a class="button browser" href="#" onclick="'.tep_get_filebroswerserveur('configuration_'.$key).'">'.tep_draw_input_field($name,'configuration_'.$key,$key_value).' '.tep_image(DIR_WS_ICONS . 'icon_browser.png', PARCOURIR_SERVER).'</a>';
  return $string;
}

/**
  Function qui permet de visualiser sans avoir la possibilité de modifé la valeur d'une entree de la table de configuration. Utilisé pour les elements de configuration dynamique
  tep_cfg_Non_Edit([[[$carat_for_saut string (option) caratére séparant chacune des valeurs],$key_value string la(s) valeur(s)], $key string (option) lorsque entrée mutliple])
*/
function tep_cfg_Non_Edit($carat_for_saut='',$key_value, $key = '') {
  $string = '';
  $name = ((tep_not_null($key)) ? 'configuration[' . $key . ']' : 'configuration_value');
  $string .= '<textarea style="width:100%" name="' . $name . '"  disabled="disabled" >' . str_replace($carat_for_saut,"\n",$key_value). '</textarea>';
  $string .= '<input type="hidden" name="' . $name . '" value="' . $key_value. '"  />';
  return $string;
}


/**
  Return une valeur humaine, avec pour arguement une valeur de type string, boolean, ou binaire
*/
function tep_value_for_humain($value){
  if(!tep_not_null($value)) return TXT_NA;
  elseif( (is_string($value) && strtoupper($value)=='TRUE')||( is_bool($value) && $value==TRUE) ||( is_numeric($value) && ($value=='1'|| $value==1)) )  return TXT_ON;
  elseif( (is_string($value) && (strtoupper($value)=='FALSE')||$value=='0')  || ( is_bool($value) && $value==FALSE) || ( is_numeric($value) && ($value=='0'|| $value==0)) ) return TXT_OFF;
  else return htmlspecialchars($value);
}


/**
  Traitement textearea config des modules
*/
function tep_cfg_text_auto($key_value, $key = '') {
  $name = ((tep_not_null($key)) ? 'configuration[' . $key . ']' : 'configuration_value');
  return tep_draw_textarea_field($name,'', 35, 5, $key_value);
}

/* Fonction appele par table configuration */
/**
  Alias function for Store configuration values in the Administration Tool
*/
function tep_cfg_pull_down_country_list($country_id, $key = '') {
  $name = ((tep_not_null($key)) ? 'configuration[' . $key . ']' : 'configuration_value');
  return tep_draw_pull_down_menu($name, tep_get_countries(), $country_id);
}

function tep_cfg_pull_down_zone_list($zone_id, $key = '') {
  $name = ((tep_not_null($key)) ? 'configuration[' . $key . ']' : 'configuration_value');
  return tep_draw_pull_down_menu($name,array_merge(array('id'=>'','text'=>'toute zone'), tep_get_country_zones(STORE_COUNTRY)), $zone_id);
}

/**
  MEnu des class de taxe
*/
function tep_cfg_pull_down_tax_classes($tax_class_id, $key = '') {
  $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
  $tax_class_array = array(array('id' => '0', 'text' => TEXT_NONE));
  $tax_class_query = tep_db_query("select tax_class_id, tax_class_title from " . TABLE_TAX_CLASS . " order by tax_class_title");
  while ($tax_class = tep_db_fetch_array($tax_class_query)) {
      $tax_class_array[] = array('id' => $tax_class['tax_class_id'],
				  'text' => $tax_class['tax_class_title']);
  }

  return tep_draw_pull_down_menu($name, $tax_class_array, $tax_class_id);
}

/**
  Select liste valeur numérique
*/
function tep_cfg_pull_down_num_list($start, $end, $intval, $list_id, $key = '') {
  $name = (tep_not_null($key) ? 'configuration[' . $key . ']' : 'configuration_value');
  for ($list=$start; $list<=$end; $list+=$intval) $list_array[] = array('id' => $list, 'text' => $list);

  return tep_draw_pull_down_menu($name, $list_array, $list_id);
}

/**
  Function to read in text area in admin
*/
function tep_cfg_textarea($text,$key='') {
  $name = ((tep_not_null($key)) ? 'configuration[' . $key . ']' : 'configuration_value');
  return tep_draw_textarea_field($name,$name, 35, 5, $text);
}



function tep_cfg_get_zone_name($zone_id) {
    $zone_query = tep_db_query("select zone_name from " . TABLE_ZONES . " where zone_id = '" . (int)$zone_id . "'");
    if (!tep_db_num_rows($zone_query)) {
        return $zone_id;
    } else {
        $zone = tep_db_fetch_array($zone_query);
        return $zone['zone_name'];
    }
}


function tep_get_order_status_name($order_status_id, $language_id = '') {
    global $languages_id;

    if ($order_status_id < 1) return TEXT_DEFAULT;

    if (!is_numeric($language_id)) $language_id = $languages_id;

    $status_query = tep_db_query("select status_name from " . TABLE_STATUS . " where status_type='orders' and status_id = '" . (int)$order_status_id . "' and language_id = '" . (int)$language_id . "'");
    $status = tep_db_fetch_array($status_query);

    return $status['status_name'];
}

/**
  Alias function for module configuration keys Retour d'un tableau des code des devsie installé
*/
function tep_currencie_in_db($cur=false){
    $currency_query_raw = "select currencies_id, title, code, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places, last_updated, value from " . TABLE_CURRENCIES . " order by title";
    $i=0;
    $currency_query = tep_db_query($currency_query_raw);
    while ($currency = tep_db_fetch_array($currency_query)){
        if($cur!=false && $cur==$currency['code']) return $currency['title'];
        $sortie[$currency['code']]=$currency['title'];
    }

    return $sortie;
}

/**
  Alias function for module configuration keys Retour d'un tableau des code de langue installé
*/
function tep_lg_installed($lg=false){
    $languages=tep_get_languages();
    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
        if($lg!=false && $lg==$languages[$i]['code']) return $languages[$i]['name'];
        $sortie[$languages[$i]['code']]=$languages[$i]['name'];
    }
    return $sortie;
}

/**
  Alias function for module configuration keys Retour d'un tableau des codes de status de commande installé
*/
function tep_status_in_db($etat=false){
    $tabl=tep_get_status_array('orders');
    for ($i=0, $n=sizeof($tabl); $i<$n; $i++) {
        if($etat!=false && $etat==$tabl[$i]['id']) return $tabl[$i]['text'];
        $sortie[$i+1]=$tabl[$i]['text'];
    }
    print_r($sortie);
    return $sortie;
}


/**
    @package QTPro
    @author OscssTeam
    @version 4.1
    @note  Function to build menu of available class files given a file prefix
  Used for configuring plug-ins for product information attributes
*/
function tep_cfg_pull_down_class_files($prefix, $current_file) {
  $d=DIR_FS_CATALOG . DIR_WS_CLASSES;
  $function_directory = dir ($d);

  while (false !== ($function = $function_directory->read())) {
    if (preg_match('/^'.$prefix.'(.+)\.php$/',$function,$function_name)) {
      $file_list[]=array('id'=>$function_name[1], 'text'=>$function_name[1]);
    }
  }
  $function_directory->close();

  return tep_draw_pull_down_menu('configuration[PRODINFO_ATTRIBUTE_PLUGIN]', $file_list, $current_file);
}


function tep_get_multiple_order_status_names($values, $language_id = '') {
  global $languages_id;
  $order_status_names = "";

  $order_statuses = unserialize($values);
  if(is_array($order_statuses) && 0 != count($order_statuses)) {
  if (!is_numeric($language_id)) $language_id = $languages_id;

  $status_query = tep_db_query("select status_name from " . TABLE_STATUS . " where  status_type='orders' and status_id IN (" . implode($order_statuses, ',') . ") and language_id = '" . (int)$language_id . "'");
    while($status = tep_db_fetch_array($status_query))   $order_status_names .= $status['status_name'] . ', ';
  }

  return trim($order_status_names, ', ');
}

function tep_cfg_pull_down_multiple_order_statuses($order_status_id, $key = '') {
  global $languages_id;

  $name = (($key) ? 'configuration[' . $key . '][]' : 'configuration_value[]');

  $statuses_array = array(array('id' => '0', 'text' => TEXT_DEFAULT));
  $statuses_query = tep_db_query("select status_id, status_name from " . TABLE_STATUS . " where  status_type='orders' and  language_id = '" . (int)$languages_id . "' order by status_name");
  while ($statuses = tep_db_fetch_array($statuses_query)) $statuses_array[] = array('id' => $statuses['status_id'], 'text' => $statuses['status_name']);

  return tep_draw_pull_down_menu($name, $statuses_array, $order_status_id, "multiple");
}


/**
  @package oscss
  @author oscim - OscssTeam
*/
function tep_cfg_pull_down_order_statuses($order_status_id, $key = '') {
  global $languages_id;
  $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
  $statuses_array = array(array('id' => '0', 'text' => TEXT_DEFAULT));
  $statuses_query = tep_db_query("select status_id, status_name from " . TABLE_STATUS . " where status_type='orders' and language_id = '" . (int)$languages_id . "' order by status_name");
  while ($statuses = tep_db_fetch_array($statuses_query)) {
    $statuses_array[] = array('id' => $statuses['status_id'],'text' => $statuses['status_name']);
  }
  return tep_draw_pull_down_menu($name, $statuses_array, $order_status_id);
}




/**
  Convertion clef config en dir
*/
function ConvertKeyDir($key){
  $code_inistalletd_array['MODULE_ORDER_TOTAL_INSTALLED']=DIR_FS_CATALOG.DIR_WS_MODULES.'order_total/';
  $code_inistalletd_array['MODULE_PAYMENT_INSTALLED']=DIR_FS_CATALOG.DIR_WS_MODULES.'payment/';
  $code_inistalletd_array['MODULE_SHIPPING_INSTALLED']=DIR_FS_CATALOG.DIR_WS_MODULES.'shipping/';
  $code_inistalletd_array['MODULE_CHECKOUT_PROCESS_INSTALLED']=DIR_FS_CATALOG.DIR_WS_MODULES.'process/';

  $code_inistalletd_array['MODULE_GENERIC_INSTALLED']=DIR_FS_CATALOG.DIR_WS_MODULES.'generic/';
  $code_inistalletd_array['MODULE_GENERIC_INSTALLED_BO']=DIR_FS_ADMIN.DIR_WS_MODULES.'generic/';

  $code_inistalletd_array['MODULE_ACAPRO_INSTALLED']=DIR_FS_CATALOG.DIR_WS_MODULES.'products/';
  $code_inistalletd_array['MODULE_ACAPRO_INSTALLED_BO']=DIR_FS_ADMIN.DIR_WS_MODULES.'products/';

  $code_inistalletd_array['MODULE_CONTENT_INSTALLED']=DIR_FS_CATALOG.DIR_WS_MODULES.'content/';
  $code_inistalletd_array['MODULE_CONTENT_INSTALLED_BO']=DIR_FS_ADMIN.DIR_WS_MODULES.'content/';

  $code_inistalletd_array['MODULE_ACACAT_INSTALLED']=DIR_FS_CATALOG.DIR_WS_MODULES.'categories/';
  $code_inistalletd_array['MODULE_ACACAT_INSTALLED_BO']=DIR_FS_ADMIN.DIR_WS_MODULES.'categories/';

  $code_inistalletd_array['MODULE_ACCOUNT_INSTALLED']=DIR_FS_CATALOG.DIR_WS_MODULES.'account/';
  $code_inistalletd_array['MODULE_ACCOUNT_INSTALLED_BO']=DIR_FS_ADMIN.DIR_WS_MODULES.'account/';

  $code_inistalletd_array['MODULE_LISTING_INSTALLED']=DIR_FS_CATALOG.DIR_WS_MODULES.'listing/';
  $code_inistalletd_array['MODULE_LISTING_INSTALLED_BO']=DIR_FS_ADMIN.DIR_WS_MODULES.'listing/';

  $code_inistalletd_array['MODULE_HOME_INSTALLED']=DIR_FS_CATALOG.DIR_WS_MODULES.'home/';
  $code_inistalletd_array['MODULE_HOME_INSTALLED_BO']=DIR_FS_ADMIN.DIR_WS_MODULES.'home/';

  if(isset($code_inistalletd_array[$key])) return $code_inistalletd_array[$key];
  return '';
}


/**
  Add element dans la config non deja actif
  Specific element config info concatene avec ";"
  @param
    @a string le clef de config
    @a string le nom du fichier avec extension
*/
function AddConfigInKey($key, $value_add){
  $DB=Database::getInstance();
  $res=$DB->query($sql="SELECT configuration_value FROM " . TABLE_CONFIGURATION . "  where configuration_key = '".$key."'");
  $value=$res->fetchAssoc();
  if(!in_array( $value ,explode(';',$value['configuration_value'])))
    $DB->query($sql="update " . TABLE_CONFIGURATION . " set configuration_value = '".trim($value['configuration_value'].tep_db_prepare_input($value_add)).";', last_modified = now() where configuration_key = '".$key."'");

}

/**
  Up element dans la config
  @param
    @a string le clef de config
    @a string la avlue
*/
function UpConfigKey($key, $value){
  $DB=Database::getInstance();
  $DB->query($sql="update " . TABLE_CONFIGURATION . " set configuration_value = '".tep_db_prepare_input($value)."', last_modified = now() where configuration_key = '".$key."'");
}

function ResetConfigKey($key){
  $DB=Database::getInstance();
  $DB->query($sql="update " . TABLE_CONFIGURATION . " set configuration_value = '', last_modified = now() where configuration_key = '".$key."'");
}

/**
  Add element dans la config des moduel actif, apres control si existe et non deja actif
  @param
    @a string le clef de config
    @a string le nom du fichier avec extension
*/
function addConfigModule($key, $value_add){
  if(!file_exists(ConvertKeyDir($key).$value_add)) return false;
  AddConfigInKey($key, $value_add);
}

/**
  Comptabilite packahe pre-installé, mise a niveau de la table des paquaets
  Fichier configuration.php
*/
function LibConf_UpPackageBD($cip_name,$Ident,$Version='1.0.0'){
  $DB=Database::getInstance();

  //! control db etat
  $result=$DB->query("select cip_id, cip_installed from ".TABLE_CIP. " where cip_folder_name='".$cip_name."'; ");
  $installed=$result->fetchAssoc();

  //! Register CIP in database:
  if (!isset($installed['cip_id'])) $DB->query("insert into ".TABLE_CIP." (cip_id, cip_folder_name, cip_installed, cip_ident, cip_version) values ('', '".$cip_name."', '1', '".$Ident."','".$Version."')");
  else $DB->query("update ".TABLE_CIP." set  cip_installed='1' WHERE cip_folder_name= '".$cip_name."' AND cip_ident= '".$Ident."' AND cip_version='".$Version."' ");
}
?>