<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  19/12/10, 19:49
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

/**
  @author OscssTeam
  @version 1.2
  @note Se charge de produire l'affichage de retour , pour le prise en compte des attributs d'un produits
*/
function tep_draw_attribute_products($order,$i){
  global $currencies;
  if (isset($order->products[$i]['attributes']) && (sizeof($order->products[$i]['attributes']) > 0)) {
    for ($j = 0, $k = sizeof($order->products[$i]['attributes']); $j < $k; $j++) {
      echo '<br /><nobr><small>&nbsp;<i> - ' . $order->products[$i]['attributes'][$j]['option'] . ': ' . $order->products[$i]['attributes'][$j]['value'];
      if ($order->products[$i]['attributes'][$j]['price'] != '0') echo ' (' . $order->products[$i]['attributes'][$j]['prefix'] . $currencies->format($order->products[$i]['attributes'][$j]['price'] * $order->products[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']) . ')';
      echo '</i></small></nobr>';
    }
  }
}

/**
  @package oscss-major
  @author oscim <mail a@oscim.fr /><web http://www.oscim.fr />

  Gestion suppression d'une order
*/
function delete_order($oID){
  $_oID = tep_db_prepare_input($oID);
  $check_status_query = tep_db_query("select customers_id from " . TABLE_ORDERS . " where orders_id = '" . (int)$_oID . "'");
  $check = tep_db_fetch_array($check_status_query);

  tep_remove_order($_oID, $_POST['restock'], $check['customers_id']);
}



/**
  Gestion des evolution du status d'une commandes
  @package oscss-major
  @author oscim <mail a@oscim.fr /><web http://www.oscim.fr />
  @param
    @a array post array(status,comments, notify, notify_comments, comments )
*/
function up_status_order($oID,$post){
  global $language, $orders_status_array;
  $_oID = tep_db_prepare_input($oID);
  $status = tep_db_prepare_input($post['status']);
  $comments = tep_db_prepare_input($post['comments']);

  $check_status_query = tep_db_query("select customers_id, customers_name, customers_email_address, orders_status, date_purchased, ip_address from " . TABLE_ORDERS . " where orders_id = '" . (int)$_oID . "'");
  $check_status = tep_db_fetch_array($check_status_query);

  if ( ($check_status['orders_status'] != $status) || tep_not_null($comments)) {

    if((int)DEFAULT_ORDERS_STATUS_COMPLETED ===(int)$status){
      $_query = tep_db_query("select count(*) as _id from " . TABLE_ORDERS . " where orders_date_finished IS NOT NULL ");
      $res_id=tep_db_fetch_array($_query);
      //! cloture commande
      tep_db_query("update " . TABLE_ORDERS . " set orders_status = '" . tep_db_input($status) . "', last_modified = now(), orders_date_finished = now(), facture_id='".((int)$res_id['_id'] +1)."'  where orders_id = '" . (int)$_oID . "'");
    }else
      tep_db_query("update " . TABLE_ORDERS . " set orders_status = '" . tep_db_input($status) . "', last_modified = now() where orders_id = '" . (int)$_oID . "'");

    $customer_notified = '0';
    if (isset($_POST['notify']) && ($post['notify'] == 'on')) {
      $notify_comments = '';
      if (isset($_POST['notify_comments']) && ($post['notify_comments'] == 'on')) {
        $notify_comments = $comments . "\n\n";
      }

      $myarray = array(
                      'mail_sent_to'=>$check_status['customers_email_address'],
                      'from'=>STORE_OWNER,
                      'subject'=>'',
                      '_oID'=>$_oID,
                      'date_purchased'=>tep_date_long($check_status['date_purchased']),
                      'notify_comments'=>$notify_comments,
                      '_ostatus'=>$orders_status_array[$status],
                      '_oLinks'=>tep_catalog_href_link(FILENAME_CATALOG_ACCOUNT_HISTORY_INFO, 'order_id=' . $_oID, 'SSL'),
                      'email_use_html'=>_cst_bool('EMAIL_USE_HTML'),
                      'message'=>'',
                      );

      $message_final=tep_post_prepare_email('orders.tpl',$language,$myarray);

      if( tep_mail($check_status['customers_name'], $check_status['customers_email_address'], EMAIL_TEXT_SUBJECT, $message_final) !=false) $customer_notified = '1';
    }

    tep_db_query("insert into " . TABLE_ORDERS_STATUS_HISTORY . " (orders_id, orders_status_id, date_added, customer_notified, comments) values ('" . (int)$_oID . "', '" . tep_db_input($status) . "', now(), '" . tep_db_input($customer_notified) . "', '" . tep_db_input($comments)  . "')");

    return true;
  }
  else  return null;
}

?>