<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  19/12/10, 19:46
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

/**
  @author  OscssTeam
  Construit la sortie du chemin (fil arine ) de la catégory sous forme texte
*/
function tep_output_generated_category_path($id, $from = 'category') {
    $calculated_category_path_string = 'racine &nbsp;&gt;&nbsp;';
    $calculated_category_path = tep_generate_category_path($id, $from);
    for ($i=0, $n=sizeof($calculated_category_path); $i<$n; $i++) {
      for ($j=0, $k=sizeof($calculated_category_path[$i]); $j<$k; $j++) {
        $calculated_category_path_string .= $calculated_category_path[$i][$j]['text'] . '&nbsp;&gt;&nbsp;';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -16) ;
    }
//     $calculated_category_path_string = substr($calculated_category_path_string, 0, -4);

    if (strlen($calculated_category_path_string) < 1) $calculated_category_path_string = TEXT_TOP;

    return $calculated_category_path_string;
}





/**
  @author  OscssTeam
  Return l'id de
*/
function tep_get_path($current_category_id = '') {
  global $cPath_array;

  if ($current_category_id == '')  $cPath_new = implode('_', $cPath_array);
  else {
    if (sizeof($cPath_array) == 0)  $cPath_new = $current_category_id;
    else {
      $cPath_new = '';
      $last_category_query = tep_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$cPath_array[(sizeof($cPath_array)-1)] . "'");
      $last_category = tep_db_fetch_array($last_category_query);

      $current_category_query = tep_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$current_category_id . "'");
      $current_category = tep_db_fetch_array($current_category_query);

      if ($last_category['parent_id'] == $current_category['parent_id'])
        for ($i = 0, $n = sizeof($cPath_array) - 1; $i < $n; $i++)  $cPath_new .= '_' . $cPath_array[$i];
      else
        for ($i = 0, $n = sizeof($cPath_array); $i < $n; $i++)  $cPath_new .= '_' . $cPath_array[$i];

      $cPath_new .= '_' . $current_category_id;

      if (substr($cPath_new, 0, 1) == '_')  $cPath_new = substr($cPath_new, 1);
    }
  }

  return 'cPath=' . $cPath_new;
}




/**
 Count how many products exist in a category
 TABLES: products, products_to_categories, categories
*/
function tep_products_in_category_count($categories_id, $include_deactivated = false) {
  $products_count = 0;

  if ($include_deactivated)  $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p2c.categories_id = '" . (int)$categories_id . "'");
  else  $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p.products_status = '1' and p2c.categories_id = '" . (int)$categories_id . "'");

  $products = tep_db_fetch_array($products_query);

  $products_count += $products['total'];

  $childs_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$categories_id . "'");
  if (tep_db_num_rows($childs_query))
    while ($childs = tep_db_fetch_array($childs_query))  $products_count += tep_products_in_category_count($childs['categories_id'], $include_deactivated);

  return $products_count;
}


/**
  @author OscssTeam
*/
function tep_get_products_url($product_id, $language_id) {
  $product_query = tep_db_query("select products_url from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language_id . "'");
  $product = tep_db_fetch_array($product_query);

  return $product['products_url'];
}


/**
  @author OscssTeam
*/
function tep_get_products_description($product_id, $language_id) {
  $product_query = tep_db_query("select products_description from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language_id . "'");
  $product = tep_db_fetch_array($product_query);

  return $product['products_description'];
}


/**
  Construction contenu du pulldown des manufacturers
  @author oscim
  @version 1.4
  utilisé pour recharger ajax
*/
function in_manufacturers($selected='',$print=true) {
  $manufacturers_array = $sortie='';
  $manufacturers_query = tep_db_query("select manufacturers_id, manufacturers_name from " . TABLE_MANUFACTURERS . " order by manufacturers_name");
  while ($manufacturers = tep_db_fetch_array($manufacturers_query)) {
    $manufacturers_array[] = array('id' => $manufacturers['manufacturers_id'],'text' => $manufacturers['manufacturers_name']);
    if ($selected==$manufacturers['manufacturers_id']) $sortie .='<option value="'.$manufacturers['manufacturers_id'].'" selected="selected">'.$manufacturers['manufacturers_name'].'</option>';
    else $sortie .='<option value="'.$manufacturers['manufacturers_id'].'">'.$manufacturers['manufacturers_name'].'</option>';
  }

  if ($print) echo $sortie;
  else return $manufacturers_array;
}

?>