<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  19/12/10, 19:49
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

if (STORE_SESSIONS == 'mysql') {

  if (constant('SESSION_LIFE_ADMIN') =='') $SESS_LIFE = 1440;
  else $SESS_LIFE = (SESSION_LIFE_ADMIN*60);

  function _sess_open($save_path, $session_name) {
    return true;
  }

  function _sess_close() {
    return true;
  }

  function _sess_read($key) {
    $DB=Database::getInstance();
    $qid = $DB->query("select value from " . TABLE_SESSIONS . " where sesskey = '" . tep_db_input($key) . "' and expiry > '" . time() . "'");

    if($qid !=false) {
      $value=$qid->fetchAssoc();

      if ($value['value'])  return $value['value'];
    }
    return false;
  }

  function _sess_write($key, $val) {
    global $SESS_LIFE;
    $DB=Database::getInstance();
    $expiry = time() + $SESS_LIFE;
    $value = $val;

    $qid = $DB->query("select count(*) as total from " . TABLE_SESSIONS . " where sesskey = '" . tep_db_input($key) . "'");
    $total = $qid->fetchAssoc();

    if ($total['total'] > 0) {
      $DB->query("update " . TABLE_SESSIONS . " set expiry = '" . tep_db_input($expiry) . "', value = '" . tep_db_input($value) . "' where sesskey = '" . tep_db_input($key) . "'");
      return true;
    } else {
      $DB->query("insert into " . TABLE_SESSIONS . " values ('" . tep_db_input($key) . "', '" . tep_db_input($expiry) . "', '" . tep_db_input($value) . "')");
      return true;
    }
  }

  function _sess_destroy($key) {
    $DB=Database::getInstance();
    $DB->query("delete from " . TABLE_SESSIONS . " where sesskey = '" . tep_db_input($key) . "'");
    return true;
  }

  function _sess_gc($maxlifetime) {
    $DB=Database::getInstance();
    $DB->query("delete from " . TABLE_SESSIONS . " where expiry < '" . time() . "'");

    return true;
  }

  session_set_save_handler('_sess_open', '_sess_close', '_sess_read', '_sess_write', '_sess_destroy', '_sess_gc');
}

  function tep_session_start() {
    $success = session_start();
    // session variables
    if ($success && count($_SESSION))
    {
      $session_keys = array_keys($_SESSION);
      foreach($session_keys as $variable)
      {
        link_session_variable($variable, true);
      }
    }

    return $success;
  }

  function tep_session_register($variable) {
    // Work-around to allow disabling of register_globals - map session variable
    link_session_variable($variable, true);

    return true;
  }

  function tep_session_is_registered($variable) {
  if( is_string($variable) || is_int($variable) ) {
    if ( isset($_SESSION) && array_key_exists($variable,$_SESSION) ) {
        return true;
    } else {
        return false;
    }
  }
  }

  function tep_session_unregister($variable) {
    link_session_variable($variable, false);
    unset($_SESSION[$variable]);

    return true;
  }


  /**
  @package oscss
  @author OscssTeam
  @param string var_name - Name of session variable
  @param boolean map - true = map variable, false = unmap varaible
  @return none
  @note:  Work-around function to allow disabling of register_globals in php.ini
    This is pretty crude but it works. What it does is map session variables to
    a corresponding global variable.
    In this way, the main application code can continue to use the existing
    global varaible names but they are actually redirected to the real session
    variables
    If the global variable is already set with a value at the time of the mapping
    then it is copied over to the real session variable before being mapped back
    again
  */
  function link_session_variable($var_name, $map)
  {
    if ($map){
      if (array_key_exists($var_name,$GLOBALS)) {
        $_SESSION[$var_name] =& $GLOBALS[$var_name];
      } else {
        $GLOBALS[$var_name] =& $_SESSION[$var_name];
      }

    } else {
      // Unmap global from session variable. Note that the global variable keeps the value of
      // the session variable. This should be unnecessary but it reflects the same behaviour
      // as having register_globals enabled, so in case the OSC code assumes this behaviour,
      // it is reproduced here
      $nothing = 0;
      $GLOBALS[$var_name] =& $nothing;
      unset($GLOBALS[$var_name]);
      $GLOBALS[$var_name] = $_SESSION[$var_name];
    }
  }


  /**
  @package oscss
  @author OscssTeam
  */
  function tep_session_id($sessid = '') {
    if ($sessid != '')  return session_id($sessid);
    else  return session_id();
  }

  /**
  @package oscss
  @author OscssTeam
  */
  function tep_session_name($name = '') {
    if ($name != '') return session_name($name);
    else return session_name();
  }

  /**
  @package oscss
  @author OscssTeam
  */
  function tep_session_close() {
    if (count($_SESSION)){
      $session_keys = array_keys($_SESSION);
      foreach($session_keys as $variable){
        link_session_variable($variable, false);
      }
    }

    if (function_exists('session_write_close'))
      @session_write_close();
  }

  /**
  @author oscim - OscssTeam
  @version 1.0
  @note Force la suppression des var de session, y compris cookies
  */
  function tep_session_destroy() {
    // session variables
    if (count($_SESSION)) {
      $session_keys = array_keys($_SESSION);
      foreach($session_keys as $variable)
      {
        link_session_variable($variable, false);
        unset($_SESSION[$variable]);
      }
    }

    if (isset($_COOKIE[tep_session_name()]))
      setcookie(tep_session_name(), '', time()-42000, '/');

    return @session_destroy();
  }


  /**

  @author oscim - OscssTeam
  @note save session in file
  */
  function tep_session_save_path($path = DIR_FS_SESSIONS) {
    if (STORE_SESSIONS == 'mysql') return false;
    if (!empty($path)) return session_save_path($path);
    else  return session_save_path();
  }


  /**

  @author oscim - OscssTeam
  @note Force la regeneration de l'id de session lors connexion
  */
  function tep_session_regenerate($sid){
      session_regenerate_id();
      tep_session_destroy_file($sid);
  }


  /**

  @author oscim - OscssTeam
  @note Force suppression fichier session
  */
  function tep_session_destroy_file($sid){
    if (tep_session_save_path() != DIR_FS_SESSIONS) @unlink(tep_session_save_path().'/sess_'.$sid);
  }
?>
