<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  09/12/10, 17:23
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @brief master file for languages
*/

//Admin begin
// header text in includes/header.php
define('HEADER_TITLE_ACCOUNT', 'Mon compte');
define('HEADER_TITLE_LOGOFF', 'Fermeture session');

// Admin Account
define('BOX_HEADING_MY_ACCOUNT', 'Mon compte');


if(function_exists('date_default_timezone_set')) date_default_timezone_set('Europe/Paris');

// look in your $PATH_LOCALE/locale directory for available locales..
// on RedHat6.0 I used 'en_US'
// on FreeBSD 4.0 I use 'en_US.UTF-8'
// this may not work under win32 environments..
setlocale(LC_TIME, 'fr_FR.UTF-8');
define('DATE_FORMAT_SHORT', '%d/%m/%Y');  // this is used for tep_strftime()
define('DATE_FORMAT_LONG', '%A %d %B, %Y'); // this is used for tep_strftime()
define('DATE_FORMAT', 'd/m/Y'); // this is used for date()
define('PHP_DATE_TIME_FORMAT', 'd/m/Y H:i:s'); // this is used for date()
define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');

////
// Return date in raw format
// $date should be in format dd/mm/yyyy
// raw date is in format YYYY-MM-DD, or DD-MM-YYYY
function tep_date_raw($date, $reverse = false) {
  if ($reverse) {
    return substr($date, 0, 2) .'-'. substr($date, 3, 2) .'-'. substr($date, 6, 4);
  } else {
    return substr($date, 6, 4) .'-'. substr($date, 3, 2) .'-'. substr($date, 0, 2);
  }
}

// Liste du nom des mois version française //
define('NameOf_MONTH_01', 'janvier');
define('NameOf_MONTH_02', 'février');
define('NameOf_MONTH_03', 'mars');
define('NameOf_MONTH_04', 'avril');
define('NameOf_MONTH_05', 'mai');
define('NameOf_MONTH_06', 'juin');
define('NameOf_MONTH_07', 'juillet');
define('NameOf_MONTH_08', 'août');
define('NameOf_MONTH_09', 'septembre');
define('NameOf_MONTH_10', 'octobre');
define('NameOf_MONTH_11', 'novembre');
define('NameOf_MONTH_12', 'décembre');
define('NameOf_MONTH_MINI_01', 'jan.');
define('NameOf_MONTH_MINI_02', 'fév.');
define('NameOf_MONTH_MINI_03', 'mar.');
define('NameOf_MONTH_MINI_04', 'avr.');
define('NameOf_MONTH_MINI_05', 'mai');
define('NameOf_MONTH_MINI_06', 'juin');
define('NameOf_MONTH_MINI_07', 'juil.');
define('NameOf_MONTH_MINI_08', 'août');
define('NameOf_MONTH_MINI_09', 'sept.');
define('NameOf_MONTH_MINI_10', 'oct.');
define('NameOf_MONTH_MINI_11', 'nov.');
define('NameOf_MONTH_MINI_12', 'déc.');
// --- //

// Liste du nom des jours version française //
define('NameOf_DAY_1', 'lundi');
define('NameOf_DAY_2', 'mardi');
define('NameOf_DAY_3', 'mercredi');
define('NameOf_DAY_4', 'jeudi');
define('NameOf_DAY_5', 'vendredi');
define('NameOf_DAY_6', 'samedi');
define('NameOf_DAY_0', 'dimanche');
define('NameOf_DAY_MINI_1', 'lun.');
define('NameOf_DAY_MINI_2', 'mar.');
define('NameOf_DAY_MINI_3', 'mer.');
define('NameOf_DAY_MINI_4', 'jeu.');
define('NameOf_DAY_MINI_5', 'ven.');
define('NameOf_DAY_MINI_6', 'sam.');
define('NameOf_DAY_MINI_0', 'dim.');
// --- //

// Global entries for the <html> tag
define('HTML_PARAMS','dir="ltr" lang="fr"');

// charset for web pages and emails
define('CHARSET', 'utf-8');

// page title
define('TITLE', STORE_NAME);

// Class to select and format correct product price
define('TAX_SYMBOL','TTC');
define('NOTAX_SYMBOL','HT');

// header text in includes/header.php
// define('HEADER_TITLE_TOP', 'Administration');
define('HEADER_TITLE_SUPPORT_SITE', 'Site officiel');
define('HEADER_TITLE_ONLINE_CATALOG', 'Visiter la boutique');
define('HEADER_TITLE_ADMINISTRATION', 'Administration');

// text for gender
define('MALE', 'Mr');
define('FEMALE', 'Mme');
define('MLLE', 'Mlle');

// text for date of birth example
define('DOB_FORMAT_STRING', 'jj/mm/aaaa');

// configuration box text in includes/boxes/configuration.php


define('BOX_CONFIGURATION_LOGGING', 'Enregistrement');

define('BOX_HEADING_CONF_PARAMETERS', 'Paramètres');
/** TODO: delete */define('BOX_ZONE_AND_TAXE', 'Taxe / Zone');
/** TODO: delete */define('BOX_HEADING_LOCATION_AND_TAXES', 'Lieux / Taxes');



define('BOX_HEADING_COMMANDE', 'Commandes');

// tools text in includes/boxes/tools.php
define('BOX_INFO', 'Informations');
define('BOX_HEADING_REPORTS', 'Rapports');


define('TEXT_NO_SALES', 'Aucune vente :(');
define('TXT_ON', 'Actif');
define('TXT_OFF', 'Inactif');
define('TXT_NA', 'N/A');

//osCMS
define('TEXT_DISPLAY_NUMBER_OF_CONTENT', 'Affichage <strong>%d</strong> de <strong>%d</strong> (sur <strong>%d</strong> contenus)');


define('NEWS', 'News');
define('NEW_ARTICLE', 'New Article');

// javascript messages
define('JS_ERROR', 'Des erreurs sont survenues durant le traitement de votre formulaire !\nMerci de faire les corrections suivantes :\n\n');

define('JS_OPTIONS_VALUE_PRICE', '* Le nouveau attribut produit nécessite un prix\n');
define('JS_OPTIONS_VALUE_PRICE_PREFIX', '* Le nouveau attribut produit nécessite un préfixe de prix\n');

define('JS_PRODUCTS_NAME', '*  Le nouveau produit nécessite un nom\n');
define('JS_PRODUCTS_DESCRIPTION', '* Le nouveau produit nécessite une description\n');
define('JS_PRODUCTS_PRICE', '* Le nouveau produit nécessite un prix\n');
define('JS_PRODUCTS_WEIGHT', '* Le nouveau produit nécessite un poids\n');
define('JS_PRODUCTS_QUANTITY', '* Le nouveau produit nécessite une quantité\n');
define('JS_PRODUCTS_MODEL', '* Le nouveau produit nécessite un modèle\n');
define('JS_PRODUCTS_IMAGE', '* Le nouveau produit nécessite une image\n');

define('JS_SPECIALS_PRODUCTS_PRICE', '* Un nouveau prix pour ce produit doit être fixé\n');


define('JS_POST_CODE', '* L\'entrée \'Code postal\' doit avoir au moins ' . ENTRY_POSTCODE_MIN_LENGTH . ' caractères.\n');
define('JS_STATE', '* L\'entrée \'Etat\' doit avoir été choisie.\n');
define('JS_STATE_SELECT', '-- Choisissez ci-dessus --');
define('JS_ZONE', '* L\'entrée \'Etat\' doit être choisie parmi la liste pour ce pays.');
define('JS_COUNTRY', '* La valeur \'Pays\' doit être choisie.\n');
define('JS_TELEPHONE', '* L\'entrée \'Numéro de téléphone\' doit avoir au moins ' . ENTRY_TELEPHONE_MIN_LENGTH . ' caractères.\n');
define('JS_PASSWORD', '* Les entrées \'Mot de passe\' et \'Confirmation\' doivent avoir au moins ' . ENTRY_PASSWORD_MIN_LENGTH . ' caractères.\n');

define('JS_ORDER_DOES_NOT_EXIST', 'Le numéro de commande %s n\'existe pas !');

define('ENTRY_EMAIL_ADDRESS', 'Adresse électronique :');

// images
define('IMAGE_ANI_SEND_EMAIL', 'Envoyer un courrier électronique');
define('IMAGE_BACK', 'Retour');
define('IMAGE_CANCEL', 'Annuler');
define('IMAGE_CONFIRM', 'Confirmer');
define('IMAGE_VALID', 'Valider');
define('IMAGE_COPY', 'Copier');
define('IMAGE_COPY_TO', 'Copier vers');
define('IMAGE_DETAILS', 'Détails');
define('IMAGE_DELETE', 'Supprimer');
define('IMAGE_EDIT', 'Éditer');
define('IMAGE_EMAIL', 'Courrier électronique');
define('IMAGE_FILE_MANAGER', 'Gestionnaire de fichiers');
define('IMAGE_ICON_STATUS_GREEN', 'Actif');
define('IMAGE_ICON_STATUS_GREEN_LIGHT', 'Activer');
define('IMAGE_ICON_STATUS_RED', 'Inactif');
define('IMAGE_ICON_STATUS_RED_LIGHT', 'Désactiver');
define('IMAGE_ICON_INFO', 'Info');
define('IMAGE_INSERT', 'Insérer');
define('IMAGE_LOCK', 'Verrouiller');
define('IMAGE_MODULE_INSTALL', 'Installez le module');
define('IMAGE_MODULE_REMOVE', 'Supprimer le module');
define('IMAGE_MOVE', 'Déplacer');
define('IMAGE_NEW', 'Nouveau');
define('IMAGE_NEW_BANNER', 'Nouvelle bannière');
define('IMAGE_NEW_CATEGORY', 'Nouvelle catégorie');
define('IMAGE_NEW_COUNTRY', 'Nouveau pays');
define('IMAGE_NEW_FILE', 'Nouveau fichier');
define('IMAGE_NEW_FOLDER', 'Nouveau dossier');
define('IMAGE_NEW_LANGUAGE', 'Nouvelle Langue');
define('IMAGE_NEW_NEWSLETTER', 'Nouveau bulletin d\'informations');
define('IMAGE_NEW_PRODUCT', 'Nouveau Produit');
define('IMAGE_NEW_TAX_CLASS', 'Nouvelle classe fiscale');
define('IMAGE_NEW_TAX_RATE', 'Nouveau taux fiscal');
define('IMAGE_NEW_TAX_ZONE', 'Nouvelle zone fiscale/livraison');
define('IMAGE_NEW_ZONE', 'Nouvelle zone');
define('IMAGE_ORDERS', 'Commandes');
define('IMAGE_ORDERS_MIN', 'Cmd');
define('IMAGE_HELD_ORDERS', 'Récupération de Commandes');
define('IMAGE_ORDERS_INVOICE', 'Facture');
define('IMAGE_ORDERS_INVOICE_MIN', 'F');
define('IMAGE_ORDERS_PACKINGSLIP', 'Bon de commande');
define('IMAGE_ORDERS_PACKINGSLIP_MIN', 'BL');
define('IMAGE_PREVIEW', 'Prévisualiser');
define('IMAGE_VIEW', 'Voir');
define('IMAGE_RESET', 'Réinitialiser');
define('IMAGE_SAVE', 'Sauvegarder');
define('IMAGE_SEARCH', 'rechercher');
define('IMAGE_SELECT', 'Choisir');
define('IMAGE_SEND', 'Envoyer');
define('IMAGE_SEND_EMAIL', 'Envoyer un courrier électronique');
define('IMAGE_SEND_EMAIL_MIN', 'Mail');
define('IMAGE_UNLOCK', 'Déverrouiller');
define('IMAGE_UPDATE', 'Mettre à jour');
define('IMAGE_UPDATE_CURRENCIES', 'Mettre à jour le taux de change');
define('IMAGE_UPLOAD', 'Transférer');
define('IMAGE_UPDATE_AND_CLOSE', 'Enregistrer et fermer');
define('IMAGE_VERSION_FOR_PRINT', 'Imprimer cette page');
define('IMAGE_VERSION_FOR_PDF', 'pdf');
define('IMAGE_ADD', 'Ajouter');
define('IMAGE_SORT', 'Tri');
define('IMAGE_FILE_PERMISSION', 'Permission de dossier');
define('IMAGE_GROUPS', 'Liste des groupes');
define('IMAGE_MEMBERS', 'Liste des membres');
define('IMAGE_NEW_GROUP', 'Nouveau groupe');
define('IMAGE_NEW_MEMBER', 'Nouveau membres');
define('IMAGE_NEXT', 'Suivant');
define('IMAGE_TRACKED_LOW_STOCK', 'Suivre stock bas');

define('ICON_CROSS', 'Faux');
define('ICON_CURRENT_FOLDER', 'Dossier courant');
define('ICON_DELETE', 'Supprimer');
define('ICON_ERROR', 'Erreur');
define('ICON_FILE', 'Fichier');
define('ICON_FILE_DOWNLOAD', 'Télécharger');
define('ICON_FOLDER', 'Dossier');
define('ICON_LOCKED', 'Verrouillé');
define('ICON_PREVIOUS_LEVEL', 'Niveau précédent');
define('ICON_PREVIEW', 'Prévisualiser');
define('ICON_STATISTICS', 'Statistiques');
define('ICON_SUCCESS', 'Succès');
define('ICON_TICK', 'Vrai');
define('ICON_UNLOCKED', 'Déverrouillé');
define('ICON_WARNING', 'Attention');

// constants for use in tep_prev_next_display function
define('TEXT_RESULT_PAGE', 'Page %s sur %d');
define('TEXT_MAXI_ROW_BY_PAGE', 'Voir %s lignes');
define('TEXT_FILTRED_ON', '(filtré par %s enregistrements)');
define('TEXT_DISPLAY_NUMBER_OF', 'Affiche <strong>%s</strong> à <strong>%s</strong> sur <strong>%s</strong>');

define('PREVNEXT_BUTTON_PREV', '&lt;&lt;');
define('PREVNEXT_BUTTON_NEXT', '&gt;&gt;');

define('TEXT_DEFAULT', 'défaut');
define('TEXT_SET_DEFAULT', 'mettre par défaut');
define('TEXT_FIELD_REQUIRED', '&nbsp;<span class="fieldRequired">* Requis</span>');

define('ERROR', 'Erreur : ');

define('TEXT_CACHE_CATEGORIES', 'Boîte catégories');
define('TEXT_CACHE_MANUFACTURERS', 'Boîte fabricants');
define('TEXT_CACHE_ALSO_PURCHASED', 'Module d\'achat supplémentaire');

define('TEXT_NONE', '--aucun--');
define('TEXT_TOP', 'Haut');


define('ERROR_DESTINATION_DOES_NOT_EXIST', 'Erreur : le chemin cible n\'existe pas.');
define('ERROR_DESTINATION_NOT_WRITEABLE', 'Erreur : Impossible d\'écrire dans le répertoire cible: ');
define('ERROR_FILE_NOT_SAVED', 'Erreur : fichier transférer non sauvegardé.');
define('ERROR_FILETYPE_NOT_ALLOWED', 'Erreur : type de fichier transféré non-permis.');
define('SUCCESS_FILE_SAVED_SUCCESSFULLY', 'Succès : Le fichier transféré a été sauvegardé avec succès.');
define('WARNING_NO_FILE_UPLOADED', 'Attention : fichier non transféré.');
define('ERROR_FILE_NOT_WRITEABLE', 'Erreur : Impossible d\'écrire dans le fichier cible: ');
define('ERROR_FILE_NOT_OPENED', 'Erreur : Impossible d\'ouvrir le fichier cible: ');
define('ERROR_IN_WRITE_FILE', 'Erreur : lors de l\'écriture  dans le fichier cible: ');
define('ERROR_DB', 'Erreur : Modification non effectué ');
define('ERROR_DB_REPLACE', 'Erreur : Modification non effectué ');

// some commons texts
define('TEXT_HELP','Aide');
define('TEXT_STATS','Stats');

define('TEXT_ASCENDINGLY','Ascendant');
define('TEXT_DESCENDINGLY','Descendant');
define('PARCOURIR_SERVER','Parcourir le serveur');
define('TEXT_IMAGE_NONEXISTENT', 'L\'IMAGE N\'EXISTE PAS');
define('ERR_404', '<h3>Page introuvable</h3> <p>Cette page n\'existe pas</p>');
define('NA','N/A');
/* */
define('TXT_MINIF_EMAIL','Envoyer email');
define('TXT_MINIF_DETAIL','Voir détail');
define('TXT_MINIF_STATS_BUY','stats achat');

define('NEXT', 'Suivant');
define('PREV', 'Précedent');
define('FIRST', 'Premier');
define('PREVIOUS', 'Dernier');



define('WARNING_INSTALL_DIRECTORY_EXISTS', 'Attention : le répertoire d\'installation existe à : ' . DIR_WS_CATALOG . 'install. Veuillez supprimer ce répertoire pour des raisons de sécurité.');
define('WARNING_CONFIG_FILE_WRITEABLE', 'Attention : Il est possible d\'écrire sur le fichier de configuration : ' . DIR_WS_CATALOG . 'includes/configure.php. Ceci est un risque potentiel - Mettez les bonnes permissions sur ce fichier.');
define('WARNING_SESSION_DIRECTORY_NON_EXISTENT', 'Attention : Le répertoire de session n\'existe pas : ' . tep_session_save_path() . '. Les sessions ne fonctionneront pas tant que ce répertoire n\'aura pas été créé.');
define('WARNING_SESSION_DIRECTORY_NOT_WRITEABLE', 'Attention : Il est impossible d\'écrire dans le répertoire de sessions ' . tep_session_save_path() . '. Les sessions ne fonctionneront pas tant que les permissions n\'auront pas été corrigées.');
define('WARNING_SESSION_AUTO_START', 'Attention : session.auto_start is enabled - désactiver cette fonctionnalité dans php.ini et redémarrer le serveur http.');
define('WARNING_DOWNLOAD_DIRECTORY_NON_EXISTENT', 'Attention : Le répertoire de téléchargement n\'existe pas : ' . DIR_WS_CATALOG.DIR_WS_CATALOG_DOWNLOAD . '. Le téléchargement de produits ne fonctionnera qu\'avec un répertoire valide.');
define('ERROR_NO_DEFAULT_CURRENCY_DEFINED', 'Erreur : Il n\'y a actuellement aucune devise par défaut. Veuillez en choisir une : Outils administration->Localisation->Devises');
define('WARNING_FILE_UPLOADS_DISABLED', 'Attention : transfert le fichier est désactivé dans le fichier de configuration php.ini.');
define('ERROR_NO_DEFAULT_LANGUAGE_DEFINED', 'Erreur : Il n\'y a actuellement aucune langue par défaut. Allez à configuration/langue');

// CIP ADD AUTO -- NOT TOUCH LINE

?>