<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  04/03/11, 09:10
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class account_extra

  Champs supplementaire pour les client et membre
*/

class account_extra
  implements InterfaceModule{
  /**
    @var object
  */
  public static $cInfo;
  /**
    @var int
  */
  public static $cID;

  /**
  */
  function __construct(){
    $this->code = __CLASS__;
    $this->title = __('account extra');
    $this->description = __('account extra info') ;
    $this->sort_order = (defined('MODULE_ACA_ACCOUNT_EXTRA_SORT_ORDER')) ? MODULE_ACA_ACCOUNT_EXTRA_SORT_ORDER : 0;
    $this->enabled = true;

    self::$cInfo = new objectInfo(array());

    require_once(DIR_WS_FUNCTIONS.'lib.extra_fields.php');
  }

  public function check_action($actions){
    global $languages_id;
    $action=$actions['action'];
    $messageStack=messageStack::getInstance();

    switch($action){
      case 'insert':
      case 'update':
	  try{
	    // BOF Customers extra fields
	    $extra_fields_query = tep_db_query("select ce.fields_id, ce.fields_input_type, ce.fields_required_status, cei.fields_name, ce.fields_status, ce.fields_input_type, ce.fields_size from " . TABLE_EXTRA_FIELDS . " ce, " . TABLE_EXTRA_FIELDS_INFO . " cei where ce.fields_status=1 and ce.fields_required_status=1 and cei.fields_id=ce.fields_id and cei.languages_id =" . $languages_id);
	    while($extra_fields = tep_db_fetch_array($extra_fields_query)){
	      if(strlen($_POST['fields_' . $extra_fields['fields_id']])<$extra_fields['fields_size'])throw new Exception(sprintf(ENTRY_EXTRA_FIELDS_ERROR,$extra_fields['fields_name'],$extra_fields['fields_size']) );
	    }

	  }catch(Exception $e){
	    $messageStack->add($e->getMessage(), 'error');
	    self::$error=true;
	  }
      break;
    }

    return $actions;
  }

  public function after_update($customers_id) {
//     global $customers_id;
    //! This function returns an array with variables to update into TABLE_ADDRESS_BOOK
      tep_db_query("delete from " . TABLE_CUSTOMERS_TO_EXTRA_FIELDS . " where customers_id=" . (int)$customers_id);
      $extra_fields_query = tep_db_query("select ce.fields_id from " . TABLE_EXTRA_FIELDS . " ce where ce.fields_status=1 ");

      while($extra_fields = tep_db_fetch_array($extra_fields_query)) {
	if(isset($_POST['fields_' . $extra_fields['fields_id']])){
	  $sql_data_array = array('customers_id' => (int)$customers_id,
				  'fields_id' => $extra_fields['fields_id'],
				  'value' => $_POST['fields_' . $extra_fields['fields_id']]);
	}
	else {
	  $sql_data_array = array('customers_id' => (int)$customers_id,
				  'fields_id' => $extra_fields['fields_id'],
				  'value' => '');
	  $is_add = false;
	  for($i = 1; $i <= $_POST['fields_' . $extra_fields['fields_id'] . '_total']; $i++) {
	    if(isset($_POST['fields_' . $extra_fields['fields_id'] . '_' . $i])) {
	      if($is_add) $sql_data_array['value'] .= "\n";
	      else $is_add = true;
	      $sql_data_array['value'] .= $_POST['fields_' . $extra_fields['fields_id'] . '_' . $i];
	    }
	  }
	}

	tep_db_perform(TABLE_CUSTOMERS_TO_EXTRA_FIELDS, $sql_data_array);
      }
    return array();
  }

  public function load_db_values($cID) {
//     self::$cInfo->objectInfo($customers);
  }

  public function load_post_values ($post) {
    self::$cInfo->objectInfo($post);
  }


  public function display_edit(&$contents,$id) {
    global $languages_id;

    self::$cID =$id;

    $contents []= array('title'=> __('extra fields'),
                    'text'=>  tep_get_include_contents(__CLASS__.'.form') );

    return $contents;
  }

  public function delete_account ($id){
     tep_db_query("delete from " . TABLE_CUSTOMERS_TO_EXTRA_FIELDS . " where customers_id=" . (int)$id);
  }



  public static function get_extra_fields($customer_id,$languages_id){
    $extra_fields_query = tep_db_query("select ce.fields_id, ce.fields_input_type, ce.fields_input_value, ce.fields_required_status, cei.fields_name, ce.fields_status, ce.fields_input_type from " . TABLE_EXTRA_FIELDS . " ce, " . TABLE_EXTRA_FIELDS_INFO . " cei where ce.fields_status=1 and cei.fields_id=ce.fields_id and cei.languages_id =" . $languages_id." and fields_special_mod='' order by ce.fields_group_class");
    $extra_fields_string ='';
    if(tep_db_num_rows($extra_fields_query)>0){

      while($extra_fields = tep_db_fetch_array($extra_fields_query)){
	$extra_fields_string .= '<p class="block_input">';
	$value='';
	if(isset($customer_id)){
	  $value_query = tep_db_query("select value from " . TABLE_CUSTOMERS_TO_EXTRA_FIELDS . " where customers_id=" . $customer_id . " and fields_id=" . $extra_fields['fields_id']);
	  $value_info = tep_db_fetch_array($value_query);
	  $value_list = explode("\n", $value_info['value']);
	  for($i = 0, $n = sizeof($value_list); $i < $n; $i++) {
	    $value_list[$i] = trim($value_list[$i]);
	  }
	  $value = $value_list[0];
	}
	$extra_fields_string .='<label for="fields_' . $extra_fields['fields_id'].'">' . $extra_fields['fields_name'] . ': </label>';


	$select_values_list = explode("\n", $extra_fields['fields_input_value']);
	$select_values = array();
	foreach($select_values_list as $item) {
	  $item = trim($item);
	  $select_values[] = array('id' => $item, 'text' => $item);
	}

	switch((int)$extra_fields['fields_input_type']) {
	  case  0: $extra_fields_string .= tep_draw_input_field('fields_' . $extra_fields['fields_id'],'fields_' . $extra_fields['fields_id'],$value). (($extra_fields['fields_required_status']==1) ? '<span class="inputRequirement">*</span>': ''); break;
	  case  1: $extra_fields_string .= tep_draw_textarea_field('fields_' . $extra_fields['fields_id'], 'soft', 50, 6,$value,'style="width:400px;"'). (($extra_fields['fields_required_status']==1) ? '<span class="inputRequirement">*</span>': ''); break;
	  case  2:
	    foreach($select_values_list as $item) {
	      $item = trim($item);
	      $extra_fields_string .= tep_draw_radio_field('fields_' . $extra_fields['fields_id'], 'radio', $item, (($value == $item)?(true):(false))).$item. (($extra_fields['fields_required_status']==1) ? '<span class="inputRequirement">*</span>': '').'<br />';
	      $extra_fields['fields_required_status']  = 0;
	    }
	    break;
	  case  3:
	    $cnt = 1;
	    foreach($select_values_list as $item) {
	      $item = trim($item);
	      $extra_fields_string .= tep_draw_checkbox_field('fields_' . $extra_fields['fields_id'] . '_' . ($cnt++), 'checkbox', $item, ((@in_array($item, $value_list))?(true):(false))).$item. (($extra_fields['fields_required_status']==1) ? '<span class="inputRequirement">*</span>': '').'<br />';
	      $extra_fields['fields_required_status']  = 0;
	    }
	    $extra_fields_string .= tep_draw_hidden_field('fields_' . $extra_fields['fields_id'] . '_total' , $cnt);
	    break;
	    case  4: $extra_fields_string .= tep_draw_pull_down_menu('fields_' . $extra_fields['fields_id'], $select_values, $value).(($extra_fields['fields_required_status']==1) ? '<span class="inputRequirement">*</span>': '');
	    break;
	    case  5:
	      $extra_fields_string .= tep_draw_hidden_field('fields_' . $extra_fields['fields_id'] , $value);
	    break;
	    default: $extra_fields_string .= tep_draw_input_field('fields_' . $extra_fields['fields_id'],$value). (($extra_fields['fields_required_status']==1) ? '<span class="inputRequirement">*</span>': '');
	}

	$extra_fields_string .='</p>';
      }

    }
    return $extra_fields_string;
  }


  public static function get_customers_extra_fields_name($fields_id, $language_id) {
    $fields_query = tep_db_query("select fields_name from " . TABLE_EXTRA_FIELDS_INFO . " where fields_id = '" . (int)$fields_id . "' and languages_id = '" . (int)$language_id . "'");
    $fields = tep_db_fetch_array($fields_query);

    return $fields['fields_name'];
  }



/** Functions for modules administration */
  function check() {
    if (!isset($this->_check)) {
      $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ACA_ACCOUNT_EXTRA_INSTALLED'");
      $this->_check = tep_db_num_rows($check_query);
    }
    return $this->_check;
  }

  function install() {
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added,configuration_type) values ('".addslashes(__("Ordre de tri"))."', 'MODULE_ACA_ACCOUNT_EXTRA_SORT_ORDER', '0', '".addslashes(__("Ordre de tri, dans l'affichage"))."', '1', '0', now(),1)");
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added,configuration_type) values ('".addslashes(__("active champs extra front"))."', 'MODULE_ACA_ACCOUNT_EXTRA_INSTALLED', '0', '".addslashes(__("active les options de champs supllementaire dans le front"))."', '1', '0', now(),1)");
  }

  function remove() {
    foreach($this->keys as $key)
      tep_db_query(" delete from" . TABLE_CONFIGURATION . " WHERE configuration_key='".$key."' limit 1");
  }

  function keys() {
    return array('MODULE_ACA_ACCOUNT_EXTRA_SORT_ORDER',
                  'MODULE_ACA_ACCOUNT_EXTRA_INSTALLED');
  }
}

?>