<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  28/03/11, 18:54
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8

  @class address_book
  Gestion Des adresses d'un clients
*/


class address_book
  implements InterfaceModule{

  public static $cInfo;

  public static $action;

  /**
  */
  function __construct(){

    $this->code = __CLASS__;
    $this->title = __('address book text title');
    $this->description = __('address book text description') ;
    $this->sort_order = (defined('MODULE_ACA_ADDRESS_BOOK_SORT_ORDER')) ? MODULE_ACA_ADDRESS_BOOK_SORT_ORDER : 0;
    $this->enabled = true;

    $this->sql_data_array=array();
    self::$cInfo = new objectInfo(array());
  }

  public function check_action($actions){
    global $oscss;
    self::$action=$actions['action'];
    $languages = tep_get_languages();
    $messageStack=messageStack::getInstance();

    switch(self::$action){
      case 'insert':
	//$default_address_id = tep_db_prepare_input($_POST['default_address_id']);
	$entry_street_address = tep_db_prepare_input($_POST['entry_street_address']);
	if (_cst_bool('ACCOUNT_SUBURB')) $entry_suburb = tep_db_prepare_input($_POST['entry_suburb']);
	$entry_postcode = tep_db_prepare_input($_POST['entry_postcode']);
	$entry_city = tep_db_prepare_input($_POST['entry_city']);
	$entry_country_id = tep_db_prepare_input($_POST['entry_country_id']);
	if (_cst_bool('ACCOUNT_COMPANY')){
	  $entry_company = tep_db_prepare_input($_POST['entry_company']);
	  $entry_company_tax_id = tep_db_prepare_input($_POST['entry_company_tax_id']);
	}
	if (_cst_bool('ACCOUNT_STATE')) {
	  $entry_state = tep_db_prepare_input($_POST['entry_state']);
	  if (isset($_POST['entry_zone_id'])) $entry_zone_id = tep_db_prepare_input($_POST['entry_zone_id']);
	}


	try{
	  if (strlen($entry_street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH)throw new Exception(__("L'adresse est trop courte "));
	  if (strlen($entry_postcode) < ENTRY_POSTCODE_MIN_LENGTH)throw new Exception(__("Le code postal de la ville est trop court "));
	  if (strlen($entry_city) < ENTRY_CITY_MIN_LENGTH)throw new Exception(__("Le nom de la ville est trop court"));
	  if ($entry_country_id == false)throw new Exception(__("Le code pays n'est pas correct"));


	  if (_cst_bool('ACCOUNT_STATE')) {
	    $zone_id = 0;
	    $entry_state_error = false;
	    $check_query = tep_db_query("select count(*) as total from " . TABLE_ZONES . " where zone_country_id = '" . (int)$entry_country_id . "'");
	    $check_value = tep_db_fetch_array($check_query);

	    if (($check_value['total'] > 0) == false) throw new Exception(__("erreur aucun pays ne correpsond "));
	    $zone_query = tep_db_query("select zone_id from " . TABLE_ZONES . " where zone_country_id = '" . (int)$entry_country_id . "' and zone_name = '" . tep_db_input($entry_state) . "'");
	      if (tep_db_num_rows($zone_query) != 1)throw new Exception(__("erreur lors de l'enregistrement du pays  "));
	      $zone_values = tep_db_fetch_array($zone_query);
	      $entry_zone_id = $zone_values['zone_id'];
	  }


	}catch(Exception $e){
	  $messageStack->add($e->getMessage(), 'error');
	  customers::$error=true;
	}

      break;
      case 'update':

	$default_address_id = tep_db_prepare_input($_POST['customers_default_address_id']);
	$entry_street_address = tep_db_prepare_input($_POST['entry_street_address']);
	if (_cst_bool('ACCOUNT_SUBURB')) $entry_suburb = tep_db_prepare_input($_POST['entry_suburb']);
	$entry_postcode = tep_db_prepare_input($_POST['entry_postcode']);
	$entry_city = tep_db_prepare_input($_POST['entry_city']);
	$entry_country_id = tep_db_prepare_input($_POST['entry_country_id']);
	if (_cst_bool('ACCOUNT_COMPANY')){
	  $entry_company = tep_db_prepare_input($_POST['entry_company']);
	  $entry_company_tax_id = tep_db_prepare_input($_POST['entry_company_tax_id']);
	}
	if (_cst_bool('ACCOUNT_STATE')) {
	  $entry_state = tep_db_prepare_input($_POST['entry_state']);
	  if (isset($_POST['entry_zone_id'])) $entry_zone_id = tep_db_prepare_input($_POST['entry_zone_id']);
	}


	try{
	  if (strlen($entry_street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH)throw new Exception(__("L'adresse est trop courte "));
	  if (strlen($entry_postcode) < ENTRY_POSTCODE_MIN_LENGTH)throw new Exception(__("Le code postal de la ville est trop court "));
	  if (strlen($entry_city) < ENTRY_CITY_MIN_LENGTH)throw new Exception(__("Le nom de la ville est trop court"));
	  if ($entry_country_id == false)throw new Exception(__("Le code pays n'est pas correct"));


	  if (_cst_bool('ACCOUNT_STATE')) {
	    $zone_id = 0;
	    $entry_state_error = false;
	    $check_query = tep_db_query("select count(*) as total from " . TABLE_ZONES . " where zone_country_id = '" . (int)$entry_country_id . "'");
	    $check_value = tep_db_fetch_array($check_query);

	    if (($check_value['total'] > 0) == false) throw new Exception(__("erreur aucun pays ne correpsond "));
	    $zone_query = tep_db_query("select zone_id from " . TABLE_ZONES . " where zone_country_id = '" . (int)$entry_country_id . "' and zone_name = '" . tep_db_input($entry_state) . "'");
	      if (tep_db_num_rows($zone_query) != 1)throw new Exception(__("erreur lors de l'enregistrement du pays  "));
	      $zone_values = tep_db_fetch_array($zone_query);
	      $entry_zone_id = $zone_values['zone_id'];
	  }

	}catch(Exception $e){
	  $messageStack->add($e->getMessage(), 'error');
	  //!Force erreur class customers $error=true;
	  customers::$error=true;
	}
      break;
    }

    return $actions;
  }

  public function get_header(){

  }

  /**
    Insert TABLE_ADDRESS_BOOK
  */
  public function insert_table_second () {
    // add adress book
    $res=tep_db_perform(TABLE_ADDRESS_BOOK, self::$cInfo->sql_data_array);

    $sql_data_array=array('customers_default_address_id'=>tep_db_insert_id($res) ) ;
    tep_db_perform(TABLE_CUSTOMERS, $sql_data_array, 'update', "customers_id = '" . (int)self::$cInfo->sql_data_array['customers_id'] . "' ");

    return array();
  }

  /**
    Update  TABLE_ADDRESS_BOOK
  */
  public function update_table_second () {

    //! This function returns an array with variables to update into TABLE_ADDRESS_BOOK
    $sql_data_array=$this->sql_data_array;
    tep_db_perform(TABLE_ADDRESS_BOOK, self::$cInfo->sql_data_array, 'update', "customers_id = '" . (int)self::$cInfo->sql_data_array['customers_id'] . "' and address_book_id = '" . (int)self::$cInfo->customers_default_address_id . "'");

    return array();
  }

  public function deleteconfirm_account($id){
    tep_db_query("delete from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$id . "'");
  }


  /**
   * \fn type filter text
   * \brief Load each module parameters from database
   * @param $cID integer Id customers current
   */
  public function load_db_values($cID) {
    if(is_numeric($cID)) {
      $customers_query = tep_db_query($sql="select c.customers_id, c.customers_gender, c.customers_firstname, c.customers_lastname, c.customers_dob, c.customers_email_address, a.entry_company, a.entry_company_tax_id, a.entry_street_address, a.entry_suburb, a.entry_postcode, a.entry_city, a.entry_state, a.entry_zone_id, a.entry_country_id, c.customers_telephone, c.customers_fax, c.customers_newsletter, c.customers_group_id,  c.customers_group_ra, c.customers_payment_allowed, c.customers_shipment_allowed, c.customers_order_total_allowed, c.customers_specific_taxes_exempt, c.customers_default_address_id from " . TABLE_CUSTOMERS . " c left join " . TABLE_ADDRESS_BOOK . " a on c.customers_default_address_id = a.address_book_id where a.customers_id = c.customers_id and c.customers_id = '" . (int)$cID . "'");
      $customers = tep_db_fetch_array($customers_query);
    }else {
      $customers=array('customers_id'=>'',
      'customers_newsletter'=>'',
      'customers_default_address_id'=>'',
      'entry_company'=>'',
      'entry_company_tax_id'=>'',
      'entry_street_address'=>'',
      'entry_suburb'=>'',
      'entry_postcode'=>'',
      'entry_city'=>'',
      'entry_state'=>'',
      'entry_zone_id'=>'',
      'entry_country_id'=>'',
      'customers_group_name'=>'',
      'customers_group_id'=>'',
      'customers_group_ra'=>'',
      'customers_payment_allowed'=>'',
      'customers_shipment_allowed'=>'',
      'customers_order_total_allowed'=>'',
      'customers_specific_taxes_exempt'=>'',
      'customers_default_address_id'=>'');
    }

    self::$cInfo->objectInfo($customers);
  }

  /**
   * \fn load_post_values ($post)
   * @param $post array
   */
  public function load_post_values ($post) {
     $sql_data_array = array('entry_firstname' => $post['customers_firstname'],
                              'entry_lastname' => $post['customers_lastname'],
                              'entry_street_address' => $post['entry_street_address'],
                              'entry_postcode' => $post['entry_postcode'],
                              'entry_city' => $post['entry_city'],
                              'entry_country_id' => $post['entry_country_id']);

      if(isset($post['customers_id']))
       $sql_data_array['customers_id'] = $post['customers_id'];

      if (_cst_bool('ACCOUNT_COMPANY')){
        $sql_data_array['entry_company'] = $post['entry_company'];
        $sql_data_array['entry_company_tax_id'] = $post['entry_company_tax_id'];
      }
      if (_cst_bool('ACCOUNT_SUBURB')) $sql_data_array['entry_suburb'] = $post['entry_suburb'];

      if (_cst_bool('ACCOUNT_STATE')) {
        if ($post['entry_zone_id'] > 0) {
          $sql_data_array['entry_zone_id'] = $post['entry_zone_id'];
          $sql_data_array['entry_state'] = '';
        } else {
          $sql_data_array['entry_zone_id'] = '0';
          $sql_data_array['entry_state'] = $post['entry_state'];
        }
      }
     if(isset($post['customers_default_address_id']))
       $result['customers_default_address_id']=$post['customers_default_address_id'];

    $result['sql_data_array']=$sql_data_array;



     self::$cInfo = new objectInfo($result);
  }

  function repost_values () {
      // Repost all values that are not arrays
      foreach ($this->pInfo as $key=>$val) {
        if (!is_array($this->pInfo[$key])) {
            echo "\n".tep_draw_hidden_field($this->code .'['.$key.']', stripslashes($val))."\n";
    }
      }
  }

  function display_edit(&$contents,$id) {
    global $processed;
    $this->load_db_values($id);
    $contents []= array('title'=> __('Adresse'),
                        'text'=>  tep_get_include_contents(__CLASS__.'.form'));

  }

/** Force implements InterfaceModule class to define this method */
    function check() {
    if (!isset($this->_check)) {
      $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ACA_ADDRESS_BOOK_SORT_ORDER'");
      $this->_check = tep_db_num_rows($check_query);
    }
    return $this->_check;
    }

    function install() { return false; }

    function remove() {return false; }

    function keys() {
      return array( 'MODULE_ACA_ADDRESS_BOOK_SORT_ORDER' );
    }
}

?>