<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  29/08/10, 21:47
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class header_tags
*/

class header_tags
  extends AbstractHeader_tags
    implements InterfaceModule{
  /**
    @param array
  */
  public static $languages = array();
  /**
    @param object
  */
  public static $pInfo;

  var $code;
  var $title;
  var $description;
  var $sort_order;
  var $enabled;

  /**
    class constructor
  */
  function __construct() {
    global $language,$languages_id;
    parent::load_lang();

    $this->code = __CLASS__ ;
    $this->title = __('module acapro headertags text title');
    $this->description = __('module acapro headertags text description');
    $this->sort_order = (defined('MODULE_ACACAT_HTC_SORT_ORDER'))?MODULE_ACACAT_HTC_SORT_ORDER : 0;
    $this->enabled = true;

    self::$pInfo= new objectInfo (array());

    self::$languages= tep_get_languages();
  }


  /**
    Edition produit
    UP db
  */
  function after_update ($cat_id) {

    self::$pInfo=parent::load_db_base($cat_id, 'cat');
    $myarray=array('page_type' => 'cat',
                  'page_id' => $cat_id);

    if(isset(self::$pInfo->tag_id))tep_db_perform(TABLE_FULL_TAG, $myarray, 'update', " tag_id='".self::$pInfo->tag_id."'" );
    else{
      tep_db_perform(TABLE_FULL_TAG, $myarray);
      $cat_query = tep_db_query("SELECT tag_id FROM " . TABLE_FULL_TAG . " ft WHERE ft.page_type='cat' and  ft.page_id = '" . (int)$cat_id . "' ");
      $cat = tep_db_fetch_array($cat_query);
      self::$pInfo->tag_id=$cat['tag_id'];
    }
  }

  /**
    Update table langue
  */
  function after_update_lang ($language_id,$cat_id) {
     $this->load_db_values($cat_id);

    if(parent::load_db_descr_check(self::$pInfo->tag_id,$language_id)) $action='update';
    else $action='insert';

    $pInfo=parent::load_post_values($_POST);
    $pInfo->header_tags['head_title_tag'][$language_id]=(tep_not_null($pInfo->header_tags['head_title_tag'][$language_id]) ? $pInfo->header_tags['head_title_tag'][$language_id] : $pInfo->categories_name[$language_id]) ;
    parent::insert_db_values(self::$pInfo->tag_id,$action,$pInfo,$language_id);
  }

  /**
    Edition/affichage  produit
    UP db
  */
  public static function load_db_values ($cat_id) {
    $arr ['cat_id'] = $cat_id;
    $arr=array_merge(array('cat_id'=>$cat_id) ,parent::load_db_values ($cat_id, 'cat') );
    self::$pInfo->objectInfo($arr);
  }

  /**
    Draw
  */
  public function display_edit(&$contents) {
    $contents []=array('title'=> __('tab products meta'),'text'=>tep_get_include_contents(__CLASS__.'.form'));
  }


/** Force implements InterfaceModule class to define this method */
    function check() { return true; }
    function install() { return false; }
    function remove() { return false;    }
    function keys() {
      return array( 'MODULE_ACAPRO_HEADERTAGS_SORT_ORDER');
    }

}
?>