<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  23/06/10, 17:33
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class cfg_29
  Gestion des templates , choix du template public
*/


Class cfg_29 implements ext_configuration{
  /**
    array list template
  */
  public static $list;

  /**
  */
  function __construct(){
    global $oscss;
    $this->code=__CLASS__;
    global $messageStack, $language,$lang;
    if (!is_writeable(DIR_FS_TEMPLATES))  $messageStack->add(ERROR_DESTINATION_NOT_WRITEABLE. 'template/', 'error');

    $oscss->pile_file_lang(DIR_FS_ADMIN.DIR_WS_LANGUAGES.$language.'/modules/configuration/'.$this->code.'.txt');
  }


  /**
    Action Prise en charge par le modules
    @param
      @e global $action
      @e global $messageStack
  */
  public function draw_action(){
    global $action,$messageStack;

    $DB=Database::getInstance();

    if (tep_not_null($action)) {
      switch ($action) {
	case 'set':
	  if (isset($_GET['theme'])) {
	    $template = tep_db_prepare_input($_GET['theme']);

	    // on verifie qu'il ya bien un fichier template.php
	    if (!file_exists(DIR_FS_TEMPLATES . $template .'/template.php') ) {
	      $messageStack->add_session(__('error files doesnt exist'), 'error');
	    }else {
	      $template_query = $DB->query("UPDATE ".TABLE_CONFIGURATION ." set configuration_value = '".$template."' where configuration_key = 'TEMPLATE_NAME'");
	      $messageStack->add_session(__('succes new template activated'), 'success');
	    }
	    //! reset cache sys public
	    osCSS_Cache::clear('plugins');
	    osCSS_Cache::clear('Global');
	    osCSS_Cache::clear('fo_lang');
	  }
	  tep_redirect(tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action'), false) ));
	break;
	case 'insert':
	  if ($new_template = new upload('new_template', DIR_FS_TEMPLATES)) {
	    tep_zip_extractto(DIR_FS_TEMPLATES.$new_template->filename,DIR_FS_TEMPLATES);
	    tep_remove(DIR_FS_TEMPLATES.$new_template->filename);
	  }
	  tep_redirect(tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action'), false) ));
	break;
	case 'cfg':
	//! reset conf des plugin
	ResetConfigKey('PLUGIN_ACCOUNT_INSTALLED');
	ResetConfigKey('PLUGIN_GENERIC_INSTALLED');
	ResetConfigKey('PLUGIN_HOME_INSTALLED');
	ResetConfigKey('PLUGIN_LISTING_INSTALLED');
	ResetConfigKey('PLUGIN_PRODUCT_INSTALLED');

	  $this->config_template($_GET['theme']);
	break;
      }
    }
  }

  /**
    @return array
  */
  public function load_db_values($Id){
    $liste=array();
    foreach(scan(DIR_FS_TEMPLATES) as $theme){
      if ( file_exists(DIR_FS_TEMPLATES . $theme .'/desc.xml') ) {
        $file = DIR_FS_TEMPLATES . $theme .'/desc.xml' ;
        $template_infos = @simplexml_load_file($file);

        if (!empty($template_infos->thumb) && file_exists(DIR_FS_TEMPLATES.$theme.'/'.$template_infos->thumb)) {
          $picture = '<a href="'. DIR_WS_TEMPLATES.$theme.'/'.$template_infos->thumb.'" class="fancy" rel="template" title="'.$theme.' / '.$template_infos->desc.' (v'.$template_infos->version.') by '.$template_infos->author.'" ><img src="'.DIR_WS_TEMPLATES.$theme . '/' . $template_infos->thumb.'" width="60" alt="'.$theme.'" /></a>';
        } else $picture = __('text no preview');

        if ($theme == TEMPLATE_NAME ) {
          $statut = tep_image(DIR_WS_ICONS . 'icon_status_green.gif', IMAGE_ICON_STATUS_GREEN);
          if ( file_exists(DIR_FS_TEMPLATES . $theme .'/cfg/configuration.php') )
	    $statut .= ' <a href="'.tep_href_link(FILENAME_CONFIGURATION , tep_get_all_get_params(array('action','forceview','theme')) .'forceview&amp;action=cfg&amp;theme='.$theme ).'" class="fancy iframe" title="'.__('configuration automatique').'">' . tep_image(DIR_WS_ICONS . 'icon_info.gif') . '</a>';

	    $statut .= ' <a href="'.tep_href_link(FILENAME_PLUGINS ).'">' .__('plugins du theme'). '</a>';

        } else $statut = '<a href="'.tep_href_link( FILENAME_CONFIGURATION , tep_get_all_get_params(array('action','forceview','theme')). 'action=set&amp;theme='.$theme ).'" >' . tep_image(DIR_WS_ICONS . 'icon_status_green_light.gif', IMAGE_ICON_STATUS_GREEN_LIGHT) . '</a>';

	$array=array(
	      'version'=>$theme,
	      'id'=>$template_infos->version,
	      'author'=>tep_output_string_protected($template_infos->author, true, false),
	      'desc'=>tep_output_string_protected($template_infos->desc, true, false),
	      'picture'=>tep_output_string_protected($picture, true, false),
	      'statut'=>tep_output_string_protected($statut, true, false),
	      );
	$liste[]= new objectInfo($array);
      }
    }
    return $liste;
  }

  /**
    Appelé dans le header de page
  */
  public static function draw_header(){
    tep_include_file ("includes/javascript/jquery.mousewheel-3.0.2.pack.js",true);
    print '<script type="text/javascript"><!--'."\n".
	      '$(function() {'."\n".
		'$("a.fancy").fancybox({\'hideOnContentClick\': true, \'overlayOpacity\': 0.6, \'titlePosition\': \'inside\'});'."\n".
	      '});'."\n".
	    '// --></script>'."\n";

  }

  /**
    Contenu central
    @param
      @e global $action
      @e global $gparentID
  */
  public function draw(){
    global $action,$gparentID;
    if($action=='cfg')  return;
    self::$list = $this->load_db_values('');
    return tep_get_include_contents(__CLASS__.'.listing');
  }



  /**
    Configuration du thème
  */
  private function config_template($theme){
    global $messageStack;
    if ( file_exists(DIR_FS_TEMPLATES . $theme .'/cfg/configuration.php') ) {
      echo '<p>'.__('text option').'</p>';
      require(DIR_FS_TEMPLATES. $theme .'/cfg/configuration.php');
    } else {
      echo '<p>'.__('text no option').'</p>';
    }
  }



}

?>