<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  12/12/10, 17:56
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class cfg_31 Gestion des langue configuré sur la boutiques
  @brief manage all status (order, returns, ...)
*/

Class cfg_31{

  public static $liste;

  public static $gparentID;

  public static $action;

  public static $lInfo;

  private static $remove_language;

  /**
  */
  function __construct(){
    $this->code='cfg_31';
    global $language,$oscss;
    $oscss=oscss_cstr::getInstance();
    $oscss->pile_file_lang(DIR_FS_ADMIN.DIR_WS_LANGUAGES.$language.'/modules/configuration/'.$this->code.'.txt');
  }


  /**
    Action en remplacement des action par defaut
  */
  public function draw_action(){
    global $action,$messageStack,$languages_id;

    self::$action= $action;

    $DB=Database::getInstance();

    if (tep_not_null(self::$action)) {
      switch (self::$action) {
	case 'insert':
	  $name = tep_db_prepare_input($_POST['name']);
	  $code = tep_db_prepare_input($_POST['code']);
	  $image = tep_db_prepare_input($_POST['image']);
	  $directory = tep_db_prepare_input($_POST['directory']);
	  $sort_order = tep_db_prepare_input($_POST['sort_order']);


	  $res=$DB->query("insert into " . TABLE_LANGUAGES . " (name, code, image, directory, sort_order) values ('" . tep_db_input($name) . "', '" . tep_db_input($code) . "', '" . tep_db_input($image) . "', '" . tep_db_input($directory) . "', '" . tep_db_input($sort_order) . "')");
	  $insert_id = $res->__get('insertId');

	  self::repliqu_db_lang($languages_id,$insert_id);


	  if (isset($_POST['default']) && ($_POST['default'] == 'on')) {
	    $DB->query("update " . TABLE_CONFIGURATION . " set configuration_value = '" . tep_db_input($code) . "' where configuration_key = 'DEFAULT_LANGUAGE'");
	  }

	  tep_redirect(tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','lID'),false)));
	  break;
	case 'save':
	  $lID = tep_db_prepare_input($_GET['lID']);
	  $name = tep_db_prepare_input($_POST['name']);
	  $code = tep_db_prepare_input($_POST['code']);
	  $image = tep_db_prepare_input($_POST['image']);
	  $directory = tep_db_prepare_input($_POST['directory']);
	  $sort_order = tep_db_prepare_input($_POST['sort_order']);

	  tep_db_query("update " . TABLE_LANGUAGES . " set name = '" . tep_db_input($name) . "', code = '" . tep_db_input($code) . "', image = '" . tep_db_input($image) . "', directory = '" . tep_db_input($directory) . "', sort_order = '" . tep_db_input($sort_order) . "' where languages_id = '" . (int)$lID . "'");

	  if ($_POST['default'] == 'on') {
	    tep_db_query("update " . TABLE_CONFIGURATION . " set configuration_value = '" . tep_db_input($code) . "' where configuration_key = 'DEFAULT_LANGUAGE'");
	  }

	  tep_redirect(tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','lID'),false). 'lID=' . $_GET['lID']));
	  break;
	case 'deleteconfirm':
	  $lID = tep_db_prepare_input($_GET['lID']);

	  $lng_query = tep_db_query("select languages_id from " . TABLE_LANGUAGES . " where code = '" . DEFAULT_CURRENCY . "'");
	  $lng = tep_db_fetch_array($lng_query);
	  if ($lng['languages_id'] == $lID) {
	    tep_db_query("update " . TABLE_CONFIGURATION . " set configuration_value = '' where configuration_key = 'DEFAULT_CURRENCY'");
	  }

	  tep_db_query("delete from " . TABLE_CATEGORIES_DESCRIPTION . " where language_id = '" . (int)$lID . "'");
	  tep_db_query("delete from " . TABLE_PRODUCTS_DESCRIPTION . " where language_id = '" . (int)$lID . "'");
	  tep_db_query("delete from " . TABLE_PRODUCTS_OPTIONS . " where language_id = '" . (int)$lID . "'");
	  tep_db_query("delete from " . TABLE_PRODUCTS_OPTIONS_VALUES . " where language_id = '" . (int)$lID . "'");
	  tep_db_query("delete from " . TABLE_MANUFACTURERS_INFO . " where languages_id = '" . (int)$lID . "'");
	  require(DIR_WS_MODULES.'configuration/cfg_30.php') ;
	  cfg_30::del_language($lID);


	  tep_db_query("delete from " . TABLE_LANGUAGES . " where languages_id = '" . (int)$lID . "'");


	  tep_redirect(tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','lID'), false). 'page=' . $_GET['page']));
	  break;
	case 'delete':
	  $lID = tep_db_prepare_input($_GET['lID']);

	  $lng_query = tep_db_query("select code from " . TABLE_LANGUAGES . " where languages_id = '" . (int)$lID . "'");
	  $lng = tep_db_fetch_array($lng_query);

	  self::$remove_language = true;
	  if ($lng['code'] == DEFAULT_LANGUAGE) {
	    self::$remove_language = false;
	    $messageStack->add(__('error remove default language'), 'error');
	  }
        break;
    }
  }
  }

  /**
  */
  public function load_db_values(){
    global $languages_id;

      $this->languages_query_numrows=0;
      $this->languages_query_raw = "select languages_id, name, code, image, directory, sort_order from " . TABLE_LANGUAGES . " order by sort_order";
      $this->languages_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $this->languages_query_raw, $this->languages_query_numrows);
      $languages_query = tep_db_query($this->languages_query_raw);

      while ($languages = tep_db_fetch_array($languages_query)) {
        if ((!isset($_GET['lID']) || (isset($_GET['lID']) && ($_GET['lID'] == $languages['languages_id']))) && !isset($lInfo) && (substr(self::$action, 0, 3) != 'new')) {
          self::$lInfo = new objectInfo($languages);
        }

        if (isset(self::$lInfo) && is_object(self::$lInfo) && ($languages['languages_id'] == self::$lInfo->languages_id) ) $class_s=" Selected";
        else $class_s="";

        $languages['name'] .= (DEFAULT_LANGUAGE == $languages['code'])? ' (' . TEXT_DEFAULT . ')' : '';
	$list_s[]=new objectInfo($languages);
      }

    return $list_s;
  }

  /**
    Appelé dans le header de page
  */
  public static function draw_header(){
  }

  /**
    Contenu central
  */
  public function draw(){
    global $gparentID;

    if(self::$action=='cfg')  return;
    self::$liste = $this->load_db_values();
    self::$gparentID=$gparentID;

    return tep_get_include_contents($this->code.'.listing');
  }

  /**
    Duplication des entrée dans les db, por prendre en charge la gestion mutlilangue
  */
  public static function repliqu_db_lang($languages_id,$insert_id){

    // create additional status records
      $_options_query = tep_db_query("select status_id,status_type, status_name, status_color from " . TABLE_STATUS . " where language_id = '" . (int)$languages_id . "'");
      while ($_options = tep_db_fetch_array($_options_query)) {
	tep_db_query("insert into " . TABLE_PRODUCTS_OPTIONS . " (status_id,status_type,language_id, status_name, status_color) values ('" . (int)$_options['status_id'] . "', '" . (string)tep_db_input($_options['status_type']) . "', '" . (int)$insert_id . "', '" .  (string)tep_db_input($_options['status_name']) . "', '" .  (string)tep_db_input($_options['status_color']) . "')");
      }

    // create additional categories_description records
      $categories_query = tep_db_query("select c.categories_id, cd.categories_name from " . TABLE_CATEGORIES . " c left join " . TABLE_CATEGORIES_DESCRIPTION . " cd on c.categories_id = cd.categories_id where cd.language_id = '" . (int)$languages_id . "'");
      while ($categories = tep_db_fetch_array($categories_query)) {
	tep_db_query("insert into " . TABLE_CATEGORIES_DESCRIPTION . " (categories_id, language_id, categories_name) values ('" . (int)$categories['categories_id'] . "', '" . (int)$insert_id . "', '" . tep_db_input($categories['categories_name']) . "')");
      }

    // create additional products_description records
      $products_query = tep_db_query("select p.products_id, pd.products_name, pd.products_description, pd.products_url from " . TABLE_PRODUCTS . " p left join " . TABLE_PRODUCTS_DESCRIPTION . " pd on p.products_id = pd.products_id where pd.language_id = '" . (int)$languages_id . "'");
      while ($products = tep_db_fetch_array($products_query)) {
	tep_db_query("insert into " . TABLE_PRODUCTS_DESCRIPTION . " (products_id, language_id, products_name, products_description, products_url) values ('" . (int)$products['products_id'] . "', '" . (int)$insert_id . "', '" . tep_db_input($products['products_name']) . "', '" . tep_db_input($products['products_description']) . "', '" . tep_db_input($products['products_url']) . "')");
      }

    // create additional products_options records
      $products_options_query = tep_db_query("select products_options_id, products_options_name from " . TABLE_PRODUCTS_OPTIONS . " where language_id = '" . (int)$languages_id . "'");
      while ($products_options = tep_db_fetch_array($products_options_query)) {
	tep_db_query("insert into " . TABLE_PRODUCTS_OPTIONS . " (products_options_id, language_id, products_options_name) values ('" . (int)$products_options['products_options_id'] . "', '" . (int)$insert_id . "', '" . tep_db_input($products_options['products_options_name']) . "')");
      }

    // create additional products_options_values records
      $products_options_values_query = tep_db_query("select products_options_values_id, products_options_values_name from " . TABLE_PRODUCTS_OPTIONS_VALUES . " where language_id = '" . (int)$languages_id . "'");
      while ($products_options_values = tep_db_fetch_array($products_options_values_query)) {
	tep_db_query("insert into " . TABLE_PRODUCTS_OPTIONS_VALUES . " (products_options_values_id, language_id, products_options_values_name) values ('" . (int)$products_options_values['products_options_values_id'] . "', '" . (int)$insert_id . "', '" . tep_db_input($products_options_values['products_options_values_name']) . "')");
      }

    // create additional manufacturers_info records
      $manufacturers_query = tep_db_query("select m.manufacturers_id, mi.manufacturers_url from " . TABLE_MANUFACTURERS . " m left join " . TABLE_MANUFACTURERS_INFO . " mi on m.manufacturers_id = mi.manufacturers_id where mi.languages_id = '" . (int)$languages_id . "'");
      while ($manufacturers = tep_db_fetch_array($manufacturers_query)) {
	tep_db_query("insert into " . TABLE_MANUFACTURERS_INFO . " (manufacturers_id, languages_id, manufacturers_url) values ('" . $manufacturers['manufacturers_id'] . "', '" . (int)$insert_id . "', '" . tep_db_input($manufacturers['manufacturers_url']) . "')");
      }

    // Ajout de status  / boucle par type
      require(DIR_WS_MODULES.'configuration/cfg_30.php') ;
      cfg_30::add_language($insert_id);

    // create additional return return texte
      $orders_status_query = tep_db_query("select return_text_id, return_text_one from " . TABLE_RETURNS_TEXT . " where language_id = '" . (int)$languages_id . "'");
      while ($orders_status = tep_db_fetch_array($orders_status_query)) {
	tep_db_query("insert into " . TABLE_RETURNS_TEXT . " (return_text_id, language_id, return_text_one) values ('" . (int)$orders_status['return_text_id'] . "', '" . (int)$insert_id . "', '" . tep_db_input($orders_status['return_text_one']) . "')");
      }


    // create additional full_tag_description records
      $products_query = tep_db_query("select p.tag_id from " . TABLE_FULL_TAG . " p left join " . TABLE_FULL_TAG_DESCRIPTION . " pd on p.tag_id = pd.tag_id where pd.language_id = '" . (int)$languages_id . "'");
      while ($products = tep_db_fetch_array($products_query)) {
	tep_db_query("insert into " . TABLE_FULL_TAG_DESCRIPTION . " (tag_id, language_id) values ('" . (int)$products['tag_id'] . "', '" . (int)$insert_id . "')");
      }

  }


  /* Private function class */

  /**
    list templates directorys public
  */
  public static function draw_right_columm() {
    $heading = array();
    $contents = array();
    $lInfo=(isset(self::$lInfo) ? self::$lInfo :new objectInfo(array()) );

  switch (self::$action) {
    case 'new':
      $heading[] = array('text' => __('text info heading new language') );

      $contents = array('form' => tep_draw_form('languages_form', FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','lID')). 'action=insert'));
      $contents[] = array('text' => __('text info insert intro'));
      $contents[] = array('class' => 'block_input','text' => __('text info language name') . tep_draw_input_field('name'));
      $contents[] = array('class' => 'block_input','text' => __('text info language code') . tep_draw_input_field('code'));
      $contents[] = array('class' => 'block_input','text' => __('text info language image') . tep_draw_input_field('image', '', 'icon.gif'));
      $contents[] = array('class' => 'block_input','text' => __('text info language directory') . tep_draw_input_field('directory'));
      $contents[] = array('class' => 'block_input','text' => __('text info language sort order') . tep_draw_input_field('sort_order'));
      $contents[] = array('class' => 'block_input','text' => tep_draw_checkbox_field('default') . __('text set default'));
      $contents[] = array('class' => 'button_nav','text' => tep_image_submit('button_insert.gif', IMAGE_INSERT) . ' <a  class="button" href="' . tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','lID')) ) . '">' .  IMAGE_CANCEL . '</a>');
      break;
    case 'edit':
      $heading[] = array('text' => __('text info heading edit language') );

      $contents = array('form' => tep_draw_form('languages_form', FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','lID')). 'lID=' . $lInfo->languages_id . '&amp;action=save'));
      $contents[] = array('text' => __('text info edit intro'));
      $contents[] = array('class' => 'block_input','text' => __('text info language name') . tep_draw_input_field('name', '', $lInfo->name));
      $contents[] = array('class' => 'block_input','text' => __('text info language code') . tep_draw_input_field('code', '', $lInfo->code));
      $contents[] = array('class' => 'block_input','text' => __('text info language image') . tep_draw_input_field('image', '', $lInfo->image));
      $contents[] = array('class' => 'block_input','text' => __('text info language directory') . tep_draw_input_field('directory', '', $lInfo->directory));
      $contents[] = array('class' => 'block_input','text' => __('text info language sort order') . tep_draw_input_field('sort_order', '', $lInfo->sort_order));
      if (DEFAULT_LANGUAGE != $lInfo->code) $contents[] = array('class' => 'block_input','text' => tep_draw_checkbox_field('default') . __('text set default'));
      $contents[] = array('class' => 'button_nav','text' => tep_image_submit('button_update.gif', IMAGE_UPDATE) . ' <a class="button" href="' . tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','lID')).'lID=' . $lInfo->languages_id) . '">' .  IMAGE_CANCEL . '</a>');
      break;
    case 'delete':
      $heading[] = array('text' => __('text info heading delete language') );

      $contents[] = array('text' => __('text info delete intro'));
      $contents[] = array('text' => '<strong>' . $lInfo->name . '</strong>');
      $contents[] = array('class' => 'button_nav','text' => ((self::$remove_language) ? '<a class="button" href="' . tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','lID')). 'lID=' . $lInfo->languages_id . '&amp;action=deleteconfirm') . '">' .  IMAGE_DELETE . '</a>' : '') . ' <a class="button" href="' . tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','lID')). 'lID=' . $lInfo->languages_id) . '">' .  IMAGE_CANCEL . '</a>');
      break;
    default:
      if (is_object($lInfo)) {
        $heading[] = array('text' => $lInfo->name );

        $contents[] = array('class' => 'button_nav','text' => '<a class="button" href="' . tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','lID')). 'lID=' . $lInfo->languages_id . '&amp;action=edit') . '">' .  IMAGE_EDIT . '</a> <a class="button" href="' . tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','lID')). 'lID=' . $lInfo->languages_id . '&amp;action=delete') . '">' .  IMAGE_DELETE . '</a>');
//         $contents[] = array('class' => 'button_nav','text' => '<a class="button" href="' . tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','lngdir')).'lngdir=' . $lInfo->directory) . '">' . IMAGE_DETAILS . '</a>');
        $contents[] = array('text' => __('text info language name') . $lInfo->name);
        $contents[] = array('text' => __('text info language code') . $lInfo->code);
        $contents[] = array('text' => __('text info language image') . tep_image(DIR_WS_CATALOG_LANGUAGES . $lInfo->directory . '/images/' . $lInfo->image, $lInfo->name));
        $contents[] = array('text' => __('text info language directory').'<br />'
	  .(is_dir(DIR_FS_ADMIN.DIR_WS_LANGUAGES.$lInfo->directory) ?'- '. DIR_WS_ADMIN.DIR_WS_LANGUAGES . '<strong>' . $lInfo->directory . '</strong>'.'<br />' : '')
	  .(is_dir(DIR_FS_CATALOG.DIR_WS_LANGUAGES.$lInfo->directory) ?  '- '. DIR_WS_CATALOG_LANGUAGES . '<strong>' . $lInfo->directory . '</strong>'.'<br />' : '')
	);
        $contents[] = array('text' => __('text info language sort order') . $lInfo->sort_order);
      }
      break;
  }


    echo '<div class="box_right">';
      if ( (tep_not_null($heading)) && (tep_not_null($contents)) ) {
	$box = new box;
	echo $box->infoBox($heading, $contents);
      }
    echo '</div>';
  }


}


?>