<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  03/03/11, 20:17
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class cfg_33
  @brief  Champs supplementaire pourles client/membres
	  Extra fields Customers
*/

define('FILENAME_CFG_33',"gparentID=120&gID=33");

Class cfg_33 {
  const FILENAME = FILENAME_CONFIGURATION;
  /**
    @var  object
  */
  public static $fInfo;
  /**
    @var object
  */
  public static $split;
  /**
    @var array
  */
  public static $list;
  /**
    @var int
  */
  public static $cID;
  /**
    @var int
  */
  public static $fields_query_numrows;

  /**
  */
  function __construct(){
    $this->code='cfg_33';

    global $messageStack, $language ,$oscss;
    $oscss=oscss_cstr::getInstance();
    $oscss->pile_file_lang(DIR_FS_ADMIN.DIR_WS_LANGUAGES.$language.'/modules/configuration/'.$this->code.'.txt');

    self::$cID=(isset($_GET['cID'])?$_GET['cID']:'');
  }


  /**
    Action en remplacement des action par defaut
  */
  public function draw_action(){
    global $action,$messageStack;

  if (tep_not_null($action)) {
    switch ($action) {
        case 'insert':
        case 'update':
            if (isset(self::$cID)) $fields_id = tep_db_prepare_input(self::$cID);

        $fields_input_type = tep_db_prepare_input($_POST['fields_input_type']);
        $fields_input_value = tep_db_prepare_input($_POST['fields_input_value']);
        $fields_required_status =  tep_db_prepare_input($_POST['fields_required_status']);
        $fields_size = tep_db_prepare_input($_POST['fields_size']);
        $fields_required_email = tep_db_prepare_input($_POST['fields_required_email']);
        $fields_key =  tep_db_prepare_input($_POST['fields_key']);
        $fields_admin = tep_db_prepare_input($_POST['fields_admin']);
        $fields_special_mod = tep_db_prepare_input($_POST['fields_special_mod']);
	$fields_group_class = tep_db_prepare_input($_POST['fields_group_class']);
        $sql_data_array = array('fields_status' => 1,
                                'fields_input_type' => $fields_input_type,
                                'fields_input_value' => $fields_input_value,
                                'fields_required_status' => $fields_required_status,
                                'fields_size' => $fields_size,
                                'fields_required_email' => $fields_required_email,
				'fields_key' => $fields_key,
                                'fields_admin' => $fields_admin,
                                'fields_special_mod' => $fields_special_mod,
				'fields_group_class' => $fields_group_class);

        if ($action == 'insert') {
	  $res=tep_db_perform(TABLE_EXTRA_FIELDS, $sql_data_array);
	  $fields_id = tep_db_insert_id($res);
        } elseif ($action == 'update') {
	  tep_db_perform(TABLE_EXTRA_FIELDS, $sql_data_array, 'update', "fields_id = '" . (int)$fields_id . "'");
        }

        $languages = tep_get_languages();
        for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
            $fields_name_array = $_POST['fields_name'];
            $language_id = $languages[$i]['id'];

            $sql_data_array = array('fields_name' => tep_db_prepare_input($fields_name_array[$language_id]));

            if ($action == 'insert') {
                $insert_sql_data = array('fields_id' => $fields_id,
                                         'languages_id' => $language_id);

                $sql_data_array = array_merge($sql_data_array, $insert_sql_data);

                tep_db_perform(TABLE_EXTRA_FIELDS_INFO, $sql_data_array);
            } elseif ($action == 'update') {
                tep_db_perform(TABLE_EXTRA_FIELDS_INFO, $sql_data_array, 'update', "fields_id = '" . (int)$fields_id . "' and languages_id = '" . (int)$language_id . "'");
            }
        }
        tep_redirect(tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','fID'),false)  . 'fID=' . $fields_id));
        break;
        case 'deleteconfirm':
            $fields_id = tep_db_prepare_input(self::$cID);

            tep_db_query("delete from " . TABLE_EXTRA_FIELDS . " where fields_id = '" . (int)$fields_id . "'");
            tep_db_query("delete from " . TABLE_EXTRA_FIELDS_INFO . " where fields_id = '" . (int)$fields_id . "'");
            tep_db_query("delete from " . TABLE_CUSTOMERS_TO_EXTRA_FIELDS . " where fields_id = '" . (int)$fields_id . "'");

            tep_redirect(tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action'),false) ));
            break;
        case 'setflag':
            $fields_id = tep_db_prepare_input(self::$cID);
            $flag = tep_db_prepare_input($_GET['flag']);

            $sql_data_array = array('fields_status' => $flag);
            tep_db_perform(TABLE_EXTRA_FIELDS, $sql_data_array, 'update', "fields_id = '" . (int)$fields_id . "'");

            tep_redirect(tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action'),false)));
	break;
	case 'new':
	  $fields=array(
	      'fields_id'=>'',
	      'fields_size'=>'',
	      'fields_input_type'=>'',
	      'fields_input_value'=>'',
	      'fields_required_status'=>'',
	      'fields_name'=>'',
	      'fields_status'=>'',
	      'fields_input_type'=>'',
	      'fields_required_email'=>'',
	      'fields_key'=>'',
	      'fields_admin'=>'',
	      'fields_special_mod'=>'',
	      'fields_group_class'=>''
	      );
	  self::$fInfo = new objectInfo($fields);
    }
  }
  }

  /**
  */
  public function load_db_values(){
    global $action,$languages_id,$messageStack;
    $list=array();
    self::$fields_query_numrows=0;
    $this->fields_query_raw = "select ce.fields_id, ce.fields_size, ce.fields_input_type, ce.fields_input_value, ce.fields_required_status, cei.fields_name, ce.fields_status, ce.fields_input_type, ce.fields_required_email, ce.fields_key, ce.fields_admin, ce.fields_special_mod, ce.fields_group_class from " . TABLE_EXTRA_FIELDS . " ce, " . TABLE_EXTRA_FIELDS_INFO . " cei where cei.fields_id=ce.fields_id and cei.languages_id =" . (int)$languages_id;
    self::$split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $this->fields_query_raw, self::$fields_query_numrows);
    $this->fields_query = tep_db_query($this->fields_query_raw);

    while ($fields = tep_db_fetch_array($this->fields_query)) {
      if (!isset(self::$cID) || (isset(self::$cID) && (self::$cID == $fields['fields_id'])))  self::$fInfo = new objectInfo($fields);

      $list[]=new objectInfo($fields);
    }
    return $list;
  }

  /**
    Appelé dans le header de page
  */
  public static function draw_header(){
  }

  /**
    Contenu central
  */
  public function draw(){
    global $action,$gparentID,$current_theme;


    switch($action){
      case 'delete':
	$this->load_db_values();
	return tep_get_include_contents(__CLASS__.'.delete');
      break;
      case 'new':
      case 'edit':
	$this->load_db_values();
	$languages = tep_get_languages();
	return tep_get_include_contents(__CLASS__.'.edit');
      break;
      default:
	self::$list=$this->load_db_values();
	return tep_get_include_contents(__CLASS__.'.listing');
    }

  }


/** Sepcific function class */

  /**
    @brief get_item_action($item)
    @brief content col action
    @param $item arrau , detail ligne
  */
  public static function get_item_action($item){
    return  sprintf(
		  CsrtAction::getFormat('row_action'),
		  '' ,
		  sprintf(CsrtAction::getLink('row_action_right', IMAGE_EDIT, 'edit'), '',  tep_href_link(self::FILENAME,FILENAME_CFG_33.'&cID=' . $item->fields_id . '&amp;action=edit') ,'' ).
		  sprintf(CsrtAction::getLink('row_action_right', IMAGE_DELETE, 'delete'), 'fancy',  tep_href_link(self::FILENAME, FILENAME_CFG_33.'&cID=' . $item->fields_id . '&amp;action=delete') ,'' )
		);
  }


  public static function get_customers_extra_fields_name($fields_id, $language_id) {
    $fields_query = tep_db_query("select fields_name from " . TABLE_EXTRA_FIELDS_INFO . " where fields_id = '" . (int)$fields_id . "' and languages_id = '" . (int)$language_id . "'");
    $fields = tep_db_fetch_array($fields_query);

    return $fields['fields_name'];
  }
}

?>