<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package oscss-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  18/11/10, 11:28
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8

  @class cfg_36

  Information systeme
*/

Class cfg_36{

  /**
    Le contructeur, init la class, et ce charge de l'appel vers le fichier de langues
  */
  function __construct(){
    global $lang;
    $this->code='cfg_36';

    global $messageStack, $language,$oscss;

    $oscss=oscss_cstr::getInstance();
    $oscss->pile_file_lang(DIR_FS_ADMIN.DIR_WS_LANGUAGES.$language.'/modules/configuration/'.$this->code.'.txt');
  }


  /**
    Action en remplacement des action par defaut
  */
  public function draw_action(){
  }

  /**
    Ce charge appel db pour recuperer les valeurs
  */
  public function load_db_values(){
    global $action,$languages_id;
    return tep_get_system_information();
  }

  /**
    Appelé dans le header de page
  */
  public static function draw_header(){
    if (function_exists('ob_start')) {
      echo '<style type="text/css">
      td, th {font-family: sans-serif; font-size: 10px;}
      .center {margin: 0 auto; width: 600px;}
      .p {text-align: left;}
      .e {background-color: #ccccff; font-weight: bold;}
      .h {background-color: #9999cc; font-weight: bold;}
      .v {background-color: #cccccc;}
      i {color: #666666;}
      hr {display: none;}
      h4 {margin: 0 auto; width: 600px;}
      </style>';
    }
  }

  /**
    Contenu central
  */
  public function draw(){
    global $action,$gparentID,$current_theme;

    $system = $this->load_db_values();

     echo
      '<h3>'.__('heading title').'</h3>'."\n".
      '<div style="width:98%; margin:0 auto; clear:both;">'."\n".
      '<table style="width:100%" class="dataTable2">'."\n".
      ' <tbody>'."\n".
        '<tr>'."\n".
          '<td><strong>'.__('title server host').'</strong></td>'."\n".
          '<td>'. $system['host'] . ' (' . $system['ip'] . ')'.'</td>'."\n".
          '<td><strong>'.__('title database host').'</strong></td>'."\n".
          '<td>'.$system['db_server'] . ' (' . $system['db_ip'] . ')'.'</td>'."\n".
        '</tr>'."\n".
        '<tr>'."\n".
          '<td><strong>'.__('title server os').'</strong></td>'."\n".
          '<td>'.$system['system'] . ' ' . $system['kernel'].'</td>'."\n".
          '<td><strong>'.__('title database').'</strong></td>'."\n".
          '<td>'.$system['db_version'].'</td>'."\n".
        '</tr>'."\n".
        '<tr>'."\n".
          '<td><strong>'. __('title server date').'</strong></td>'."\n".
          '<td>'. $system['date'].'</td>'."\n".
          '<td><strong>'. __('title database date').'</strong></td>'."\n".
          '<td>'. $system['db_date'].'</td>'."\n".
        '</tr>'."\n".
        '<tr>'."\n".
          '<td><strong>'. __('title server up time').'</strong></td>'."\n".
          '<td colspan="3">'. $system['uptime'].'</td>'."\n".
        '</tr>'."\n".
        '<tr>'."\n".
          '<td><strong>'.__('title http server').'</strong></td>'."\n".
          '<td colspan="3">'. $system['http_server'].'</td>'."\n".
        '</tr>'."\n".
        '<tr>'."\n".
          '<td><strong>'.__('title php version').'</strong></td>'."\n".
          '<td colspan="3">'. $system['php'] . ' (' . __('title zend version'). ' ' . $system['zend'] . ')'.'</td>'."\n".
        '</tr>'."\n".
      '</tbody>'."\n".
      '</table>'."\n";
      if (function_exists('ob_start')) {
        ob_start();
        phpinfo();
        $phpinfo = ob_get_contents();
        ob_end_clean();

        $phpinfo = str_replace('border: 1px', '', $phpinfo);
        $phpinfo = str_replace('border="0"', '', $phpinfo);
        $phpinfo = str_replace('font', 'span', $phpinfo);
        preg_match("#<body>(.*)</body>#s", $phpinfo, $regs);
        echo '<h4>' . tep_image(DIR_WS_IMAGES . 'oscss_logo.png', 'osCSS') . PROJECT_VERSION . '</h4>';
        echo $regs[1];
      } else {
        phpinfo();
      }

    print '</div>'."\n";

  }
}

?>