<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  20/09/10, 21:29
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class cfg_37

  Gestion du cache
*/

Class cfg_37 /*implements ext_configuration*/{

  /**
    @p array list
  */
  public static $liste;
  /**
    @p numeric size total cache
  */
  public static $size=0;

  /**
    Le contructeur, init la class, et ce charge de l'appel vers le fichier de langues
  */
  function __construct(){
    $this->code='cfg_37';

    global  $language,$oscss;

    $oscss=oscss_cstr::getInstance();
    $oscss->pile_file_lang(DIR_FS_ADMIN.DIR_WS_LANGUAGES.$language.'/modules/configuration/'.$this->code.'.txt');
  }


  /**
    Action en remplacement des action par defaut
  */
  public function draw_action(){
    global $action,$messageStack;
    $cached_files= $this->load_db_values();
    switch ($action) {
      case 'reset':
	if (isset($_GET['cache']) && !empty($_GET['cache'])) {
          if ($_GET['cache']=='All'){
	     foreach($cached_files as $cache => $stats) {
		osCSS_Cache::clear($cache, (($stats['pos']=='BO')? true:false) );
	     }
	  }
	  else osCSS_Cache::clear($_GET['cache'], (($_GET['pos']=='BO')? true:false) );
        }

        tep_redirect(tep_href_link(FILENAME_CONFIGURATION, tep_get_all_get_params(array('action','cache','pos'), false )));
        break;
    }

  }

  /**
    Ce charge appel db pour recuperer les valeurs
  */
  public function load_db_values($ID=''){
    global $action,$languages_id;
    $cached_files = array();

    $dir=DIR_FS_WORK;
    foreach (scan($dir) as $file) {
      $last_modified = filemtime($dir . '/' . $file);
      self::$size +=filesize($dir . '/' . $file);
      if (strpos($file, '-') !== false)$code = substr($file, 0, strpos($file, '-'));
      else $code = substr($file, 0, strpos($file, '.'));

      if (isset($cached_files[$code])) {
	$cached_files[$code]['total']++;
	if ($last_modified > $cached_files[$code]['last_modified'])$cached_files[$code]['last_modified'] = $last_modified;
      } else {
	$cached_files[$code] = array('total' => 1, 'last_modified' => $last_modified,'mod'=>'FO');
      }
    }
    $dir=DIR_FS_ADMIN.DIR_WS_INCLUDES.'tmp/cache/';
    foreach (scan($dir) as $file) {
      $last_modified = filemtime($dir . '/' . $file);
      self::$size +=filesize($dir . '/' . $file);
      if (strpos($file, '-') !== false)$code = substr($file, 0, strpos($file, '-'));
      else $code = substr($file, 0, strpos($file, '.'));

      if (isset($cached_files[$code])) {
	$cached_files[$code]['total']++;
	if ($last_modified > $cached_files[$code]['last_modified'])$cached_files[$code]['last_modified'] = $last_modified;
      } else {
	$cached_files[$code] = array('total' => 1, 'last_modified' => $last_modified, 'pos'=>'BO');
      }
    }

    self::$size = round((self::$size / 1000),2);
    return $cached_files;
  }

  /**
    Appel dans le header de page
  */
  public static function draw_header(){
    global $messageStack;
    // check if the cache directory exists
      if (is_dir(DIR_FS_WORK)) {
	if (!is_writeable(DIR_FS_WORK)) $messageStack->add(__('error cache directory not writeable'), 'error');
      } else {
	$messageStack->add(__('error cache directory does not exist'), 'error');
      }
  }

  /**
    Contenu central
  */
  public function draw(){
    global $action,$gparentID,$current_theme;

    self::$liste = $this->load_db_values();

    return tep_get_include_contents(__CLASS__.'.listing');
  }


}

?>