<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  21/03/11, 18:38
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class customers_birthday
  @brief module cron d'envoi de mail au client dont l'anniversaire et ce jour
*/

class customers_birthday
  implements IntModCronJob{

  /**
    @var boolean active config module
  */
  public $config=false;

  /**
    @var string laert le jour J, or avant l'anniversaire (+2)
  */
  CONST ECART = '+2'; //'+2';

  public function __construct(){
  }


  public function ClassExec($value){
    global $language;

    if (!_cst_bool('ACCOUNT_DOB')) return;

    $bdsql = "SELECT * FROM " . TABLE_CUSTOMERS . " WHERE " .
		  "MONTH(customers_dob)=MONTH(curdate()) AND DAYOFMONTH(customers_dob)=DAYOFMONTH(curdate())".self::ECART;

    $bdqry = tep_db_query($bdsql);

    if (tep_db_num_rows($bdqry) > 0) {
	  while($bdarr = tep_db_fetch_array($bdqry)) {
// 	    echo 'Sent email to '. $bdarr['customers_firstname'] . ' ' . $bdarr['customers_lastname'] . ' ' . tep_date_short($bdarr['customers_dob']) . "\n";

	    $bd_sub = sprintf(__('email subject'), $bdarr['customers_firstname']);
	    $bd_msg = sprintf(__('email content'), $bdarr['customers_firstname'], tep_date_short($bdarr['customers_dob']));

	      $myarray = array(
			'email_use_html'=>_cst_bool('EMAIL_USE_HTML'),
			'subject'=>$bd_sub,
			'message'=>$bd_msg
			);

	    $message_final=emailUtility::post_prepare_email("customers_birthday.tpl",$language,$myarray);

	    tep_mail($bdarr['customers_firstname'], $bdarr['customers_email_address'], $bd_sub, $message_final, STORE_NAME, STORE_OWNER_EMAIL_ADDRESS, '');

	    tep_mail('aurelien scim.com', 'aurelien@oscim.com', $bd_sub, $message_final, STORE_NAME, STORE_OWNER_EMAIL_ADDRESS, '');

	}
    }
  }
}
?>